/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.nintendo;

import nintaco.files.CartFile;
import nintaco.mappers.Mapper;

public class MMC4
extends Mapper {
    private static final long serialVersionUID = 0L;
    private final int[][] chrRegs = new int[2][2];

    public MMC4(CartFile cartFile) {
        super(cartFile, 4, 2);
        this.setPrgBank(3, -1);
    }

    @Override
    public int readVRAM(int address) {
        int value = super.readVRAM(address);
        switch (address & 0xFFF8) {
            case 4056: {
                this.updateChrBank(0, 0);
                break;
            }
            case 4072: {
                this.updateChrBank(0, 1);
                break;
            }
            case 8152: {
                this.updateChrBank(1, 0);
                break;
            }
            case 8168: {
                this.updateChrBank(1, 1);
            }
        }
        return value;
    }

    @Override
    protected void writeRegister(int address, int value) {
        switch (address & 0xF000) {
            case 40960: {
                this.setPrgBank(2, value);
                break;
            }
            case 45056: {
                this.writeChrBank(0, 0, value);
                break;
            }
            case 49152: {
                this.writeChrBank(0, 1, value);
                break;
            }
            case 53248: {
                this.writeChrBank(1, 0, value);
                break;
            }
            case 57344: {
                this.writeChrBank(1, 1, value);
                break;
            }
            case 61440: {
                this.setNametableMirroring(value & 1);
            }
        }
    }

    private void writeChrBank(int bank, int latch, int value) {
        this.chrRegs[bank][latch] = value & 0x1F;
        this.updateChrBank(bank, latch);
    }

    private void updateChrBank(int bank, int latch) {
        this.setChrBank(bank, this.chrRegs[bank][latch]);
    }
}

