/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.nintendo.fds;

import nintaco.files.FdsFile;
import nintaco.mappers.Mapper;
import nintaco.mappers.nintendo.fds.FdsAudio;
import nintaco.util.BitUtil;

public class FdsMapper
extends Mapper {
    private static final long serialVersionUID = 0L;
    private final FdsAudio audio = new FdsAudio();
    private int side;
    private int head;
    private int writeSkip;
    private int irqTimer;
    private int irqTimerResetValue;
    private int irqDiskSeek;
    private int targetSide;
    private int insertDelay;
    private boolean irqTimerEnabled;
    private boolean diskIOEnabled;
    private boolean diskInserted = true;
    private boolean motorOn;
    private boolean readMode;
    private boolean irqByteTransferEnabled;
    private boolean readWriteReady;
    private boolean crcControl;
    private boolean transferReset;
    private boolean irqTimerOccurred;
    private boolean irqLoopTimer;
    private boolean irqByteTransferOccurred;
    private boolean activity;

    public FdsMapper(FdsFile fdsFile) {
        super(fdsFile);
    }

    @Override
    public boolean isDiskActivity() {
        boolean value = this.activity;
        this.activity = false;
        return value;
    }

    @Override
    public boolean isFdsMapper() {
        return true;
    }

    @Override
    public int getDiskSideCount() {
        return this.diskData.length;
    }

    @Override
    public int getDiskSide() {
        return this.diskInserted ? this.side : -1;
    }

    @Override
    public void setDiskSide(int side) {
        if (side >= 0 && side < this.diskData.length) {
            this.targetSide = side;
            this.insertDelay = 0x200000;
            this.diskInserted = false;
        }
    }

    @Override
    public void ejectDisk() {
        this.diskInserted = false;
    }

    @Override
    public void writeMemory(int address, int value) {
        this.memory[address] = value;
        if (this.audio.writeRegister(address, value)) {
            return;
        }
        switch (address) {
            case 16416: {
                this.writeIrqTimerLow(value);
                break;
            }
            case 16417: {
                this.writeIrqTimerHigh(value);
                break;
            }
            case 16418: {
                this.writeIrqTimerEnable(value);
                break;
            }
            case 16419: {
                this.writeMasterIOEnable(value);
                break;
            }
            case 16420: {
                this.writeDataRegister(value);
                break;
            }
            case 16421: {
                this.writeFdsControls(value);
                break;
            }
            case 16422: {
                this.writeExternalConnector(value);
            }
        }
    }

    @Override
    public int readMemory(int address) {
        int value = this.audio.readRegister(address);
        if (value >= 0) {
            return value;
        }
        switch (address) {
            case 16432: {
                return this.readDiskStatusRegister0();
            }
            case 16433: {
                return this.readDataRegister();
            }
            case 16434: {
                return this.readDiskDriveStatusRegister();
            }
            case 16435: {
                return this.readExternalConnector();
            }
        }
        return this.memory[address];
    }

    private void writeIrqTimerLow(int value) {
        this.irqTimerOccurred = false;
        this.updateIrq();
        this.irqTimerResetValue = this.irqTimerResetValue & 0xFF00 | value;
    }

    private void writeIrqTimerHigh(int value) {
        this.irqTimerOccurred = false;
        this.updateIrq();
        this.irqTimerResetValue = this.irqTimerResetValue & 0xFF | value << 8;
    }

    private void writeIrqTimerEnable(int value) {
        this.irqTimerOccurred = false;
        this.updateIrq();
        this.irqTimer = this.irqTimerResetValue;
        this.irqLoopTimer = BitUtil.getBitBool(value, 0);
        this.irqTimerEnabled = BitUtil.getBitBool(value, 1);
    }

    private void writeMasterIOEnable(int value) {
        this.diskIOEnabled = BitUtil.getBitBool(value, 0);
    }

    private void writeDataRegister(int value) {
        if (this.diskInserted && !this.readMode && this.diskIOEnabled && this.head >= 0 && this.head < 65500) {
            if (this.writeSkip > 0) {
                --this.writeSkip;
            } else if (this.head >= 2) {
                this.diskData[this.side][this.head - 2] = value;
                this.activity = true;
            }
        }
    }

    private void writeFdsControls(int value) {
        this.irqByteTransferOccurred = false;
        this.updateIrq();
        boolean priorReadWriteReady = this.readWriteReady;
        this.motorOn = BitUtil.getBitBool(value, 0);
        this.transferReset = BitUtil.getBitBool(value, 1);
        this.readMode = BitUtil.getBitBool(value, 2);
        this.setNametableMirroring(BitUtil.getBit(value, 3));
        this.crcControl = BitUtil.getBitBool(value, 4);
        this.readWriteReady = BitUtil.getBitBool(value, 6);
        this.irqByteTransferEnabled = BitUtil.getBitBool(value, 7);
        if (this.diskInserted) {
            if (!this.readWriteReady) {
                if (priorReadWriteReady && !this.crcControl) {
                    this.irqDiskSeek = 200;
                    this.head -= 2;
                }
                if (this.head < 0) {
                    this.head = 0;
                }
            } else {
                this.irqDiskSeek = 200;
            }
            if (!this.readMode) {
                this.writeSkip = 2;
            }
            if (this.transferReset) {
                this.head = 0;
                this.irqDiskSeek = 200;
            }
        }
    }

    private void writeExternalConnector(int value) {
    }

    private int readDiskStatusRegister0() {
        int value = 0;
        if (this.irqTimerOccurred) {
            value |= 1;
        }
        if (this.irqByteTransferOccurred) {
            value |= 2;
        }
        this.irqTimerOccurred = false;
        this.irqByteTransferOccurred = false;
        this.updateIrq();
        return value;
    }

    private int readDataRegister() {
        int value = 0;
        if (this.diskInserted) {
            value = this.diskData[this.side][this.head];
            this.activity = true;
            if (this.head < 64999) {
                ++this.head;
            }
            this.irqDiskSeek = 150;
            this.irqByteTransferOccurred = false;
            this.updateIrq();
        }
        return value;
    }

    private int readDiskDriveStatusRegister() {
        int value = 0;
        if (!this.diskInserted) {
            value = 7;
        } else if (!this.motorOn || this.transferReset) {
            value = 2;
        }
        return value;
    }

    private int readExternalConnector() {
        return 128;
    }

    private void updateIrq() {
        this.cpu.setMapperIrq(this.irqByteTransferOccurred || this.irqTimerOccurred);
    }

    @Override
    public void update() {
        if (this.irqTimerEnabled && this.irqTimer > 0 && --this.irqTimer == 0) {
            this.irqTimerOccurred = true;
            if (this.irqLoopTimer) {
                this.irqTimer = this.irqTimerResetValue;
            } else {
                this.irqTimerEnabled = false;
            }
            this.updateIrq();
        }
        if (this.irqDiskSeek > 0 && --this.irqDiskSeek == 0 && this.irqByteTransferEnabled) {
            this.irqByteTransferOccurred = true;
            this.updateIrq();
        }
        if (this.insertDelay > 0 && --this.insertDelay == 0) {
            this.side = this.targetSide;
            this.diskInserted = true;
        }
        this.audio.update();
    }

    @Override
    public float getAudioSample() {
        return this.audio.getAudioSample();
    }

    @Override
    public int getAudioMixerScale() {
        return this.audio.getAudioMixerScale();
    }
}

