/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.nintendo.mmc5;

import nintaco.mappers.Audio;
import nintaco.mappers.nintendo.mmc5.MMC5;
import nintaco.mappers.nintendo.mmc5.MMC5PulseGenerator;
import nintaco.tv.TVSystem;
import nintaco.util.BitUtil;

public class MMC5Audio
extends Audio {
    private static final long serialVersionUID = 0L;
    private static final int MIX_RANGE = 25925;
    private static final double NTSC_FREQUENCY = 1789772.7272727273;
    private static final double PAL_FREQUENCY = 1662607.03125;
    private static final double AUDIO_UPDATE_FREQUENCY = 240.0;
    private static final float[] pulseTable = new float[31];
    private static final float[] pcmTable = new float[256];
    private final MMC5 mmc5;
    private final MMC5PulseGenerator pulse1 = new MMC5PulseGenerator();
    private final MMC5PulseGenerator pulse2 = new MMC5PulseGenerator();
    private float audioUpdateThreshold;
    private float audioUpdateTicks;
    private int multiplierA;
    private int multiplierB;
    private int productUpper;
    private int productLower;
    private float pcmValue;
    private boolean pcmIrqEnabled;
    private boolean pcmReadMode;
    private boolean pcmIrq;
    private boolean pulseCycle;

    public static void setVolume(int volume) {
        double pulsePercent = 0.3333333333333333;
        double pulseRange = 8641.666666666666 / (95.52 / (8128.0 / (double)(pulseTable.length - 1) + 100.0));
        for (int i = pulseTable.length - 1; i >= 0; --i) {
            MMC5Audio.pulseTable[i] = MMC5Audio.toFloat((double)volume * 0.9552 / (8128.0 / (double)i + 100.0), pulseRange);
        }
        double pcmPercent = 0.6666666666666667;
        double pcmRange = 17283.333333333336;
        for (int i = pcmTable.length - 1; i >= 0; --i) {
            MMC5Audio.pcmTable[i] = MMC5Audio.toFloat((double)(volume * i) / (100.0 * (double)(pcmTable.length - 1)), 17283.333333333336);
        }
    }

    private static float toFloat(double x, double range) {
        if (x < 0.0) {
            x = 0.0;
        } else if (x > 1.0) {
            x = 1.0;
        }
        return (float)(range * x);
    }

    public MMC5Audio(TVSystem tvSystem) {
        this.mmc5 = null;
        this.setTVSystem(tvSystem);
    }

    public MMC5Audio(MMC5 mmc5) {
        this.mmc5 = mmc5;
        this.setTVSystem(mmc5.getTVSystem());
    }

    public void setTVSystem(TVSystem tvSystem) {
        this.audioUpdateThreshold = (float)((tvSystem == TVSystem.NTSC ? 1789772.7272727273 : 1662607.03125) / 240.0);
    }

    @Override
    public void reset() {
        this.audioUpdateTicks = 0.0f;
        this.multiplierA = 0;
        this.multiplierB = 0;
        this.productUpper = 0;
        this.productLower = 0;
        this.pcmValue = 0.0f;
        this.pcmIrqEnabled = false;
        this.pcmReadMode = false;
        this.pcmIrq = false;
        this.pulseCycle = false;
        this.pulse1.reset();
        this.pulse2.reset();
    }

    public void updatePcmValue(int address, int value) {
        if (this.pcmReadMode && value != 0 && address >= 32768 && address < 49152) {
            this.pcmValue = pcmTable[value];
        }
    }

    @Override
    public int readRegister(int address) {
        switch (address) {
            case 20496: {
                return this.readPcmMode();
            }
            case 20501: {
                return this.readAudioStatus();
            }
            case 20997: {
                return this.productLower;
            }
            case 20998: {
                return this.productUpper;
            }
        }
        return -1;
    }

    @Override
    public boolean writeRegister(int address, int value) {
        switch (address) {
            case 20480: {
                this.pulse1.writeEnvelope(value);
                return true;
            }
            case 20482: {
                this.pulse1.writeTimerReloadLow(value);
                return true;
            }
            case 20483: {
                this.pulse1.writeTimerReloadHigh(value);
                return true;
            }
            case 20484: {
                this.pulse2.writeEnvelope(value);
                return true;
            }
            case 20486: {
                this.pulse2.writeTimerReloadLow(value);
                return true;
            }
            case 20487: {
                this.pulse2.writeTimerReloadHigh(value);
                return true;
            }
            case 20496: {
                this.writePcmMode(value);
                return true;
            }
            case 20497: {
                this.writeRawPcm(value);
                return true;
            }
            case 20501: {
                this.writeAudioStatus(value);
                return true;
            }
            case 20997: {
                this.writeMultiplierA(value);
                return true;
            }
            case 20998: {
                this.writeMultiplierB(value);
                return true;
            }
        }
        return false;
    }

    private void writeMultiplierA(int value) {
        this.multiplierA = value;
        this.updateProduct();
    }

    private void writeMultiplierB(int value) {
        this.multiplierB = value;
        this.updateProduct();
    }

    private void writePcmMode(int value) {
        this.pcmReadMode = BitUtil.getBitBool(value, 0);
        this.pcmIrqEnabled = BitUtil.getBitBool(value, 7);
        if (this.mmc5 != null) {
            this.mmc5.updateIrq();
        }
    }

    private int readPcmMode() {
        int value = this.pcmIrq && this.pcmIrqEnabled ? 128 : 0;
        this.pcmIrq = false;
        if (this.mmc5 != null) {
            this.mmc5.updateIrq();
        }
        return value;
    }

    private void writeRawPcm(int value) {
        if (!this.pcmReadMode && value > 0) {
            this.pcmValue = pcmTable[value];
        }
        boolean bl = this.pcmIrq = value == 0;
        if (this.mmc5 != null) {
            this.mmc5.updateIrq();
        }
    }

    private void writeAudioStatus(int value) {
        this.pulse1.setEnabled(BitUtil.getBitBool(value, 0));
        this.pulse2.setEnabled(BitUtil.getBitBool(value, 1));
    }

    private int readAudioStatus() {
        return (this.pulse2.isEnabled() ? 2 : 0) | (this.pulse1.isEnabled() ? 1 : 0);
    }

    private void updateProduct() {
        int product = this.multiplierA * this.multiplierB;
        this.productUpper = product >> 8 & 0xFF;
        this.productLower = product & 0xFF;
    }

    @Override
    public void update() {
        float f;
        this.audioUpdateTicks += 1.0f;
        if (f >= this.audioUpdateThreshold) {
            this.audioUpdateTicks -= this.audioUpdateThreshold;
            this.pulse1.updateEnvelopeGeneratorAndLengthCounter();
            this.pulse2.updateEnvelopeGeneratorAndLengthCounter();
        }
        if (this.pulseCycle) {
            this.pulse1.update();
            this.pulse2.update();
        }
        this.pulseCycle = !this.pulseCycle;
    }

    public boolean isIrq() {
        return this.pcmIrq && this.pcmIrqEnabled;
    }

    @Override
    public int getAudioMixerScale() {
        return 39610;
    }

    @Override
    public float getAudioSample() {
        return pulseTable[this.pulse1.getValue() + this.pulse2.getValue()] + this.pcmValue;
    }

    static {
        MMC5Audio.setVolume(100);
    }
}

