/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.nintendo.vs;

import nintaco.apu.APU;
import nintaco.apu.AudioProcessor;

public class DualAPU
extends APU {
    private static final long serialVersionUID = 0L;
    private static volatile boolean mainUpdateEnabled;
    private final DualAPU dualAPU;

    public static void setMainUpdateEnabled(boolean mainUpdateEnabled) {
        DualAPU.mainUpdateEnabled = mainUpdateEnabled;
    }

    public static boolean isMainUpdateEnabled() {
        return mainUpdateEnabled;
    }

    public DualAPU() {
        this(null);
    }

    public DualAPU(DualAPU dualAPU) {
        this.dualAPU = dualAPU;
    }

    @Override
    public void update(boolean apuCycle) {
        if (this.dualAPU == null) {
            if (!mainUpdateEnabled) {
                super.update(apuCycle);
            }
        } else if (mainUpdateEnabled) {
            super.update(apuCycle);
        }
    }

    @Override
    public void setAudioProcessor(AudioProcessor audioProcessor) {
        super.setAudioProcessor(audioProcessor);
        if (this.dualAPU != null) {
            this.dualAPU.setAudioProcessor(audioProcessor);
        }
    }

    @Override
    public void reset() {
        super.reset();
        if (this.dualAPU != null) {
            this.dualAPU.reset();
        }
    }
}

