/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.ntdec;

import nintaco.files.CartFile;
import nintaco.mappers.Mapper;
import nintaco.util.BitUtil;

public class Mapper041
extends Mapper {
    private static final long serialVersionUID = 0L;
    private boolean innerChrBankSelectEnabled;

    public Mapper041(CartFile cartFile) {
        super(cartFile, 2, 1);
        this.setPrgBank(1, 0);
    }

    @Override
    public void writeMemory(int address, int value) {
        if ((address & 0xF800) == 24576) {
            this.writeOuterBank(address);
        } else if (address >= 32768) {
            this.writerInnerChrBank(value);
        } else {
            this.memory[address] = value;
        }
    }

    private void writeOuterBank(int address) {
        this.innerChrBankSelectEnabled = BitUtil.getBitBool(address, 2);
        this.setPrgBank(address & 7);
        this.chrBanks[0] = this.chrBanks[0] & 0x6000 | (address & 0x18) << 12;
        this.setNametableMirroring(BitUtil.getBit(address, 5));
    }

    private void writerInnerChrBank(int value) {
        if (this.innerChrBankSelectEnabled) {
            this.chrBanks[0] = this.chrBanks[0] & 0x18000 | (value & 3) << 13;
        }
    }
}

