/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.ntdec;

import nintaco.files.CartFile;
import nintaco.mappers.Mapper;

public class Mapper112
extends Mapper {
    private static final long serialVersionUID = 0L;
    private int[] reg = new int[8];
    private int mirroring;
    private int register;
    private int bank;

    public Mapper112(CartFile cartFile) {
        super(cartFile, 8, 8, 16416, 32768);
    }

    @Override
    public void init() {
        this.bank = 0;
        this.setPrgBanks(6, 2, -2);
    }

    private void updateBanks() {
        this.setNametableMirroring(this.mirroring);
        this.setPrgBank(4, this.reg[0]);
        this.setPrgBank(5, this.reg[1]);
        this.setChrBanks(0, 2, this.reg[2] & 0xFE);
        this.setChrBanks(2, 2, this.reg[3] & 0xFE);
        this.setChrBank(4, (this.bank & 0x10) << 4 | this.reg[4]);
        this.setChrBank(5, (this.bank & 0x20) << 3 | this.reg[5]);
        this.setChrBank(6, (this.bank & 0x40) << 2 | this.reg[6]);
        this.setChrBank(7, (this.bank & 0x80) << 1 | this.reg[7]);
    }

    @Override
    protected void writeRegister(int address, int value) {
        if (address < 24576 || address >= 32768) {
            switch (address) {
                case 32768: {
                    this.register = value & 7;
                    break;
                }
                case 40960: {
                    this.reg[this.register] = value;
                    this.updateBanks();
                    break;
                }
                case 49152: {
                    this.bank = value;
                    this.updateBanks();
                    break;
                }
                case 57344: {
                    this.mirroring = value & 1;
                    this.updateBanks();
                }
            }
        }
    }
}

