/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.pirate;

import nintaco.files.CartFile;
import nintaco.mappers.Mapper;
import nintaco.util.BitUtil;

public class Mapper293
extends Mapper {
    private static final long serialVersionUID = 0L;
    private int mode;
    private int innerBank;
    private int outerBank;

    public Mapper293(CartFile cartFile) {
        super(cartFile, 4, 1);
    }

    @Override
    public void init() {
        this.outerBank = 0;
        this.innerBank = 0;
        this.mode = 0;
        this.setChrBank(0);
        this.updateState();
    }

    @Override
    public void resetting() {
        this.init();
    }

    private void updateState() {
        switch (this.mode) {
            case 0: {
                this.setPrgBank(2, this.innerBank);
                this.setPrgBank(3, 7);
                break;
            }
            case 1: {
                this.setPrgBank(2, this.innerBank & 6);
                this.setPrgBank(3, 7);
                break;
            }
            case 2: {
                this.setPrgBank(2, this.innerBank);
                this.setPrgBank(3, this.innerBank);
                break;
            }
            case 3: {
                this.set2PrgBanks(2, this.innerBank & 6);
            }
        }
    }

    @Override
    protected void setPrgBank(int bank, int value) {
        super.setPrgBank(bank, this.outerBank | value);
    }

    private void writeFirstBanking(int value) {
        this.innerBank = value & 7;
        this.mode = this.mode & 0xFD | (value & 8) >> 2;
        this.updateState();
    }

    private void writeSecondBanking(int value) {
        this.outerBank = (value & 1) << 5 | (value & 0x30) >> 1;
        this.mode = this.mode & 0xFE | (value & 0x40) >> 6;
        this.setNametableMirroring(BitUtil.getBit(value, 7));
        this.updateState();
    }

    @Override
    protected void writeRegister(int address, int value) {
        switch (address >> 13) {
            case 4: {
                this.writeFirstBanking(value);
                this.writeSecondBanking(value);
                break;
            }
            case 5: {
                this.writeSecondBanking(value);
                break;
            }
            case 6: {
                this.writeFirstBanking(value);
            }
        }
    }
}

