/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.piratemmc3;

import java.util.Arrays;
import nintaco.files.CartFile;
import nintaco.mappers.nintendo.MMC3;
import nintaco.util.BitUtil;

public class BMCHPxx
extends MMC3 {
    private static final long serialVersionUID = 0L;
    private final int[] regs = new int[4];
    private int dipSwitches;
    private int unromChr;
    private boolean locked;

    public BMCHPxx(CartFile cartFile) {
        super(cartFile);
    }

    @Override
    public void init() {
        Arrays.fill(this.regs, 0);
        this.unromChr = 0;
        this.locked = false;
        super.init();
    }

    @Override
    public void resetting() {
        this.init();
        this.dipSwitches = this.dipSwitches + 1 & 0xF;
    }

    @Override
    protected void setChrBank(int bank, int value) {
        if (BitUtil.getBitBool(this.regs[0], 2)) {
            switch (this.regs[0] & 3) {
                case 2: {
                    value = this.regs[2] & 0x3E | this.unromChr & 1;
                    break;
                }
                case 3: {
                    value = this.regs[2] & 0x3C | this.unromChr & 3;
                    break;
                }
                default: {
                    value = this.regs[2] & 0x3F;
                }
            }
            value <<= 3;
            for (int i = 7; i >= 0; --i) {
                super.setChrBank(i, value | i);
            }
        } else if (BitUtil.getBitBool(this.regs[0], 0)) {
            super.setChrBank(bank, (this.regs[2] & 0x30) << 3 | value & 0x7F);
        } else {
            super.setChrBank(bank, (this.regs[2] & 0x20) << 3 | value & 0xFF);
        }
    }

    @Override
    protected void setPrgBank(int bank, int value) {
        if (BitUtil.getBitBool(this.regs[0], 2)) {
            if ((this.regs[0] & 0xF) == 4) {
                value = (this.regs[1] & 0x1F) << 1;
                super.setPrgBank(4, value);
                super.setPrgBank(5, value | 1);
                super.setPrgBank(6, value);
                super.setPrgBank(7, value | 1);
            } else {
                value = (this.regs[1] & 0x1E) << 1;
                super.setPrgBank(4, value);
                super.setPrgBank(5, value | 1);
                super.setPrgBank(6, value | 2);
                super.setPrgBank(7, value | 3);
            }
        } else if (BitUtil.getBitBool(this.regs[0], 1)) {
            super.setPrgBank(bank, value & 0xF | (this.regs[1] & 0x18) << 1);
        } else {
            super.setPrgBank(bank, value & 0x1F | (this.regs[1] & 0x10) << 1);
        }
    }

    @Override
    protected void writeMirroring(int value) {
        if (BitUtil.getBitBool(this.regs[0], 2)) {
            this.setNametableMirroring(BitUtil.getBit(this.unromChr, 2));
        } else {
            super.writeMirroring(value & 1);
        }
    }

    @Override
    public int readMemory(int address) {
        return (address & 0xF000) == 20480 ? this.dipSwitches : super.readMemory(address);
    }

    @Override
    public void writeMemory(int address, int value) {
        super.writeMemory(address, value);
        if ((address & 0xF000) == 20480) {
            if (!this.locked) {
                this.regs[address & 3] = value;
                this.locked = BitUtil.getBitBool(value, 7);
                this.updateBanks();
            }
        } else if (address >= 32768 && BitUtil.getBitBool(this.regs[0], 2)) {
            this.unromChr = value;
            this.updateChrBanks();
        }
    }
}

