/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.piratemmc3;

import nintaco.files.CartFile;
import nintaco.mappers.nintendo.MMC3;
import nintaco.util.BitUtil;

public class Mapper187
extends MMC3 {
    private static final long serialVersionUID = 0L;
    private static final int[] security = new int[]{131, 131, 66, 0};
    private final int[] regs = new int[2];

    public Mapper187(CartFile cartFile) {
        super(cartFile);
    }

    @Override
    protected void setChrBank(int bank, int value) {
        if (bank >= 4 == this.chrMode) {
            super.setChrBank(bank, value | 0x100);
        } else {
            super.setChrBank(bank, value);
        }
    }

    @Override
    protected void setPrgBank(int bank, int value) {
        if (BitUtil.getBitBool(this.regs[0], 7)) {
            int b = this.regs[0] & 0x1F;
            if (BitUtil.getBitBool(this.regs[0], 5)) {
                int B = BitUtil.getBitBool(this.regs[0], 6) ? b & 0xFC : b >> 1 << 2;
                super.setPrgBank(4, B);
                super.setPrgBank(5, B | 1);
                super.setPrgBank(6, B | 2);
                super.setPrgBank(7, B | 3);
            } else {
                int B = b << 1;
                super.setPrgBank(4, B);
                super.setPrgBank(5, B | 1);
                super.setPrgBank(6, B);
                super.setPrgBank(7, B | 1);
            }
        } else {
            super.setPrgBank(bank, value & 0x3F);
        }
    }

    @Override
    protected void writeBankSelect(int value) {
        this.regs[1] = 1;
        super.writeBankSelect(value);
    }

    @Override
    protected void writeBankData(int value) {
        if (this.regs[1] != 0) {
            super.writeBankData(value);
        }
    }

    @Override
    public void writeMemory(int address, int value) {
        this.memory[address] = value;
        if (address >= 32768) {
            this.writeRegister(address, value);
        } else if (address == 20480 || address == 24576) {
            this.regs[0] = value;
            this.updatePrgBanks();
        }
    }

    @Override
    public int readMemory(int address) {
        if ((address & 0xF000) == 20480) {
            return security[this.regs[1] & 3];
        }
        return super.readMemory(address);
    }
}

