/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.piratemmc3;

import nintaco.files.CartFile;
import nintaco.mappers.nintendo.MMC3;

public class Mapper208
extends MMC3 {
    private static final long serialVersionUID = 0L;
    private static final int[] LUT = new int[]{89, 89, 89, 89, 89, 89, 89, 89, 89, 73, 25, 9, 89, 73, 25, 9, 89, 89, 89, 89, 89, 89, 89, 89, 81, 65, 17, 1, 81, 65, 17, 1, 89, 89, 89, 89, 89, 89, 89, 89, 89, 73, 25, 9, 89, 73, 25, 9, 89, 89, 89, 89, 89, 89, 89, 89, 81, 65, 17, 1, 81, 65, 17, 1, 0, 16, 64, 80, 0, 16, 64, 80, 0, 0, 0, 0, 0, 0, 0, 0, 8, 24, 72, 88, 8, 24, 72, 88, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 64, 80, 0, 16, 64, 80, 0, 0, 0, 0, 0, 0, 0, 0, 8, 24, 72, 88, 8, 24, 72, 88, 0, 0, 0, 0, 0, 0, 0, 0, 89, 89, 89, 89, 89, 89, 89, 89, 88, 72, 24, 8, 88, 72, 24, 8, 89, 89, 89, 89, 89, 89, 89, 89, 80, 64, 16, 0, 80, 64, 16, 0, 89, 89, 89, 89, 89, 89, 89, 89, 88, 72, 24, 8, 88, 72, 24, 8, 89, 89, 89, 89, 89, 89, 89, 89, 80, 64, 16, 0, 80, 64, 16, 0, 1, 17, 65, 81, 1, 17, 65, 81, 0, 0, 0, 0, 0, 0, 0, 0, 9, 25, 73, 89, 9, 25, 73, 89, 0, 0, 0, 0, 0, 0, 0, 0, 1, 17, 65, 81, 1, 17, 65, 81, 0, 0, 0, 0, 0, 0, 0, 0, 9, 25, 73, 89, 9, 25, 73, 89, 0, 0, 0, 0, 0, 0, 0, 0};
    private final int[] regs = new int[6];

    public Mapper208(CartFile cartFile) {
        super(cartFile);
    }

    @Override
    public void init() {
        this.regs[5] = 3;
        super.init();
    }

    @Override
    protected void setPrgBank(int bank, int value) {
        int b = this.regs[5] << 2;
        super.setPrgBank(4, b);
        super.setPrgBank(5, b | 1);
        super.setPrgBank(6, b | 2);
        super.setPrgBank(7, b | 3);
    }

    @Override
    public int readMemory(int address) {
        if ((address & 0xF800) == 22528) {
            return this.regs[address & 3];
        }
        return super.readMemory(address);
    }

    @Override
    public void writeMemory(int address, int value) {
        this.memory[address] = value;
        if ((address & 0xF000) == 20480) {
            if (address <= 22527) {
                this.regs[4] = value;
            } else {
                this.regs[address & 3] = value ^ LUT[this.regs[4]];
            }
        } else if ((address & 0xD800) == 18432) {
            this.regs[5] = value >> 3 & 2 | value & 1;
            super.updatePrgBanks();
        } else if (address >= this.minRegisterAddress) {
            this.writeRegister(address, value);
        }
    }
}

