/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.taito;

import nintaco.files.CartFile;
import nintaco.mappers.Mapper;
import nintaco.util.BitUtil;

public class TC0690
extends Mapper {
    private static final long serialVersionUID = 0L;
    private int irqReloadValue;
    private boolean irqEnabled;
    private int irqCounter;
    private int irqResetDelay;
    private boolean irqReloadRequest;
    private boolean isTC0690;

    public TC0690(CartFile cartFile) {
        super(cartFile, 8, 6);
    }

    @Override
    public void init() {
        this.setPrgBank(6, -2);
        this.setPrgBank(7, -1);
    }

    @Override
    public int readVRAM(int address) {
        if (address < 4096) {
            return this.chrROM[(this.chrBanks[address >> 11] | address & 0x7FF) & this.chrRomSizeMask];
        }
        if (address < 8192) {
            return this.chrROM[(this.chrBanks[2 + (address >> 10 & 3)] | address & 0x3FF) & this.chrRomSizeMask];
        }
        return this.vram[address];
    }

    @Override
    public void writeMemory(int address, int value) {
        switch (address & 0xE003) {
            case 32768: {
                this.setPrgBank(4, value);
                if (this.isTC0690) break;
                this.setNametableMirroring(BitUtil.getBit(value, 6));
                break;
            }
            case 32769: {
                this.setPrgBank(5, value);
                break;
            }
            case 32770: {
                this.writeChrBank(0, value, 11);
                break;
            }
            case 32771: {
                this.writeChrBank(1, value, 11);
                break;
            }
            case 40960: {
                this.writeChrBank(2, value, 10);
                break;
            }
            case 40961: {
                this.writeChrBank(3, value, 10);
                break;
            }
            case 40962: {
                this.writeChrBank(4, value, 10);
                break;
            }
            case 40963: {
                this.writeChrBank(5, value, 10);
                break;
            }
            case 49152: {
                this.writeIrqReload(value);
                this.isTC0690 = true;
                break;
            }
            case 49153: {
                this.writeIrqClear();
                this.isTC0690 = true;
                break;
            }
            case 49154: {
                this.writeIrqEnable();
                this.isTC0690 = true;
                break;
            }
            case 49155: {
                this.writeIrqAcknowledge();
                this.isTC0690 = true;
                break;
            }
            case 57344: {
                this.setNametableMirroring(BitUtil.getBit(value, 6));
                this.isTC0690 = true;
                break;
            }
            default: {
                this.memory[address] = value;
            }
        }
    }

    private void writeIrqReload(int value) {
        this.irqReloadValue = value ^ 0xFF;
    }

    private void writeIrqClear() {
        this.irqCounter = 0;
        this.irqReloadRequest = true;
    }

    private void writeIrqEnable() {
        this.irqEnabled = true;
    }

    private void writeIrqAcknowledge() {
        this.irqEnabled = false;
        this.cpu.setMapperIrq(false);
    }

    private void writeChrBank(int bank, int value, int shift) {
        this.chrBanks[bank] = value << shift;
    }

    @Override
    public void handlePpuCycle(int scanline, int scanlineCycle, int address, boolean rendering) {
        boolean a12;
        if (this.irqResetDelay > 0) {
            --this.irqResetDelay;
        }
        boolean bl = a12 = (address & 0x1000) != 0;
        if (a12 && this.irqResetDelay == 0) {
            this.irqCounter = this.irqCounter > 0 ? --this.irqCounter : this.irqReloadValue;
            if (this.irqReloadRequest) {
                this.irqReloadRequest = false;
                this.irqCounter = this.irqReloadValue;
            }
            if (this.irqCounter == 0 && this.irqEnabled) {
                this.cpu.setMapperIrq(true);
            }
        }
        if (a12) {
            this.irqResetDelay = 8;
        }
    }
}

