/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.tengen;

import nintaco.files.CartFile;
import nintaco.mappers.Mapper;
import nintaco.util.BitUtil;

public class RAMBO1
extends Mapper {
    private static final long serialVersionUID = 0L;
    protected static final int RL = 16;
    protected static final int R0b = 17;
    protected static final int R1b = 18;
    protected static final int[][] PrgModes = new int[][]{{6, 7, 15, 16}, {15, 6, 7, 16}};
    protected static final int[][] ChrModes = new int[][]{{0, 17, 1, 18, 2, 3, 4, 5}, {0, 8, 1, 9, 2, 3, 4, 5}, {2, 3, 4, 5, 0, 17, 1, 18}, {2, 3, 4, 5, 0, 8, 1, 9}};
    protected int[] R = new int[19];
    protected int prgMode;
    protected int chrMode;
    protected int register;
    protected int cpuCycleCounter;
    protected int irqReloadValue;
    protected int irqCounter;
    protected int irqResetDelay;
    protected boolean irqReloadRequested;
    protected boolean irqCycleMode;
    protected boolean irqEnabled;
    protected boolean updateIrqCounter;

    public RAMBO1(CartFile nesFile) {
        super(nesFile, 8, 8);
        this.R[16] = -1;
    }

    @Override
    protected void writeRegister(int address, int value) {
        switch (address & 0xE001) {
            case 32768: {
                this.writeModes(value);
                break;
            }
            case 32769: {
                this.writeRegister(value);
                break;
            }
            case 40960: {
                this.writeMirroring(value);
                break;
            }
            case 49152: {
                this.writeIrqLatch(value);
                break;
            }
            case 49153: {
                this.writeIrqModeSelectAndReload(value);
                break;
            }
            case 57344: {
                this.writeIrqAcknowledge();
                break;
            }
            case 57345: {
                this.writeIrqEnabled();
            }
        }
    }

    protected void writeRegister(int value) {
        this.R[this.register] = value;
        if (this.register < 2) {
            this.R[this.register + 17] = this.R[this.register] + 1;
        }
        this.updateBanks();
    }

    protected void writeMirroring(int value) {
        this.setNametableMirroring(value & 1);
    }

    protected void writeModes(int value) {
        this.register = value & 0xF;
        this.prgMode = BitUtil.getBit(value, 6);
        this.chrMode = BitUtil.getBit(value, 7) << 1 | BitUtil.getBit(value, 5);
        this.updateBanks();
    }

    protected void updateBanks() {
        this.updatePrgBanks();
        this.updateChrBanks();
    }

    protected void updatePrgBanks() {
        for (int i = 3; i >= 0; --i) {
            this.setPrgBank(i + 4, this.R[PrgModes[this.prgMode][i]]);
        }
    }

    protected void updateChrBanks() {
        for (int i = 7; i >= 0; --i) {
            this.setChrBank(i, this.R[ChrModes[this.chrMode][i]]);
        }
    }

    protected void writeIrqLatch(int value) {
        this.irqReloadValue = value;
    }

    protected void writeIrqModeSelectAndReload(int value) {
        this.irqCycleMode = BitUtil.getBitBool(value, 0);
        this.irqReloadRequested = true;
    }

    protected void writeIrqAcknowledge() {
        this.cpu.setMapperIrq(false);
        this.irqEnabled = false;
    }

    protected void writeIrqEnabled() {
        this.irqEnabled = true;
    }

    protected void handleHorizontalBlank() {
        if (this.irqCounter == 0 || this.irqReloadRequested) {
            this.irqCounter = this.irqReloadValue;
            if (this.irqReloadRequested) {
                this.irqReloadRequested = false;
                ++this.irqCounter;
            }
        } else if (--this.irqCounter == 0 && this.irqEnabled) {
            this.cpu.setMapperIrq(true);
        }
    }

    @Override
    public void update() {
        if (this.irqCycleMode && ++this.cpuCycleCounter == 4) {
            this.cpuCycleCounter = 0;
            this.handleHorizontalBlank();
        }
    }

    @Override
    public void handlePpuCycle(int scanline, int scanlineCycle, int address, boolean rendering) {
        if (!this.irqCycleMode && rendering && scanlineCycle == 264) {
            this.handleHorizontalBlank();
        }
    }
}

