/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.unif.bmc;

import nintaco.files.CartFile;
import nintaco.mappers.Mapper;
import nintaco.util.BitUtil;

public class A65AS
extends Mapper {
    private static final long serialVersionUID = 0L;
    private int register;

    public A65AS(CartFile cartFile) {
        super(cartFile, 4, 1);
    }

    private void updateBanks() {
        if (BitUtil.getBitBool(this.register, 6)) {
            int b = this.register & 0x1E;
            this.setPrgBank(2, b);
            this.setPrgBank(3, b | 1);
        } else {
            this.setPrgBank(2, (this.register & 0x30) >> 1 | this.register & 7);
            this.setPrgBank(3, (this.register & 0x30) >> 1 | 7);
        }
        this.setChrBank(0);
        if (BitUtil.getBitBool(this.register, 7)) {
            this.setNametableMirroring(2 + BitUtil.getBit(this.register, 5));
        } else {
            this.setNametableMirroring(BitUtil.getBit(this.register, 3));
        }
    }

    @Override
    protected void writeRegister(int address, int value) {
        this.register = value;
        this.updateBanks();
    }
}

