/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.unif.bmc;

import nintaco.files.CartFile;
import nintaco.mappers.nintendo.MMC3;

public class BMC411120C
extends MMC3 {
    private static final long serialVersionUID = 0L;
    private boolean mmc3Mode;
    private boolean dip;

    public BMC411120C(CartFile cartFile) {
        super(cartFile);
    }

    @Override
    public void init() {
        this.writeOuterBank(0);
        super.init();
    }

    @Override
    public void resetting() {
        this.dip ^= true;
        this.init();
    }

    private void writeOuterBank(int value) {
        this.mmc3Mode = (value & (this.dip && this.prgRomLength <= 32768 ? 12 : 8)) == 0;
        int outer = value & 7;
        if (this.mmc3Mode) {
            this.setPrgBlock(outer << 4, 15);
        } else {
            this.setPrgBlock(0, -1);
            this.set4PrgBanks(4, (outer << 2 | value >> 4 & 3) << 2);
        }
        this.setChrBlock(outer << 7, 127);
        this.updateBanks();
    }

    @Override
    public void updatePrgBanks() {
        if (this.mmc3Mode) {
            super.updatePrgBanks();
        }
    }

    @Override
    public void writeMemory(int address, int value) {
        if (this.prgRamWritesEnabled && this.prgRamChipEnabled && (address & 0xE000) == 24576) {
            this.writeOuterBank(value);
        }
        super.writeMemory(address, value);
    }
}

