/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.unif.bmc;

import nintaco.files.CartFile;
import nintaco.mappers.Mapper;
import nintaco.util.BitUtil;

public class BMC8013B
extends Mapper {
    private static final long serialVersionUID = 0L;
    private int biosPrg;
    private int romPrg;
    private boolean romMode;

    public BMC8013B(CartFile cartFile) {
        super(cartFile, 4, 1);
    }

    @Override
    public void init() {
        this.romPrg = 0;
        this.biosPrg = 0;
        this.romMode = false;
        this.updateState();
    }

    @Override
    public void resetting() {
        this.init();
    }

    private void updateState() {
        if (this.romMode) {
            this.setPrgBank(2, this.romPrg & 0x70 | this.biosPrg & 0xF);
        } else {
            this.setPrgBank(2, this.biosPrg & 3);
        }
        this.setPrgBank(3, this.romPrg & 0x7F);
        this.setNametableMirroring(this.biosPrg >> 4 & 1);
    }

    @Override
    protected void writeRegister(int address, int value) {
        int reg = address >> 13 & 3;
        if (reg == 0) {
            this.biosPrg = value;
        } else {
            this.romPrg = value;
            this.romMode = BitUtil.getBitBool(reg, 1);
        }
        this.updateState();
    }
}

