/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.unif.bmc;

import nintaco.files.CartFile;
import nintaco.mappers.Mapper;

public class BS5
extends Mapper {
    private static final long serialVersionUID = 0L;
    private final int[] prgRegs = new int[4];
    private final int[] chrRegs = new int[4];
    private int resetData;

    public BS5(CartFile cartFile) {
        super(cartFile, 8, 4);
    }

    @Override
    public void init() {
        this.prgRegs[3] = -1;
        this.prgRegs[2] = -1;
        this.prgRegs[1] = -1;
        this.prgRegs[0] = -1;
        this.updateBanks();
    }

    @Override
    public void resetting() {
        this.resetData = this.resetData + 1 & 3;
        this.prgRegs[3] = -1;
        this.prgRegs[2] = -1;
        this.prgRegs[1] = -1;
        this.prgRegs[0] = -1;
        this.updateBanks();
    }

    @Override
    protected void writeRegister(int address, int value) {
        int register = (address & 0xC00) >> 10;
        switch (address & 0xF000) {
            case 32768: {
                this.chrRegs[register] = address & 0x1F;
                break;
            }
            case 40960: {
                if ((address & 1 << this.resetData + 4) == 0) break;
                this.prgRegs[register] = address & 0xF;
            }
        }
        this.updateBanks();
    }

    private void updateBanks() {
        this.setPrgBank(4, this.prgRegs[0]);
        this.setPrgBank(5, this.prgRegs[1]);
        this.setPrgBank(6, this.prgRegs[2]);
        this.setPrgBank(7, this.prgRegs[3]);
        this.setChrBank(0, this.chrRegs[0]);
        this.setChrBank(1, this.chrRegs[1]);
        this.setChrBank(2, this.chrRegs[2]);
        this.setChrBank(3, this.chrRegs[3]);
        this.setNametableMirroring(0);
    }
}

