/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.unif.unl;

import nintaco.files.CartFile;
import nintaco.mappers.Mapper;

public class EDU2000
extends Mapper {
    private static final long serialVersionUID = 0L;
    private int xramOffset;

    public EDU2000(CartFile cartFile) {
        super(cartFile, 2, 0);
        this.xram = new int[32768];
        this.setNametableMirroring(2);
    }

    @Override
    public int readMemory(int address) {
        if ((address & 0xE000) == 24576) {
            return this.xram[this.xramOffset | address & 0x1FFF];
        }
        return super.readMemory(address);
    }

    @Override
    public void writeMemory(int address, int value) {
        if ((address & 0xE000) == 24576) {
            this.xram[this.xramOffset | address & 0x1FFF] = value;
        } else {
            super.writeMemory(address, value);
        }
    }

    @Override
    protected void writeRegister(int address, int value) {
        this.xramOffset = (value & 0xC0) << 7;
        this.setPrgBank(1, value & 0x1F);
    }
}

