/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.unif.unl;

import nintaco.files.CartFile;
import nintaco.mappers.Mapper;
import nintaco.util.BitUtil;

public abstract class OneBus
extends Mapper {
    protected static final long serialVersionUID = 0L;
    protected static final int[] VB0STable = new int[]{0, 1, 2, 0, 3, 4, 5, 0};
    protected static final int[] Bank2RVIndex = new int[]{4, 4, 5, 5, 0, 1, 2, 3};
    protected static final int[] Bank2AND = new int[]{254, 254, 254, 254, 255, 255, 255, 255};
    protected static final int[] Bank2OR = new int[]{0, 1, 0, 1, 0, 0, 0, 0};
    protected static final int[] MMC3_VT02 = new int[]{8214, 8215, 8210, 8211, 8212, 8213, 16647, 16648};
    protected static final int READ_NORMAL = 0;
    protected static final int READ_BG = 1;
    protected static final int READ_SP = 2;
    protected final int[] RV = new int[7];
    protected final int[] PQ = new int[8];
    protected final int[] ALU = new int[8];
    protected final int consoleType;
    protected boolean PIX16EN;
    protected boolean BK16EN;
    protected boolean SP16EN;
    protected boolean SPEXTEN;
    protected boolean BKEXTEN;
    protected boolean SPOPEN;
    protected boolean V16BEN;
    protected boolean COLCOMP1;
    protected boolean IVRCH;
    protected boolean EVA12S;
    protected boolean PQ2EN;
    protected boolean EVRAMEN;
    protected boolean FWEN;
    protected boolean TSYNEN;
    protected boolean IRQEnabled;
    protected boolean IRQReload;
    protected int BKPAGE;
    protected int VRWB;
    protected int COMR6;
    protected int COMR7;
    protected int PS;
    protected int VA;
    protected int CHRBankMask;
    protected int BGSprConfig;
    protected int IRQType;
    protected int IRQLatch;
    protected int IRQCounter;
    protected int IRQLatency;
    protected int IRQDelay;
    protected int Mirroring;
    protected int MMC3Cmd;
    protected int CHRBase;
    protected int PRGBase;
    protected int v415c;

    public OneBus(CartFile cartFile) {
        super(cartFile, 8, 8);
        this.consoleType = cartFile.getConsole() == 3 ? cartFile.getExtendedConsole() : cartFile.getConsole();
    }

    @Override
    public void init() {
        this.CHRBankMask = 255;
        this.PRGBase = 0;
        this.CHRBase = 0;
        this.PQ[0] = 60;
        this.PQ[1] = 61;
        this.PQ[2] = 0;
        this.PQ[3] = 0;
        this.PQ[4] = 0;
        this.PQ[5] = 0;
        this.PQ[6] = 0;
        this.PQ[7] = 0;
        this.RV[0] = 4;
        this.RV[1] = 5;
        this.RV[2] = 6;
        this.RV[3] = 7;
        this.RV[4] = 0;
        this.RV[5] = 2;
        this.RV[6] = 0;
        this.PS = 0;
        this.COMR7 = 0;
        this.COMR6 = 0;
        this.VRWB = 0;
        this.BKPAGE = 0;
        this.VA = 0;
        this.IRQDelay = 0;
        this.IRQLatency = 0;
        this.IRQCounter = 0;
        this.IRQLatch = 0;
        this.IRQType = 0;
        this.TSYNEN = false;
        this.PQ2EN = false;
        this.FWEN = false;
        this.EVRAMEN = false;
        this.EVA12S = false;
        this.IVRCH = false;
        this.IRQEnabled = false;
        this.IRQReload = false;
        this.MMC3Cmd = 0;
        this.Mirroring = 0;
        this.write2(8208, 0);
        this.updateState();
    }

    @Override
    public void resetting() {
        this.init();
    }

    protected void SetPRG_ROM8(int bank, int value) {
        this.prgBanks[bank >> 1] = this.PRGBase + (value << 13);
    }

    @Override
    public int readVRAM(int address) {
        int CHRData;
        if (address >= 8192) {
            return super.readVRAM(address);
        }
        if (this.IVRCH) {
            return super.readVRAM(0x2000 | address & 0xFFF);
        }
        int PPUBank = address >> 10 ^ this.COMR7;
        int CHRBank = (this.RV[Bank2RVIndex[PPUBank]] & Bank2AND[PPUBank] | Bank2OR[PPUBank]) & this.CHRBankMask | this.RV[6] & ~this.CHRBankMask;
        int ReadType = address >> 10 & 3;
        if (ReadType == 1 && this.BKEXTEN || ReadType == 2 && this.SPEXTEN || ReadType == 0 && (this.BKEXTEN || this.SPEXTEN)) {
            int EVA;
            switch (ReadType) {
                case 1: {
                    EVA = address >> 12 & 3 | (this.EVA12S ? this.Mirroring & 1 : this.BKPAGE) << 2;
                    break;
                }
                case 2: {
                    EVA = address >> 12 & 7;
                    break;
                }
                default: {
                    EVA = this.VRWB;
                }
            }
            CHRBank <<= 3;
            CHRBank |= this.VA & 0xFFFFF8FF;
            CHRBank |= EVA;
        } else {
            CHRBank |= this.VA;
        }
        int CHRAddr = CHRBank << 10;
        if (ReadType == 1 && this.BK16EN || ReadType == 2 && this.SP16EN) {
            if (this.V16BEN) {
                CHRAddr |= address & 0x3FF;
                CHRAddr <<= 1;
                if (this.CHRBase != 0) {
                    CHRAddr = this.CHRBase | CHRAddr & this.CHRBase - 1;
                }
                CHRData = this.chrROM[CHRAddr &= this.chrRomSizeMask];
                CHRData |= this.chrROM[CHRAddr | 1] << 8;
            } else {
                CHRAddr |= address & 0x3F0;
                CHRAddr <<= 1;
                if (this.CHRBase != 0) {
                    CHRAddr = this.CHRBase | CHRAddr & this.CHRBase - 1;
                }
                CHRAddr |= address & 0xF;
                CHRData = this.chrROM[CHRAddr &= this.chrRomSizeMask];
                CHRData |= this.chrROM[CHRAddr | 0x10] << 8;
            }
        } else {
            CHRAddr |= address & 0x3FF;
            if (this.CHRBase != 0) {
                CHRAddr = this.CHRBase | CHRAddr & this.CHRBase - 1;
            }
            CHRData = this.chrROM[CHRAddr & this.chrRomSizeMask];
        }
        return CHRData;
    }

    @Override
    public void writeVRAM(int address, int value) {
        if (this.IVRCH && address < 8192) {
            super.writeVRAM(0x2000 | address & 0xFFF, value);
        } else {
            super.writeVRAM(address, value);
        }
    }

    protected void updateState() {
        int TPAMask = this.PS == 7 ? 255 : 63 >> this.PS;
        int PQ3Mask = ~TPAMask;
        int outerBank = this.PQ[3] & PQ3Mask | this.PQ[7] << 8;
        this.SetPRG_ROM8(8 ^ this.COMR6, this.PQ[0] & TPAMask | outerBank);
        this.SetPRG_ROM8(10, this.PQ[1] & TPAMask | outerBank);
        this.SetPRG_ROM8(0xC ^ this.COMR6, (this.PQ2EN ? this.PQ[2] : 254) & TPAMask | outerBank);
        this.SetPRG_ROM8(14, 0xFF & TPAMask | outerBank);
        this.setPrgBank(3, 0);
        if (this.EVRAMEN) {
            this.setNametableMirroring(4);
        } else {
            this.setNametableMirroring(this.Mirroring & 3);
        }
    }

    protected void write2(int address, int value) {
        int MaskedAddr = address & 0xF3F;
        switch (MaskedAddr) {
            case 0: {
                this.BGSprConfig = value & 0x38;
                super.writeCpuMemory(address, value);
                break;
            }
            case 16: {
                if (this.consoleType < 7) {
                    value &= 0x78;
                }
                if (this.consoleType < 8) {
                    value &= 0x9F;
                }
                this.PIX16EN = BitUtil.getBitBool(value, 7);
                this.BK16EN = BitUtil.getBitBool(value, 6);
                this.SP16EN = BitUtil.getBitBool(value, 5);
                this.SPEXTEN = BitUtil.getBitBool(value, 4);
                this.BKEXTEN = BitUtil.getBitBool(value, 3);
                this.SPOPEN = BitUtil.getBitBool(value, 2);
                this.V16BEN = BitUtil.getBitBool(value, 1);
                this.COLCOMP1 = BitUtil.getBitBool(value, 0);
                super.writeCpuMemory(address, value);
                this.updateState();
                break;
            }
            case 17: {
                this.EVA12S = (value & 3) != 0;
                this.EVRAMEN = BitUtil.getBitBool(value, 3);
                this.updateState();
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                this.RV[MaskedAddr - 18] = value;
                break;
            }
            case 24: {
                this.VA = this.VA & 0xFFFFF8FF | (value >> 4 & 7) << 8;
                this.BKPAGE = BitUtil.getBit(value, 3);
                this.VRWB = value & 7;
                this.updateState();
                break;
            }
            case 26: {
                this.RV[6] = value & 0xF8;
                this.CHRBankMask = 255 >> VB0STable[value & 7];
                break;
            }
            case 28: {
                break;
            }
            case 29: {
                this.RV[4] = 42;
                break;
            }
            case 30: {
                this.RV[5] = 44;
                break;
            }
            case 31: {
                break;
            }
            case 36: {
                break;
            }
            case 76: {
                break;
            }
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: {
                break;
            }
            default: {
                super.writeCpuMemory(address, value);
            }
        }
    }

    protected int read4(int address) {
        switch (address) {
            case 16688: 
            case 16689: 
            case 16690: 
            case 16691: 
            case 16692: 
            case 16693: 
            case 16694: 
            case 16695: {
                return this.ALU[address & 7];
            }
            case 16712: 
            case 16714: 
            case 16719: {
                return 255;
            }
            case 16732: {
                ++this.v415c;
                this.v415c &= 0xFF;
                return this.v415c ^ 0xFF;
            }
            case 16823: {
                return 4;
            }
            case 18596: 
            case 18597: {
                return 1;
            }
        }
        return super.readMemory(address);
    }

    protected void write4(int address, int value) {
        super.writeCpuMemory(address, value);
        switch (address) {
            case 16640: {
                this.VA = this.VA & 0xFFFF87FF | (value & 0xF) << 11;
                this.PQ[7] = this.PQ[7] & 0xFFFFFFF0 | value >> 4;
                this.updateState();
                break;
            }
            case 16641: {
                this.IRQLatch = value;
                break;
            }
            case 16642: {
                this.IRQReload = true;
                break;
            }
            case 16643: {
                this.IRQEnabled = false;
                this.cpu.setMapperIrq(false);
                break;
            }
            case 16644: {
                this.IRQEnabled = true;
                break;
            }
            case 16645: {
                this.COMR7 = (value & 0x80) >> 5;
                this.COMR6 = (value & 0x40) >> 4;
                this.IVRCH = BitUtil.getBitBool(value, 5);
                this.MMC3Cmd = value & 7;
                this.updateState();
                break;
            }
            case 16646: {
                this.Mirroring = value;
                if (this.consoleType < 8) {
                    this.Mirroring &= 1;
                }
                this.updateState();
                break;
            }
            case 16647: 
            case 16648: 
            case 16649: 
            case 16650: {
                this.PQ[address - 16647] = value;
                this.updateState();
                break;
            }
            case 16651: {
                this.PS = value & 7;
                this.FWEN = BitUtil.getBitBool(value, 3);
                this.PQ2EN = BitUtil.getBitBool(value, 6);
                this.TSYNEN = BitUtil.getBitBool(value, 7);
                if (this.consoleType == 8) {
                    this.TSYNEN = true;
                }
                this.updateState();
                super.writeCpuMemory(address, value);
                break;
            }
            case 16688: {
                this.ALU[0] = value;
                break;
            }
            case 16689: {
                this.ALU[1] = value;
                break;
            }
            case 16690: {
                this.ALU[2] = value;
                break;
            }
            case 16691: {
                this.ALU[3] = value;
                break;
            }
            case 16692: {
                this.ALU[4] = value;
                break;
            }
            case 16693: {
                this.ALU[5] = value;
                int result = (this.ALU[5] << 8 | this.ALU[4]) * (this.ALU[1] << 8 | this.ALU[0]);
                this.ALU[0] = result & 0xFF;
                this.ALU[1] = result >> 8 & 0xFF;
                this.ALU[2] = result >> 16 & 0xFF;
                this.ALU[3] = result >> 24 & 0xFF;
                break;
            }
            case 16694: {
                this.ALU[6] = value;
                break;
            }
            case 16695: {
                this.ALU[7] = value;
                int quotient = (this.ALU[3] << 24 | this.ALU[2] << 16 | this.ALU[1] << 8 | this.ALU[0]) / (this.ALU[7] << 8 | this.ALU[6]);
                int remainder = (this.ALU[3] << 24 | this.ALU[2] << 16 | this.ALU[1] << 8 | this.ALU[0]) % (this.ALU[7] << 8 | this.ALU[6]);
                this.ALU[0] = quotient & 0xFF;
                this.ALU[1] = quotient >> 8 & 0xFF;
                this.ALU[2] = quotient >> 16 & 0xFF;
                this.ALU[3] = quotient >> 24 & 0xFF;
                this.ALU[4] = remainder & 0xFF;
                this.ALU[5] = remainder >> 8 & 0xFF;
                this.ALU[6] = 0;
                this.ALU[7] = 0;
            }
        }
    }

    protected void writeMMC3(int address, int value) {
        if (!this.FWEN) {
            switch (address & 0xE001) {
                case 32768: {
                    this.write4(16645, value & 0xFFFFFFDF);
                    break;
                }
                case 32769: {
                    int addr = MMC3_VT02[this.MMC3Cmd];
                    if (addr >> 12 == 2) {
                        this.write2(addr, value);
                        break;
                    }
                    this.write4(addr, value);
                    break;
                }
                case 40960: {
                    this.write4(16646, value & 1);
                    break;
                }
                case 40961: {
                    break;
                }
                case 49152: {
                    this.write4(16641, value);
                    break;
                }
                case 49153: {
                    this.write4(16642, value);
                    break;
                }
                case 57344: {
                    this.write4(16643, value);
                    break;
                }
                case 57345: {
                    this.write4(16644, value);
                }
            }
        }
    }

    @Override
    public int readMemory(int address) {
        return (address & 0xF000) == 16384 ? this.read4(address) : super.readMemory(address);
    }

    @Override
    public void writeCpuMemory(int address, int value) {
        switch (address & 0xF000) {
            case 8192: {
                this.write2(address, value);
                break;
            }
            case 16384: {
                this.write4(address, value);
                break;
            }
            case 32768: 
            case 36864: 
            case 40960: 
            case 45056: 
            case 49152: 
            case 53248: 
            case 57344: 
            case 61440: {
                this.writeMMC3(address, value);
                break;
            }
            default: {
                super.writeCpuMemory(address, value);
            }
        }
    }

    @Override
    public void handlePpuCycle(int scanline, int scanlineCycle, int address, boolean rendering) {
        if ((this.BGSprConfig & 0x38) == 16 && address < 8192) {
            address ^= 0x1000;
        }
        if (this.consoleType == 10 && this.BK16EN && scanline == -1) {
            return;
        }
        if (this.IRQLatency != 0) {
            --this.IRQLatency;
        }
        if (this.IRQDelay != 0 && --this.IRQDelay == 0) {
            this.cpu.setMapperIrq(true);
        }
        if (!this.TSYNEN && (address & 0x1000) != 0 || this.TSYNEN && scanlineCycle == 256 && rendering) {
            if (this.IRQLatency == 0) {
                if (this.IRQCounter == 0 || this.IRQReload) {
                    this.IRQCounter = this.IRQLatch;
                    this.IRQReload = false;
                } else {
                    --this.IRQCounter;
                }
                if (this.IRQCounter == 0 && this.IRQEnabled) {
                    if (this.consoleType == 10 && this.BK16EN) {
                        this.IRQDelay = 32;
                    } else {
                        this.cpu.setMapperIrq(true);
                    }
                }
            }
            this.IRQLatency = 8;
        }
    }

    protected void SetPRGBase(int value) {
        this.PRGBase = value;
        this.updateState();
    }

    protected void SetCHRBase(int value) {
        this.CHRBase = value;
        this.updateState();
    }
}

