/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.unif.unl;

import nintaco.files.CartFile;
import nintaco.mappers.nintendo.MMC3;
import nintaco.util.BitUtil;

public class SHERO
extends MMC3 {
    private static final long serialVersionUID = 0L;
    private boolean chrRamMode;
    private int register;
    private int resetSwitch;

    public SHERO(CartFile cartFile) {
        super(cartFile);
    }

    @Override
    public void resetting() {
        this.resetSwitch ^= 0xFF;
        super.init();
    }

    @Override
    public int readVRAM(int address) {
        if (address < 8192 && !this.chrRamMode && this.chrAddressMask != 0) {
            return this.chrROM[(this.chrBanks[address >> this.chrShift] | address & this.chrAddressMask) & this.chrRomSizeMask];
        }
        return this.vram[address];
    }

    @Override
    public void writeMemory(int address, int value) {
        if (address == 16640) {
            this.register = value;
            this.chrRamMode = BitUtil.getBitBool(value, 6);
            this.updateBanks();
        }
        super.writeMemory(address, value);
    }

    @Override
    public int readMemory(int address) {
        if (address == 16640) {
            return this.resetSwitch;
        }
        return super.readMemory(address);
    }

    @Override
    protected void setChrBank(int bank, int value) {
        switch (bank) {
            case 0: 
            case 1: {
                super.setChrBank(bank, value | (this.register & 8) << 5);
                break;
            }
            case 2: 
            case 3: {
                super.setChrBank(bank, value | (this.register & 4) << 6);
                break;
            }
            case 4: 
            case 5: {
                super.setChrBank(bank, value | (this.register & 1) << 8);
                break;
            }
            default: {
                super.setChrBank(bank, value | (this.register & 2) << 7);
            }
        }
    }
}

