/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.waixing;

import nintaco.files.CartFile;
import nintaco.mappers.Mapper;
import nintaco.util.BitUtil;

public class Education
extends Mapper {
    private static final long serialVersionUID = 0L;
    private int low;
    private int low1;
    private int high;
    private int xramBank;
    private boolean setInvidiualBanks;
    private boolean useLow1;

    public Education(CartFile cartFile) {
        super(cartFile, 4, 1);
        this.xram = new int[32768];
    }

    @Override
    public void init() {
        this.low = 0;
        this.low1 = 0;
        this.high = 0;
        this.xramBank = 0;
        this.setInvidiualBanks = false;
        this.useLow1 = false;
        this.updateBanks();
        this.setChrBank(0);
    }

    @Override
    public void resetting() {
        this.init();
    }

    @Override
    public int readMemory(int address) {
        if ((address & 0xE000) == 24576) {
            return this.xram[this.xramBank | address & 0x1FFF];
        }
        return super.readMemory(address);
    }

    @Override
    public void writeMemory(int address, int value) {
        this.memory[address] = value;
        if ((address & 0xE000) == 24576) {
            this.xram[this.xramBank | address & 0x1FFF] = value;
        } else if ((address & 0xF800) == 18432) {
            switch (address & 3) {
                case 0: {
                    this.setInvidiualBanks = BitUtil.getBitBool(value, 1);
                    this.useLow1 = BitUtil.getBitBool(value, 2);
                    this.setNametableMirroring(value & 1);
                    this.updateBanks();
                    break;
                }
                case 1: {
                    this.low = value & 7;
                    this.low1 = 6 | value & 1;
                    this.updateBanks();
                    break;
                }
                case 2: {
                    this.high = value << 3;
                    this.updateBanks();
                    break;
                }
                case 3: {
                    this.xramBank = (value & 3) << 13;
                }
            }
        }
    }

    private void updateBanks() {
        if (this.setInvidiualBanks) {
            this.setPrgBank(2, this.high | this.low);
            if (this.useLow1) {
                this.setPrgBank(3, this.high | this.low1);
            } else {
                this.setPrgBank(3, this.high | 7);
            }
        } else {
            int bank = this.high | this.low;
            if (this.useLow1) {
                this.setPrgBank(2, bank);
                this.setPrgBank(3, bank);
            } else {
                this.setPrgBanks(2, 2, bank);
            }
        }
    }
}

