/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.waixing;

import nintaco.files.CartFile;
import nintaco.mappers.nintendo.MMC3;

public class Mapper074
extends MMC3 {
    private static final long serialVersionUID = 0L;
    protected final int minAddress;
    protected final int maxAddress;
    protected final int mask;

    public Mapper074(CartFile cartFile) {
        this(cartFile, 8192, 10240);
    }

    public Mapper074(CartFile cartFile, int minAddress, int maxAddress) {
        super(cartFile);
        this.minAddress = minAddress;
        this.maxAddress = maxAddress;
        this.mask = maxAddress - minAddress - 1;
    }

    @Override
    public void writeVRAM(int address, int value) {
        if (address < 8192) {
            int addr = (this.chrBanks[address >> 10] | address & 0x3FF) & this.chrRomSizeMask;
            if (addr >= this.minAddress && addr < this.maxAddress) {
                this.vram[addr & this.mask] = value;
            }
        } else {
            super.writeVRAM(address, value);
        }
    }

    @Override
    public int readVRAM(int address) {
        if (address < 8192) {
            int addr = (this.chrBanks[address >> 10] | address & 0x3FF) & this.chrRomSizeMask;
            if (addr >= this.minAddress && addr < this.maxAddress) {
                return this.vram[addr & this.mask];
            }
            return super.readVRAM(address);
        }
        return super.readVRAM(address);
    }
}

