/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.waixing;

import nintaco.files.CartFile;
import nintaco.mappers.nintendo.MMC3;
import nintaco.util.BitUtil;

public class Mapper191
extends MMC3 {
    private static final long serialVersionUID = 0L;
    protected final int bit;
    protected final int vramMask;

    public Mapper191(CartFile cartFile) {
        this(cartFile, 17, 2047);
    }

    public Mapper191(CartFile cartFile, int bit, int vramMask) {
        super(cartFile);
        this.bit = bit;
        this.vramMask = vramMask;
    }

    @Override
    public void writeVRAM(int address, int value) {
        if (address < 8192) {
            int addr = this.chrBanks[address >> 10] | address & 0x3FF;
            if (BitUtil.getBitBool(addr, this.bit)) {
                this.vram[addr & this.vramMask] = value;
            } else {
                super.writeVRAM(address, value);
            }
        } else {
            super.writeVRAM(address, value);
        }
    }

    @Override
    public int readVRAM(int address) {
        if (address < 8192) {
            int addr = this.chrBanks[address >> 10] | address & 0x3FF;
            if (BitUtil.getBitBool(addr, this.bit)) {
                return this.vram[addr & this.vramMask];
            }
            return super.readVRAM(address);
        }
        return super.readVRAM(address);
    }
}

