/*
 * Decompiled with CFR 0.152.
 */
package nintaco.netplay.client;

import java.awt.EventQueue;
import java.awt.Window;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import nintaco.App;
import nintaco.Machine;
import nintaco.MachineRunner;
import nintaco.apu.SystemAudioProcessor;
import nintaco.files.IFile;
import nintaco.files.NesFile;
import nintaco.files.NsfFile;
import nintaco.gui.ComboBoxDialog;
import nintaco.gui.InformationDialog;
import nintaco.gui.PasswordDialog;
import nintaco.gui.YesNoDialog;
import nintaco.gui.netplay.client.ClientStatus;
import nintaco.gui.netplay.client.NetplayClientFrame;
import nintaco.gui.netplay.client.NetplayClientPrefs;
import nintaco.input.InputUtil;
import nintaco.input.OtherInput;
import nintaco.input.Ports;
import nintaco.input.other.SetupROB;
import nintaco.mappers.nintendo.vs.VsGame;
import nintaco.movie.Movie;
import nintaco.movie.MovieBlock;
import nintaco.netplay.client.ClientState;
import nintaco.netplay.protocol.ControllerInput;
import nintaco.netplay.protocol.FileResponse;
import nintaco.netplay.queue.QueueElement;
import nintaco.netplay.queue.RingQueue;
import nintaco.palettes.PalettePPU;
import nintaco.palettes.PaletteUtil;
import nintaco.preferences.AppPrefs;
import nintaco.util.BitUtil;
import nintaco.util.CollectionsUtil;
import nintaco.util.PasswordUtil;
import nintaco.util.StreamUtil;
import nintaco.util.ThreadUtil;
import nintaco.util.VersionUtil;

public class NetplayClient
implements Runnable {
    private static final int RETRY_SECONDS = 5;
    private static final long RETRY_MILLIS = TimeUnit.SECONDS.toMillis(5L);
    private static final long HEARTBEAT_MILLIS = TimeUnit.SECONDS.toMillis(1L);
    private final Object writeMonitor = new Object();
    private final Object stateMonitor = new Object();
    private final RingQueue sendQueue = new RingQueue();
    private final RingQueue receiveQueue = new RingQueue();
    private final QueueElement receiveElement = new QueueElement();
    private Thread heartbeatThread;
    private Thread readMessageThread;
    private Thread sendThread;
    private Socket socket;
    private DataInputStream in;
    private DataOutputStream out;
    private ClientState state;
    private Window window;
    private boolean spectator;
    private boolean wasTrackingHistory;
    private volatile Thread mainThread;
    private volatile NetplayClientPrefs prefs;
    private volatile char[] password;
    private volatile byte[] salt;
    private volatile boolean quickSavesEnabled;
    private volatile int playerResponse;
    private volatile int receiveTail;
    private volatile boolean running;
    private volatile boolean retryImmediately;
    private volatile String[] quickSaveNames;

    void addActivity(String activity, Object ... params) {
        NetplayClientFrame clientFrame = App.getNetworkClientFrame();
        if (clientFrame != null) {
            clientFrame.addActivity(activity, params);
        }
    }

    void setClientStatus(ClientStatus status) {
        NetplayClientFrame clientFrame = App.getNetworkClientFrame();
        if (clientFrame != null) {
            clientFrame.setClientStatus(status);
        }
    }

    private NetplayClientFrame getClientFrame() {
        NetplayClientFrame clientFrame = App.getNetworkClientFrame();
        if (clientFrame != null && !clientFrame.isVisible()) {
            clientFrame.setVisible(true);
        }
        if (clientFrame != null) {
            clientFrame.toFront();
        }
        return clientFrame;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void start(char[] password) {
        if (this.mainThread != null) {
            this.stop();
        }
        this.password = password;
        this.mainThread = new Thread((Runnable)this, "Netplay Client Main Thread");
        this.mainThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void run() {
        this.addActivity("Client started.", new Object[0]);
        appPrefs = AppPrefs.getInstance();
        this.wasTrackingHistory = appPrefs.getHistoryPrefs().isTrackHistory();
        if (!this.wasTrackingHistory) {
            appPrefs.getHistoryPrefs().setTrackHistory(true);
            App.setTrackHistory(true);
        }
        this.prefs = appPrefs.getNetplayClientPrefs();
        this.spectator = this.prefs.getPlayer() >= 4;
        App.dispose();
        this.overrideInput();
        this.running = true;
        while (this.running) {
            block31: {
                this.setClientStatus(ClientStatus.CONNECTING);
                try {
                    this.addActivity("Connecting to %s:%d...", new Object[]{this.prefs.getHost(), this.prefs.getPort()});
                    this.socket = new Socket(this.prefs.getHost(), this.prefs.getPort());
                }
                catch (Throwable t) {
                    this.addActivity("Failed to establish connection.", new Object[0]);
                    this.closeSocket();
                    EventQueue.invokeLater((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$run$0(), ()V)((NetplayClient)this));
                }
                try {
                    this.addActivity("Connection established.", new Object[0]);
                    this.setClientStatus(ClientStatus.ONLINE);
                    this.state = ClientState.SLEEP;
                    this.out = new DataOutputStream(new BufferedOutputStream(this.socket.getOutputStream()));
                    this.in = new DataInputStream(new BufferedInputStream(this.socket.getInputStream()));
                    this.heartbeatThread = new Thread((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, heartbeatLoop(), ()V)((NetplayClient)this), "Netplay Client Hearbeat Thread");
                    this.heartbeatThread.start();
                    this.readMessageThread = new Thread((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, readMessageLoop(), ()V)((NetplayClient)this), "Netplay Client Read Message Thread");
                    this.readMessageThread.start();
                    this.sendThread = new Thread((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, sendLoop(), ()V)((NetplayClient)this), "Netplay Client Send Thread");
                    this.sendThread.start();
                    block23: while (this.running) {
                        var3_5 = this.stateMonitor;
                        synchronized (var3_5) {
                            if (this.state == ClientState.DISCONNECTED) {
                                this.addActivity("Disconnected.", new Object[0]);
                                break;
                            }
                            s = this.state;
                            this.state = ClientState.SLEEP;
                        }
                        switch (1.$SwitchMap$nintaco$netplay$client$ClientState[s.ordinal()]) {
                            case 1: {
                                var3_5 = this.stateMonitor;
                                synchronized (var3_5) {
                                    while (this.state == ClientState.SLEEP) {
                                        ThreadUtil.threadWait(this.stateMonitor);
                                    }
                                    ** GOTO lbl74
                                }
                            }
                            case 2: {
                                this.sendPasswordHash();
                                ** GOTO lbl74
                            }
                            case 3: {
                                this.sendRequestPlayer();
                                ** GOTO lbl74
                            }
                            case 4: {
                                this.choosePlayer();
                                ** GOTO lbl74
                            }
                            case 5: {
                                this.sendRequestFile();
                                ** GOTO lbl74
                            }
                            case 6: {
                                ** break;
lbl73:
                                // 1 sources

                                break block31;
                            }
lbl74:
                            // 6 sources

                            default: {
                                continue block23;
                            }
                        }
                    }
                }
                catch (Throwable t) {
                    this.addActivity("Disconnected.", new Object[0]);
                    this.setState(ClientState.DISCONNECTED);
                }
                catch (Throwable var6_8) {
                    throw var6_8;
                }
                finally {
                    this.closeSocket();
                    EventQueue.invokeLater((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$run$0(), ()V)((NetplayClient)this));
                }
            }
            if (!this.running) continue;
            this.setClientStatus(ClientStatus.CONNECTING);
            if (this.retryImmediately) {
                this.addActivity("Will retry immediately...", new Object[0]);
            } else {
                this.addActivity("Will retry in %d seconds...", new Object[]{5});
            }
            this.sendQueue.stop();
            this.receiveQueue.stop();
            App.dispose();
            ThreadUtil.joinAll(new Thread[]{this.heartbeatThread, this.readMessageThread, this.sendThread});
            if (this.retryImmediately) {
                this.retryImmediately = false;
                continue;
            }
            ThreadUtil.sleep(NetplayClient.RETRY_MILLIS);
        }
        InputUtil.clearOverrides();
        this.sendQueue.stop();
        this.receiveQueue.stop();
        App.dispose();
        ThreadUtil.joinAll(new Thread[]{this.heartbeatThread, this.readMessageThread, this.sendThread});
        if (!this.wasTrackingHistory) {
            appPrefs.getHistoryPrefs().setTrackHistory(false);
            App.setTrackHistory(false);
        }
        this.addActivity("Client stopped.", new Object[0]);
        this.setClientStatus(ClientStatus.OFFLINE);
    }

    private void overrideInput() {
        Object object;
        if (this.spectator) {
            object = new int[0][0];
        } else {
            int[][] nArrayArray = new int[1][];
            object = nArrayArray;
            nArrayArray[0] = new int[]{this.prefs.getPlayer(), this.prefs.getInputDevice()};
        }
        InputUtil.setPortDeviceOverrides(object);
    }

    private void heartbeatLoop() {
        try {
            while (this.running) {
                this.send(0);
                ThreadUtil.sleep(HEARTBEAT_MILLIS);
            }
        }
        catch (Throwable t) {
            this.breakConnection();
        }
    }

    private void readMessageLoop() {
        try {
            while (this.running) {
                this.handleMessage(this.in.readUnsignedByte());
            }
        }
        catch (Throwable t) {
            this.breakConnection();
        }
    }

    private void handleMessage(int messageType) throws Throwable {
        switch (messageType) {
            case 0: {
                break;
            }
            case 1: {
                this.handleServerDescription();
                break;
            }
            case 3: {
                this.handleWrongPasswordError();
                break;
            }
            case 4: {
                this.addActivity("User authenticated.", new Object[0]);
                this.setState(ClientState.REQUEST_PLAYER);
                break;
            }
            case 6: {
                this.handlePlayerResponse();
                break;
            }
            case 8: {
                this.handleFileResponse();
                break;
            }
            case 9: {
                this.handleNoFileResponse();
                break;
            }
            case 11: {
                this.handleControllerInput();
                break;
            }
            case 12: {
                this.handleSaveState();
                break;
            }
            case 13: {
                this.handlePlay();
                break;
            }
            case 14: {
                this.handleRewind();
                break;
            }
            case 15: {
                this.handleMovieBlock();
                break;
            }
            case 16: {
                this.handleFrameEnd();
                break;
            }
            case 17: {
                this.handleQuickSaveStateMenuNames();
                break;
            }
            case 20: {
                this.handleShowMessage();
                break;
            }
            default: {
                this.addActivity("Received unknown message type: %d.", messageType);
                this.breakConnection();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendLoop() {
        try {
            QueueElement element = new QueueElement();
            this.sendQueue.start();
            int tail = this.sendQueue.getHead();
            while (this.running) {
                if (this.sendQueue.consume(tail++, element)) {
                    Object object = this.writeMonitor;
                    synchronized (object) {
                        this.out.write(element.messageType);
                        switch (element.dataType) {
                            case INTEGER: {
                                this.out.writeInt(element.value);
                                break;
                            }
                            case BYTES: {
                                StreamUtil.writeRawByteArray(this.out, element.data);
                                break;
                            }
                            case ALL: {
                                this.out.writeInt(element.value);
                                StreamUtil.writeRawByteArray(this.out, element.data);
                            }
                        }
                        this.out.flush();
                        continue;
                    }
                }
                this.addActivity("Send underflow.", new Object[0]);
                this.addActivity("Breaking connection...", new Object[0]);
                this.breakConnection();
                break;
            }
        }
        catch (Throwable t) {
            this.addActivity("Send transmission error.", new Object[0]);
            this.addActivity("Breaking connection...", new Object[0]);
            this.breakConnection();
        }
        finally {
            this.sendQueue.stop();
        }
    }

    private void handleControllerInput() throws Throwable {
        this.receiveQueue.produce(11, this.in.readInt(), StreamUtil.readRawByteArray(this.in));
    }

    private void handlePlay() throws Throwable {
        this.receiveQueue.produce(13);
    }

    private void handleRewind() throws Throwable {
        this.receiveQueue.produce(14, this.in.readInt());
    }

    private void handleMovieBlock() throws Throwable {
        this.receiveQueue.produce(15, StreamUtil.readRawByteArray(this.in));
    }

    private void handleFrameEnd() throws Throwable {
        this.receiveQueue.produce(16);
    }

    private void handleQuickSaveStateMenuNames() throws Throwable {
        this.handleQuickSaveStateMenuNames((String[])StreamUtil.readObject(StreamUtil.readRawByteArray(this.in)));
    }

    private void handleQuickSaveStateMenuNames(String[] quickSaveStateMenuNames) {
        this.quickSaveNames = quickSaveStateMenuNames;
        EventQueue.invokeLater(() -> App.getImageFrame().handleQuickSaveStateMenuNames(quickSaveStateMenuNames, this.quickSavesEnabled));
    }

    private void handleSaveState() throws Throwable {
        VsGame vsGame;
        this.addActivity("Save state received.", new Object[0]);
        IFile file = App.getFile();
        if (file == null) {
            this.addActivity("File closed.", new Object[0]);
            this.addActivity("Breaking connection...", new Object[0]);
            this.breakConnection();
            return;
        }
        this.receiveQueue.stop();
        App.dispose();
        Machine machine = (Machine)StreamUtil.readObject(StreamUtil.readRawByteArray(this.in));
        Ports ports = machine.getMapper().getPorts();
        InputUtil.setOverrides(ports.getConsoleType(), ports.isMultitap());
        InputUtil.setVsGame(null);
        if (file.getFileType() == 1 && (vsGame = ((NesFile)file).getVsGame()) != null) {
            InputUtil.setVsGame(vsGame);
        }
        MachineRunner machineRunner = new MachineRunner(machine);
        new SetupROB(machine.getPPU().getRob()).run(machine);
        App.loadState(file, machineRunner);
        machineRunner.setClient(this);
        this.receiveTail = 0;
        this.receiveQueue.start();
        new Thread(machineRunner).start();
    }

    private void handleFileResponse() throws Throwable {
        FileResponse fileResponse = (FileResponse)StreamUtil.readObject(StreamUtil.readRawByteArray(this.in));
        IFile file = fileResponse.getFile();
        this.receiveQueue.stop();
        App.dispose();
        MachineRunner machineRunner = new MachineRunner(fileResponse.getMachine());
        this.addActivity("File data and save state received.", new Object[0]);
        machineRunner.setClient(this);
        Movie movie = new Movie(file.getFileType() == 1 && ((NesFile)file).isVsDualSystem());
        movie.frameIndex = fileResponse.getMovieFrameIndex();
        machineRunner.setMovie(movie);
        machineRunner.setForwardTime(fileResponse.isForwardTime());
        machineRunner.setCurrentMovieBlock(fileResponse.getCurrentMovieBlock());
        machineRunner.setMovieBlock(fileResponse.getMovieBlock());
        SystemAudioProcessor.setMovie(movie);
        App.setMachineRunner(machineRunner);
        new SetupROB(fileResponse.getMachine().getPPU().getRob()).run(fileResponse.getMachine());
        App.loadState(file, machineRunner);
        App.getImageFrame().updateContentPane(fileResponse.getMachine().getMapper(), file.getFileType() == 4 ? (NsfFile)file : null);
        InputUtil.setOverrides(fileResponse.getConsole(), fileResponse.isMultitap());
        InputUtil.setVsGame(null);
        if (file.getFileType() == 1) {
            boolean paletteUpdated;
            NesFile nesFile = (NesFile)file;
            VsGame vsGame = nesFile.getVsGame();
            if (vsGame != null) {
                InputUtil.setVsGame(vsGame);
                paletteUpdated = PaletteUtil.setVsPPU(vsGame.getPPU());
                if (vsGame.isDualSystemGame()) {
                    App.createSubMonitorFrame();
                }
            } else {
                paletteUpdated = nesFile.isPlaychoice10() ? PaletteUtil.usePlayChoice10PPU() : PaletteUtil.setPalettePPU(PalettePPU._2C02);
            }
            if (paletteUpdated) {
                App.getImageFrame().createPaletteMenu();
            }
        }
        this.handleQuickSaveStateMenuNames(fileResponse.getQuickSaveStateMenuNames());
        App.getImageFrame().setFileInfo(fileResponse.getFileInfo());
        InputUtil.handleSettingsChange();
        this.receiveTail = 0;
        this.receiveQueue.start();
        new Thread(machineRunner).start();
        this.addActivity("Acknowledged received data.", new Object[0]);
        this.sendQueue.produce(10, fileResponse.getFileRequestID());
    }

    private void handleNoFileResponse() throws Throwable {
        this.addActivity("File closed message received.", new Object[0]);
        this.receiveQueue.stop();
        App.dispose();
    }

    private void handlePlayerResponse() throws Throwable {
        this.playerResponse = this.in.readUnsignedByte();
        if (this.playerResponse == 255) {
            int player = this.prefs.getPlayer();
            if (player < 4) {
                this.addActivity("User accepted as player %d.", player + 1);
            } else {
                this.addActivity("User accepted as spectator.", new Object[0]);
            }
            this.setState(ClientState.REQUEST_FILE);
        } else {
            this.addActivity("User player request denied.", new Object[0]);
            this.setState(ClientState.CHOOSE_PLAYER);
        }
    }

    private void handleServerDescription() throws Throwable {
        String version = this.in.readUTF();
        this.salt = StreamUtil.readRawByteArray(this.in);
        this.quickSavesEnabled = this.in.readBoolean() && !this.spectator;
        boolean passwordRequired = !CollectionsUtil.isBlank(this.salt);
        this.addActivity("Received Netplay Server description:", new Object[0]);
        this.addActivity("* Version: %s", version);
        this.addActivity("* Password: %srequired", passwordRequired ? "" : "not ");
        this.addActivity("* Quick saves: %s", this.quickSavesEnabled ? "enabled" : (this.spectator ? "disabled (spectator)" : "disabled"));
        if (!VersionUtil.getVersion().equals(version)) {
            this.addActivity("Incompatible software versions detected.", new Object[0]);
            this.kill();
            EventQueue.invokeLater(() -> this.displayIncompatibilityError(version));
        } else if (passwordRequired) {
            this.setState(ClientState.AUTHENTICATE);
        } else {
            this.setState(ClientState.REQUEST_PLAYER);
        }
    }

    private void handleShowMessage() throws Throwable {
        byte[] data = StreamUtil.readRawByteArray(this.in);
        if (data != null) {
            App.getImageFrame().getImagePane().showMessage(new String(data, StandardCharsets.ISO_8859_1));
        }
    }

    private void handleWrongPasswordError() {
        this.addActivity("Invalid password.", new Object[0]);
        this.prefs.setPasswordHash(null);
        AppPrefs.save();
        this.displayPasswordPrompt(false);
    }

    private void displayIncompatibilityError(String serverVersion) {
        this.window = new InformationDialog((Window)this.getClientFrame(), String.format("<html>The Netplay Server is using a different version of this software.<br/>Synchronize versions to establish a connection.<br/><br/><code>Server version: %s</code><br/><code>Client version: %s</code></html>", serverVersion, VersionUtil.getVersion()), "Incompatible Versions", InformationDialog.IconType.ERROR);
        this.window.setVisible(true);
        this.window = null;
    }

    private int getSinglePlayerIndex() {
        switch (this.playerResponse) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 4: {
                return 2;
            }
            case 8: {
                return 3;
            }
            case 16: {
                return 4;
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void displayAccessDenied(NetplayClientFrame clientFrame) {
        this.addActivity("Netplay server is not accepting remote users.", new Object[0]);
        this.window = new InformationDialog((Window)clientFrame, "The Netplay Server is not accepting remote players or spectators at this time.", "Access Denied", InformationDialog.IconType.ERROR);
        this.window.setVisible(true);
        this.window = null;
        Object object = this.stateMonitor;
        synchronized (object) {
            if (this.state == ClientState.DISCONNECTED) {
                return;
            }
        }
        this.kill();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void displayMultiplePlayersPrompt(NetplayClientFrame clientFrame) {
        this.addActivity("User asked to be a different player.", new Object[0]);
        ArrayList<Integer> playerIndices = new ArrayList<Integer>();
        ArrayList<String> playerNames = new ArrayList<String>();
        int selectedPlayer = this.prefs.getPlayer();
        int player = selectedPlayer + 1;
        for (int i = 0; i < 5; ++i) {
            if (!BitUtil.getBitBool(this.playerResponse, i)) continue;
            playerIndices.add(i);
            playerNames.add(i < 4 ? String.format("Player %d", i + 1) : "Spectator");
        }
        ComboBoxDialog dialog = new ComboBoxDialog((Window)clientFrame, "<html>" + (selectedPlayer < 4 ? "Player " + player + " is not available." : "The Netplay Server is not accepting spectators at this time.") + "<br/><br/>Select an alternative from the list below.</html>", "Choose Player", playerNames);
        this.window = dialog;
        dialog.setVisible(true);
        Object object = this.stateMonitor;
        synchronized (object) {
            if (this.state == ClientState.DISCONNECTED) {
                this.window = null;
                return;
            }
        }
        int inputIndex = dialog.getInputIndex();
        if (dialog.isOk() && inputIndex >= 0) {
            this.addActivity("User selected %s.", playerNames.get(inputIndex));
            this.prefs.setPlayer((Integer)playerIndices.get(inputIndex));
            AppPrefs.save();
            if (clientFrame != null) {
                clientFrame.loadFields();
            }
            this.setState(ClientState.REQUEST_PLAYER);
        } else {
            this.addActivity("User declined change of player.", new Object[0]);
            this.kill();
        }
        this.window = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void displaySinglePlayerPrompt(NetplayClientFrame clientFrame, int playerIndex) {
        YesNoDialog dialog;
        if (playerIndex < 4) {
            int player = playerIndex + 1;
            this.addActivity("User asked to be player %d.", player);
            dialog = this.prefs.getPlayer() == 4 ? new YesNoDialog((Window)clientFrame, "<html>The Netplay Server is not accepting spectators at this time.<br/><br/>Would you like to be player " + player + " instead?</html>", "Select Player") : new YesNoDialog((Window)clientFrame, "<html>Player " + (this.prefs.getPlayer() + 1) + " is not available.<br/><br/>Would you like to be a player " + player + " instead?</html>", "Select Player");
        } else {
            this.addActivity("User asked to be a spectator.", new Object[0]);
            dialog = new YesNoDialog((Window)clientFrame, "<html>The Netplay Server is not accepting remote players at this time.<br/><br/>Would you like to be a spectator instead?</html>", "Select Player");
        }
        this.window = dialog;
        dialog.setVisible(true);
        Object object = this.stateMonitor;
        synchronized (object) {
            if (this.state == ClientState.DISCONNECTED) {
                this.window = null;
                return;
            }
        }
        if (dialog.isYes()) {
            this.addActivity("User accepted change of player.", new Object[0]);
            this.prefs.setPlayer(playerIndex);
            AppPrefs.save();
            if (clientFrame != null) {
                clientFrame.loadFields();
            }
            this.setState(ClientState.REQUEST_PLAYER);
        } else {
            this.addActivity("User declined change of player.", new Object[0]);
            this.kill();
        }
        this.window = null;
    }

    private void choosePlayer() {
        if (EventQueue.isDispatchThread()) {
            NetplayClientFrame clientFrame = this.getClientFrame();
            if (this.playerResponse == 0) {
                this.displayAccessDenied(clientFrame);
            } else {
                int playerIndex = this.getSinglePlayerIndex();
                if (playerIndex >= 0) {
                    this.displaySinglePlayerPrompt(clientFrame, playerIndex);
                } else {
                    this.displayMultiplePlayersPrompt(clientFrame);
                }
            }
        } else {
            EventQueue.invokeLater(this::choosePlayer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void displayPasswordPrompt(boolean authenticationRequired) {
        if (EventQueue.isDispatchThread()) {
            String title = authenticationRequired ? "Authentication Required" : "Invalid Password";
            this.addActivity("User prompted for password.", new Object[0]);
            NetplayClientFrame clientFrame = this.getClientFrame();
            PasswordDialog dialog = new PasswordDialog((Window)clientFrame, (authenticationRequired ? "A password is required to log into the Netplay Server." : "The specified password is incorrect.") + "<br/><br/>Enter password to log into Netplay Server:", title);
            dialog.setPasswordRequired();
            dialog.setRememberPassword(this.prefs.isRememberPassword());
            dialog.setOkButtonText("Login");
            dialog.setOkButtonMnemonic('L');
            this.window = dialog;
            dialog.setVisible(true);
            Object object = this.stateMonitor;
            synchronized (object) {
                if (this.state == ClientState.DISCONNECTED) {
                    this.window = null;
                    return;
                }
            }
            if (dialog.isOk()) {
                this.password = dialog.getPassword();
                this.prefs.setRememberPassword(dialog.isRememberPassword());
                if (dialog.isRememberPassword()) {
                    if (clientFrame != null) {
                        clientFrame.setPassword(this.password);
                    }
                    this.prefs.setPasswordLength(this.password.length);
                } else {
                    this.prefs.setPasswordLength(0);
                }
                AppPrefs.save();
                if (clientFrame != null) {
                    clientFrame.loadFields();
                }
                this.addActivity("User entered password.", new Object[0]);
                this.setState(ClientState.AUTHENTICATE);
            } else {
                this.addActivity("User canceled authentication.", new Object[0]);
                this.kill();
            }
            this.window = null;
        } else {
            EventQueue.invokeLater(() -> this.displayPasswordPrompt(authenticationRequired));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setState(ClientState state) {
        Object object = this.stateMonitor;
        synchronized (object) {
            this.state = state;
            this.stateMonitor.notifyAll();
        }
    }

    public String[] getQuickSaveNames() {
        return this.quickSaveNames;
    }

    public boolean isPlay() {
        return this.peekMessageType(13, true);
    }

    public boolean isRewind() {
        return this.peekMessageType(14, false);
    }

    private boolean peekMessageType(int type, boolean discardOnMatch) {
        if (!this.receiveQueue.consume(this.receiveTail, this.receiveElement)) {
            if (this.receiveQueue.isRunning()) {
                this.addActivity("Failed to peek message type.", new Object[0]);
                this.addActivity("Breaking connection...", new Object[0]);
                this.breakConnection();
            }
            return false;
        }
        if (this.receiveElement.messageType == type) {
            if (discardOnMatch) {
                ++this.receiveTail;
            }
            return true;
        }
        return false;
    }

    public int readMovieFrameIndex() {
        if (!this.receiveQueue.consume(this.receiveTail++, this.receiveElement) || this.receiveElement.messageType != 14) {
            if (this.receiveQueue.isRunning()) {
                this.addActivity("Failed to receive history index.", new Object[0]);
                this.addActivity("Breaking connection...", new Object[0]);
                this.breakConnection();
            }
            return 0;
        }
        return this.receiveElement.value;
    }

    public void readControllerInput(ControllerInput controllerInput) {
        if (!this.receiveQueue.consume(this.receiveTail++, this.receiveElement) || this.receiveElement.messageType != 11) {
            if (this.receiveQueue.isRunning()) {
                this.addActivity("Failed to receive controller input.", new Object[0]);
                this.addActivity("Breaking connection...", new Object[0]);
                controllerInput.input = 0;
                controllerInput.otherInputs = null;
                this.breakConnection();
            }
            return;
        }
        controllerInput.input = this.receiveElement.value;
        this.retryImmediately = true;
        if (this.receiveElement.data == null) {
            controllerInput.otherInputs = null;
        } else {
            try {
                controllerInput.otherInputs = (OtherInput[])StreamUtil.readObject(this.receiveElement.data);
            }
            catch (Throwable t) {
                this.addActivity("Controller input data corrupted.", new Object[0]);
                this.addActivity("Breaking connection...", new Object[0]);
                controllerInput.input = 0;
                controllerInput.otherInputs = null;
                this.breakConnection();
            }
        }
    }

    public void readFrameEnd() {
        if ((!this.receiveQueue.consume(this.receiveTail++, this.receiveElement) || this.receiveElement.messageType != 16) && this.receiveQueue.isRunning()) {
            this.addActivity("Failed to receive end of frame marker.", new Object[0]);
            this.addActivity("Breaking connection...", new Object[0]);
            this.breakConnection();
        }
    }

    public MovieBlock readMovieBlock() {
        if ((!this.receiveQueue.consume(this.receiveTail++, this.receiveElement) || this.receiveElement.messageType != 15) && this.receiveQueue.isRunning()) {
            this.addActivity("Failed to receive history data.", new Object[0]);
            this.addActivity("Breaking connection...", new Object[0]);
            this.breakConnection();
            return null;
        }
        try {
            return (MovieBlock)StreamUtil.readObject(this.receiveElement.data);
        }
        catch (Throwable t) {
            this.addActivity("History data corrupted.", new Object[0]);
            this.addActivity("Breaking connection...", new Object[0]);
            this.breakConnection();
            return null;
        }
    }

    public void writeControllerInput(ControllerInput controllerInput) {
        if (this.running && !this.spectator) {
            this.sendQueue.produce(11, controllerInput.input, (Serializable)controllerInput.otherInputs);
        }
    }

    public void post(int messageType) {
        if (this.running && !this.spectator) {
            this.sendQueue.produce(messageType);
        }
    }

    public void post(int messageType, int value) {
        if (this.running && !this.spectator) {
            this.sendQueue.produce(messageType, value);
        }
    }

    public void post(int messageType, Serializable value) {
        if (this.running && !this.spectator) {
            this.sendQueue.produce(messageType, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void send(int messageType) throws Throwable {
        Object object = this.writeMonitor;
        synchronized (object) {
            this.out.write(messageType);
            this.out.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendPasswordHash() throws Throwable {
        byte[] passwordHash;
        this.addActivity("Authenticating...", new Object[0]);
        if (this.password == null) {
            passwordHash = this.prefs.getPasswordHash();
        } else {
            passwordHash = null;
            this.prefs.setPasswordHash(null);
            AppPrefs.save();
        }
        if (CollectionsUtil.isBlank(this.salt)) {
            this.addActivity("Password not required.", new Object[0]);
            this.setState(ClientState.REQUEST_PLAYER);
            return;
        }
        if (CollectionsUtil.isBlank(this.password)) {
            if (CollectionsUtil.isBlank(passwordHash)) {
                this.displayPasswordPrompt(true);
                return;
            }
        } else if (CollectionsUtil.isBlank(passwordHash)) {
            passwordHash = PasswordUtil.createHash(this.password, this.salt);
            if (this.prefs.isRememberPassword()) {
                this.prefs.setPasswordHash(passwordHash);
                this.prefs.setPasswordLength(this.password.length);
                AppPrefs.save();
            }
        }
        Object object = this.writeMonitor;
        synchronized (object) {
            this.out.write(2);
            StreamUtil.writeRawByteArray(this.out, passwordHash);
            this.out.flush();
        }
    }

    private void sendRequestFile() throws Throwable {
        this.addActivity("Requested file and save state.", new Object[0]);
        this.send(7);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendRequestPlayer() throws Throwable {
        this.addActivity("Requested player options.", new Object[0]);
        Object object = this.writeMonitor;
        synchronized (object) {
            this.out.write(5);
            this.out.writeInt(this.prefs.getPlayer());
            this.out.flush();
        }
    }

    private void closeSocket() {
        try {
            Socket s = this.socket;
            if (s != null) {
                this.socket = null;
                s.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void breakConnection() {
        this.setState(ClientState.DISCONNECTED);
        this.quickSaveNames = null;
        this.closeSocket();
        this.sendQueue.stop();
        this.receiveQueue.stop();
        ThreadUtil.interruptAll(this.heartbeatThread, this.sendThread, this.readMessageThread);
    }

    private void kill() {
        this.running = false;
        this.breakConnection();
        ThreadUtil.interrupt(this.mainThread);
    }

    public void stop() {
        this.kill();
        ThreadUtil.joinAll(this.mainThread, this.readMessageThread, this.sendThread, this.heartbeatThread);
        this.mainThread = null;
        this.readMessageThread = null;
        this.sendThread = null;
        this.heartbeatThread = null;
        this.quickSaveNames = null;
        App.dispose();
    }

    private /* synthetic */ void lambda$run$0() {
        if (this.window != null) {
            this.window.dispose();
            this.window = null;
        }
    }
}

