/*
 * Decompiled with CFR 0.152.
 */
package nintaco.task;

import java.util.ArrayList;
import java.util.List;
import nintaco.task.Task;
import nintaco.util.ThreadUtil;

public class TaskScheduler {
    private final List<Task> tasks = new ArrayList<Task>();
    private final Thread thread = new Thread(this::run, "Task Secheduler Thread");
    private volatile boolean running = true;
    private boolean ready;

    public TaskScheduler() {
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run() {
        while (this.running) {
            Task task = null;
            List<Task> list = this.tasks;
            synchronized (list) {
                this.ready = true;
                this.tasks.notifyAll();
                while (this.running && this.tasks.isEmpty()) {
                    ThreadUtil.threadWait(this.tasks);
                }
                this.ready = false;
                this.tasks.notifyAll();
                if (this.running && !this.tasks.isEmpty()) {
                    task = this.tasks.get(0);
                }
            }
            if (!this.running || task == null) continue;
            try {
                task.run();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                Thread.interrupted();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            list = this.tasks;
            synchronized (list) {
                this.tasks.remove(0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelAll() {
        List<Task> list = this.tasks;
        synchronized (list) {
            for (Task task : this.tasks) {
                task.cancel();
            }
            this.tasks.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForEmpty() {
        List<Task> list = this.tasks;
        synchronized (list) {
            while (this.running && !this.tasks.isEmpty()) {
                ThreadUtil.threadWait(this.tasks);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForReady() {
        List<Task> list = this.tasks;
        synchronized (list) {
            while (this.running && !this.ready) {
                ThreadUtil.threadWait(this.tasks);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Task task) {
        List<Task> list = this.tasks;
        synchronized (list) {
            this.tasks.add(task);
            this.tasks.notifyAll();
        }
    }

    public void dispose() {
        this.running = false;
        this.cancelAll();
        ThreadUtil.threadJoin(this.thread);
    }
}

