/*
 * Decompiled with CFR 0.152.
 */
package nintaco.util;

import java.awt.Desktop;
import java.net.URI;

public final class BrowserUtil {
    private static final String[] BROWSERS = new String[]{"epiphany", "firefox", "mozilla", "konqueror", "netscape", "opera", "links", "lynx"};

    public static void openBrowser(String url) {
        if (!BrowserUtil.openBrowserWithDesktop(url)) {
            BrowserUtil.openBrowserWithRuntime(url);
        }
    }

    private static boolean openBrowserWithRuntime(String url) {
        block7: {
            String os = System.getProperty("os.name").toLowerCase();
            Runtime runtime = Runtime.getRuntime();
            try {
                if (os.contains("win")) {
                    runtime.exec("rundll32 url.dll,FileProtocolHandler " + url);
                    break block7;
                }
                if (os.contains("mac")) {
                    runtime.exec("open" + url);
                    break block7;
                }
                if (os.contains("nix") || os.contains("nux")) {
                    StringBuffer sb = new StringBuffer();
                    for (int i = 0; i < BROWSERS.length; ++i) {
                        if (i > 0) {
                            sb.append(" || ");
                        }
                        sb.append(BROWSERS[i]).append(" \"").append(url).append("\" ");
                    }
                    runtime.exec(new String[]{"sh", "-c", sb.toString()});
                    break block7;
                }
                return false;
            }
            catch (Throwable t) {
                return false;
            }
        }
        return true;
    }

    private static boolean openBrowserWithDesktop(String url) {
        Desktop desktop;
        Desktop desktop2 = desktop = Desktop.isDesktopSupported() ? Desktop.getDesktop() : null;
        if (desktop != null && desktop.isSupported(Desktop.Action.BROWSE)) {
            try {
                desktop.browse(new URI(url));
            }
            catch (Throwable t) {
                return false;
            }
            return true;
        }
        return false;
    }

    private BrowserUtil() {
    }
}

