/*
 * Decompiled with CFR 0.152.
 */
package nintaco.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;

public final class StreamUtil {
    private static final int BYTE_ARRAY_OUTPUT_INITIAL_SIZE = 65536;
    private static final int SPARSE_BLOCK_SIZE = 1024;
    private static final int SPARSE_THRESHOLD = 341;

    private StreamUtil() {
    }

    public static int readByte(InputStream in) throws Throwable {
        int value = in.read();
        if (value < 0) {
            throw new EOFException();
        }
        return value;
    }

    public static String readNullTerminatedString(InputStream in, int blockSize) throws Throwable {
        return StreamUtil.readNullTerminatedString(in, blockSize, 0, true);
    }

    public static String readNullTerminatedString(InputStream in, int blockSize, int startIndex, boolean readUntilBlockEnd) throws Throwable {
        StringBuilder sb = new StringBuilder();
        for (int i = startIndex; i < blockSize; ++i) {
            int ch = in.read();
            if (ch < 0) {
                throw new EOFException();
            }
            if (ch == 0) {
                if (!readUntilBlockEnd) break;
                ++i;
                while (i < blockSize && in.read() >= 0) {
                    ++i;
                }
                break;
            }
            sb.append((char)ch);
        }
        return sb.toString();
    }

    public static String[] readNullTerminatedStrings(InputStream in, int blockSize) throws Throwable {
        return StreamUtil.readNullTerminatedStrings(in, blockSize, Integer.MAX_VALUE);
    }

    public static String[] readNullTerminatedStrings(InputStream in, int blockSize, int maxStrings) throws Throwable {
        String str;
        ArrayList<String> strings = new ArrayList<String>();
        for (int i = 0; i < blockSize; i += str.length() + 1) {
            str = StreamUtil.readNullTerminatedString(in, blockSize, i, false);
            strings.add(str);
            if (strings.size() != maxStrings) continue;
            while (i < blockSize && in.read() >= 0) {
                ++i;
            }
            break block0;
        }
        String[] result = new String[strings.size()];
        strings.toArray(result);
        return result;
    }

    public static int readInt16LE(InputStream in) throws Throwable {
        int b1;
        int b0 = in.read();
        if ((b0 | (b1 = in.read())) < 0) {
            throw new EOFException();
        }
        return b1 << 8 | b0;
    }

    public static int readInt32LE(InputStream in) throws Throwable {
        int b3;
        int b2;
        int b1;
        int b0 = in.read();
        if ((b0 | (b1 = in.read()) | (b2 = in.read()) | (b3 = in.read())) < 0) {
            throw new EOFException();
        }
        return b3 << 24 | b2 << 16 | b1 << 8 | b0;
    }

    public static void readBytes(InputStream in, int[] bytes) throws Throwable {
        StreamUtil.readBytes(in, bytes, 0, bytes.length);
    }

    public static void readBytes(InputStream in, int[] bytes, int offset, int length) throws Throwable {
        for (int i = 0; i < length; ++i) {
            int value = in.read();
            if (value < 0) {
                throw new EOFException();
            }
            bytes[offset + i] = value;
        }
    }

    public static String readString(DataInput in, int length) throws Throwable {
        byte[] data = new byte[length];
        in.readFully(data);
        return new String(data, StandardCharsets.ISO_8859_1);
    }

    public static void writeString(DataOutput out, String str) throws Throwable {
        out.write(str.getBytes(StandardCharsets.ISO_8859_1));
    }

    public static ByteArrayOutputStream toByteArrayOutputStream(Serializable object) {
        if (object == null) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream(65536);
        try (ObjectOutputStream oos = new ObjectOutputStream(baos);){
            oos.writeObject(object);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return baos;
    }

    public static void writeBytes(OutputStream out, int[] bytes) throws IOException {
        StreamUtil.writeBytes(out, bytes, 0, bytes.length);
    }

    public static void writeBytes(OutputStream out, int[] bytes, int offset, int length) throws IOException {
        for (int i = 0; i < length; ++i) {
            int index = i + offset;
            out.write(bytes != null && index < bytes.length ? bytes[index] : 0);
        }
    }

    public static void writeObject(DataOutputStream out, Serializable object) throws Throwable {
        StreamUtil.writeByteArrayOutputStream(out, StreamUtil.toByteArrayOutputStream(object));
    }

    public static void writeByteArrayOutputStream(DataOutputStream out, ByteArrayOutputStream baos) throws IOException {
        out.writeInt(baos.size());
        baos.writeTo(out);
    }

    public static Object readObject(DataInputStream in) throws Throwable {
        byte[] data = new byte[in.readInt()];
        in.readFully(data);
        return StreamUtil.readObject(data);
    }

    public static Object readObject(byte[] data) throws Throwable {
        if (data == null) {
            return null;
        }
        try (ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(data));){
            Object object = ois.readObject();
            return object;
        }
    }

    public static int[] readSparseByteArray(DataInput in) throws IOException {
        int[] data = null;
        int length = in.readInt();
        if (length >= 0) {
            data = new int[length];
            for (int i = 0; i < data.length; i += 1024) {
                StreamUtil.readSparseBlock(in, data, i);
            }
        }
        return data;
    }

    public static void readSparseBlock(DataInput in, int[] data, int index) throws IOException {
        StreamUtil.readSparseBlock(in, data, index, 0);
    }

    public static void readSparseBlock(DataInput in, int[] data, int index, int fill) throws IOException {
        int i;
        int BLOCK_SIZE = Math.min(1024, data.length - index);
        for (i = BLOCK_SIZE - 1; i >= 0; --i) {
            data[i + index] = fill;
        }
        switch (in.readUnsignedByte()) {
            case 0: {
                break;
            }
            case 1: {
                for (i = in.readUnsignedShort() - 1; i >= 0; --i) {
                    short offset = in.readShort();
                    data[offset + index] = in.readUnsignedByte();
                }
                break;
            }
            case 2: {
                for (i = 0; i < BLOCK_SIZE; ++i) {
                    data[i + index] = in.readUnsignedByte();
                }
                break;
            }
        }
    }

    public static void writeSparseByteArray(DataOutput out, int[] data) throws IOException {
        StreamUtil.writeSparseByteArray(out, data, null);
    }

    public static void writeSparseByteArray(DataOutput out, int[] data, int[] source) throws IOException {
        if (data == null) {
            out.writeInt(-1);
        } else {
            out.writeInt(data.length);
            for (int i = 0; i < data.length; i += 1024) {
                StreamUtil.writeSparseBlock(out, data, source, i);
            }
        }
    }

    public static void writeSparseBlock(DataOutput out, int[] data, int index) throws IOException {
        StreamUtil.writeSparseBlock(out, data, null, index);
    }

    public static void writeSparseBlock(DataOutput out, int[] data, int[] source, int index) throws IOException {
        int i;
        int THRESHOLD;
        int BLOCK_SIZE;
        int remaining = data.length - index;
        if (remaining < 1024) {
            BLOCK_SIZE = remaining;
            THRESHOLD = remaining / 3;
        } else {
            BLOCK_SIZE = 1024;
            THRESHOLD = 341;
        }
        int count = 0;
        if (source == null) {
            for (i = BLOCK_SIZE - 1; i >= 0 && (data[i + index] == 0 || ++count < THRESHOLD); --i) {
            }
        } else {
            for (i = BLOCK_SIZE - 1; i >= 0 && (data[i + index] == source[i + index] || ++count < THRESHOLD); --i) {
            }
        }
        if (count == 0) {
            out.writeByte(0);
        } else if (count < THRESHOLD) {
            out.writeByte(1);
            out.writeShort(count);
            if (source == null) {
                for (i = 0; i < BLOCK_SIZE; ++i) {
                    if (data[i + index] == 0) continue;
                    out.writeShort(i);
                    out.writeByte(data[i + index]);
                }
            } else {
                for (i = 0; i < BLOCK_SIZE; ++i) {
                    if (data[i + index] == source[i + index]) continue;
                    out.writeShort(i);
                    out.writeByte(data[i + index]);
                }
            }
        } else {
            out.writeByte(2);
            for (i = 0; i < BLOCK_SIZE; ++i) {
                out.writeByte(data[i + index]);
            }
        }
    }

    public static void writeRawByteArray(DataOutput out, byte[] data) throws IOException {
        if (data == null) {
            out.writeInt(-1);
        } else {
            out.writeInt(data.length);
            out.write(data);
        }
    }

    public static void writeByteArray(DataOutput out, int[] data) throws IOException {
        if (data == null) {
            out.writeInt(-1);
        } else {
            out.writeInt(data.length);
            for (int i = 0; i < data.length; ++i) {
                out.writeByte(data[i]);
            }
        }
    }

    public static void write2DByteArray(DataOutput out, int[][] data) throws IOException {
        if (data == null) {
            out.writeInt(-1);
        } else {
            out.writeInt(data.length);
            for (int i = 0; i < data.length; ++i) {
                StreamUtil.writeByteArray(out, data[i]);
            }
        }
    }

    public static byte[] readRawByteArray(DataInput in) throws IOException {
        int length = in.readInt();
        if (length >= 0) {
            byte[] data = new byte[length];
            in.readFully(data);
            return data;
        }
        return null;
    }

    public static int[] readByteArray(DataInput in) throws IOException {
        int[] data = null;
        int length = in.readInt();
        if (length >= 0) {
            data = new int[length];
            for (int i = 0; i < data.length; ++i) {
                data[i] = in.readUnsignedByte();
            }
        }
        return data;
    }

    public static int[][] read2DByteArray(DataInput in) throws IOException {
        Object data = null;
        int length = in.readInt();
        if (length >= 0) {
            data = new int[length][];
            for (int i = 0; i < ((int[][])data).length; ++i) {
                data[i] = StreamUtil.readByteArray(in);
            }
        }
        return data;
    }

    public static void readByteArray(InputStream in, int[] data) throws IOException {
        StreamUtil.readByteArray(in, data, 0, data.length, false);
    }

    public static void readByteArray(InputStream in, int[] data, int offset, int length) throws IOException {
        StreamUtil.readByteArray(in, data, offset, length, false);
    }

    public static void readByteArray(InputStream in, int[] data, int offset, int length, boolean ignoreEOF) throws IOException {
        for (int i = 0; i < length; ++i) {
            int value = in.read();
            if (value < 0) {
                if (ignoreEOF) {
                    return;
                }
                throw new EOFException();
            }
            data[offset + i] = value;
        }
    }

    public static void copy(InputStream in, OutputStream out, byte[] buffer) throws Throwable {
        int length;
        while ((length = in.read(buffer)) >= 0) {
            out.write(buffer, 0, length);
        }
        in.close();
    }

    private static interface SparseBlockType {
        public static final int EMPTY = 0;
        public static final int SPARSE = 1;
        public static final int FULL = 2;
    }
}

