/*
 * Decompiled with CFR 0.152.
 */
package com.kotcrab.vis.ui.layout;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.WidgetGroup;
import com.badlogic.gdx.scenes.scene2d.utils.Layout;
import com.badlogic.gdx.utils.SnapshotArray;

public class FloatingGroup
extends WidgetGroup {
    private boolean useChildrenPreferredSize = false;
    private float prefWidth = 0.0f;
    private float prefHeight = 0.0f;

    public FloatingGroup() {
        this.setTouchable(Touchable.childrenOnly);
    }

    public FloatingGroup(float prefWidth, float prefHeight) {
        this.setTouchable(Touchable.childrenOnly);
        this.setPrefWidth(prefWidth);
        this.setPrefHeight(prefHeight);
    }

    @Override
    public void layout() {
        if (!this.useChildrenPreferredSize) {
            return;
        }
        SnapshotArray<Actor> children = this.getChildren();
        for (int i = 0; i < children.size; ++i) {
            Actor child = (Actor)children.get(i);
            float width = child.getWidth();
            float height = child.getHeight();
            if (child instanceof Layout) {
                Layout layout = (Layout)((Object)child);
                width = layout.getPrefWidth();
                height = layout.getPrefHeight();
            }
            child.setBounds(child.getX(), child.getY(), width, height);
        }
    }

    public boolean isUseChildrenPreferredSize() {
        return this.useChildrenPreferredSize;
    }

    public void setUseChildrenPreferredSize(boolean useChildrenPreferredSize) {
        this.useChildrenPreferredSize = useChildrenPreferredSize;
        this.invalidate();
    }

    @Override
    public float getPrefWidth() {
        return this.prefWidth < 0.0f ? this.getWidth() : this.prefWidth;
    }

    @Override
    public float getPrefHeight() {
        return this.prefHeight < 0.0f ? this.getHeight() : this.prefHeight;
    }

    public void setPrefWidth(float prefWidth) {
        this.prefWidth = prefWidth;
        this.invalidate();
    }

    public void setPrefHeight(float prefHeight) {
        this.prefHeight = prefHeight;
        this.invalidate();
    }
}

