/*
 * Decompiled with CFR 0.152.
 */
package com.kotcrab.vis.ui.widget;

import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.kotcrab.vis.ui.VisUI;
import com.kotcrab.vis.ui.util.adapter.ListAdapter;
import com.kotcrab.vis.ui.widget.ListViewStyle;
import com.kotcrab.vis.ui.widget.VisScrollPane;
import com.kotcrab.vis.ui.widget.VisTable;

public class ListView<ItemT> {
    private ListAdapter<ItemT> adapter;
    private ItemClickListener<ItemT> clickListener;
    private UpdatePolicy updatePolicy = UpdatePolicy.IMMEDIATELY;
    private boolean dataInvalidated = false;
    private ListViewTable<ItemT> mainTable;
    private VisScrollPane scrollPane;
    private VisTable scrollTable;
    private VisTable itemsTable;
    private Actor header;
    private Actor footer;

    public ListView(ListAdapter<ItemT> adapter) {
        this(adapter, "default");
    }

    public ListView(ListAdapter<ItemT> adapter, String styleName) {
        this(adapter, VisUI.getSkin().get(styleName, ListViewStyle.class));
    }

    public ListView(ListAdapter<ItemT> adapter, ListViewStyle style) {
        if (style == null) {
            throw new IllegalArgumentException("style can't be null");
        }
        if (adapter == null) {
            throw new IllegalArgumentException("adapter can't be null");
        }
        this.adapter = adapter;
        this.mainTable = new ListViewTable(this);
        this.scrollTable = new VisTable();
        this.itemsTable = new VisTable();
        this.scrollPane = new VisScrollPane((Actor)this.scrollTable, style.scrollPaneStyle);
        this.scrollPane.setOverscroll(false, true);
        this.scrollPane.setFlickScroll(false);
        this.scrollPane.setFadeScrollBars(false);
        this.mainTable.add(this.scrollPane).grow();
        adapter.setListView(this, new ListAdapterListener());
        this.rebuildView(true);
    }

    public void rebuildView() {
        this.rebuildView(true);
    }

    private void rebuildView(boolean full) {
        this.scrollTable.clearChildren();
        this.scrollTable.top();
        if (this.header != null) {
            this.scrollTable.add(this.header).growX();
            this.scrollTable.row();
        }
        if (full) {
            this.itemsTable.clearChildren();
            this.adapter.fillTable(this.itemsTable);
        }
        this.scrollTable.add(this.itemsTable).growX();
        this.scrollTable.row();
        if (this.footer != null) {
            this.scrollTable.add(this.footer).growX();
            this.scrollTable.row();
        }
    }

    public ListAdapter<ItemT> getAdapter() {
        return this.adapter;
    }

    public ListViewTable<ItemT> getMainTable() {
        return this.mainTable;
    }

    public VisScrollPane getScrollPane() {
        return this.scrollPane;
    }

    public void setItemClickListener(ItemClickListener<ItemT> listener) {
        this.clickListener = listener;
        this.adapter.setItemClickListener(listener);
    }

    public ItemClickListener<ItemT> getClickListener() {
        return this.clickListener;
    }

    public Actor getHeader() {
        return this.header;
    }

    public void setHeader(Actor header) {
        this.header = header;
        this.rebuildView(false);
    }

    public Actor getFooter() {
        return this.footer;
    }

    public void setFooter(Actor footer) {
        this.footer = footer;
        this.rebuildView(false);
    }

    public void setUpdatePolicy(UpdatePolicy updatePolicy) {
        this.updatePolicy = updatePolicy;
    }

    public UpdatePolicy getUpdatePolicy() {
        return this.updatePolicy;
    }

    public static class ListViewTable<ItemT>
    extends VisTable {
        private ListView<ItemT> listView;

        private ListViewTable(ListView<ItemT> listView) {
            this.listView = listView;
        }

        @Override
        public void draw(Batch batch, float parentAlpha) {
            if (((ListView)this.listView).updatePolicy == UpdatePolicy.ON_DRAW && ((ListView)this.listView).dataInvalidated) {
                ((ListView)this.listView).rebuildView(true);
            }
            super.draw(batch, parentAlpha);
        }

        public ListView<ItemT> getListView() {
            return this.listView;
        }
    }

    public static enum UpdatePolicy {
        ON_DRAW,
        IMMEDIATELY,
        MANUAL;

    }

    public class ListAdapterListener {
        public void invalidateDataSet() {
            if (ListView.this.updatePolicy == UpdatePolicy.IMMEDIATELY) {
                ListView.this.rebuildView(true);
            }
            if (ListView.this.updatePolicy == UpdatePolicy.ON_DRAW) {
                ListView.this.dataInvalidated = true;
            }
        }
    }

    public static interface ItemClickListener<ItemT> {
        public void clicked(ItemT var1);
    }
}

