/*
 * Decompiled with CFR 0.152.
 */
package com.kotcrab.vis.ui.widget.color;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.utils.Disposable;
import com.kotcrab.vis.ui.Sizes;
import com.kotcrab.vis.ui.VisUI;
import com.kotcrab.vis.ui.util.ColorUtils;
import com.kotcrab.vis.ui.widget.VisLabel;
import com.kotcrab.vis.ui.widget.VisTable;
import com.kotcrab.vis.ui.widget.VisTextField;
import com.kotcrab.vis.ui.widget.VisValidatableTextField;
import com.kotcrab.vis.ui.widget.color.ColorPickerListener;
import com.kotcrab.vis.ui.widget.color.ColorPickerWidgetStyle;
import com.kotcrab.vis.ui.widget.color.internal.AlphaImage;
import com.kotcrab.vis.ui.widget.color.internal.ColorPickerText;
import com.kotcrab.vis.ui.widget.color.internal.Palette;
import com.kotcrab.vis.ui.widget.color.internal.PickerCommons;
import com.kotcrab.vis.ui.widget.color.internal.VerticalChannelBar;

public class BasicColorPicker
extends VisTable
implements Disposable {
    public static final int FIELD_WIDTH = 50;
    public static final int PALETTE_SIZE = 160;
    public static final int BAR_WIDTH = 130;
    public static final int BAR_HEIGHT = 12;
    private static final float VERTICAL_BAR_WIDTH = 15.0f;
    private static final int HEX_FIELD_WIDTH = 95;
    private static final int HEX_COLOR_LENGTH = 6;
    private static final int HEX_COLOR_LENGTH_WITH_ALPHA = 8;
    protected ColorPickerWidgetStyle style;
    protected Sizes sizes;
    protected ColorPickerListener listener;
    Color oldColor;
    Color color;
    protected PickerCommons commons;
    protected Palette palette;
    protected VerticalChannelBar verticalBar;
    private VisTable mainTable;
    private VisTable colorPreviewsTable;
    private VisTable hexTable;
    private VisValidatableTextField hexField;
    private Image currentColorImg;
    private Image newColorImg;
    private boolean allowAlphaEdit = false;
    private boolean showHexFields = true;
    private boolean disposed = false;

    public BasicColorPicker() {
        this((ColorPickerListener)null);
    }

    public BasicColorPicker(ColorPickerListener listener) {
        this("default", listener);
    }

    public BasicColorPicker(String styleName, ColorPickerListener listener) {
        this(VisUI.getSkin().get(styleName, ColorPickerWidgetStyle.class), listener, false);
    }

    public BasicColorPicker(ColorPickerWidgetStyle style, ColorPickerListener listener) {
        this(style, listener, false);
    }

    protected BasicColorPicker(ColorPickerWidgetStyle style, ColorPickerListener listener, boolean loadExtendedShaders) {
        this.listener = listener;
        this.style = style;
        this.sizes = VisUI.getSizes();
        this.oldColor = new Color(Color.BLACK);
        this.color = new Color(Color.BLACK);
        this.commons = new PickerCommons(style, this.sizes, loadExtendedShaders);
        this.createColorWidgets();
        this.createUI();
        this.updateValuesFromCurrentColor();
        this.updateUI();
    }

    protected void createUI() {
        this.mainTable = new VisTable(true);
        this.colorPreviewsTable = this.createColorsPreviewTable();
        this.hexTable = this.createHexTable();
        this.rebuildMainTable();
        this.add(this.mainTable).top();
    }

    private void rebuildMainTable() {
        this.mainTable.clearChildren();
        this.mainTable.add(this.palette).size(160.0f * this.sizes.scaleFactor);
        this.mainTable.add(this.verticalBar).size(15.0f * this.sizes.scaleFactor, 160.0f * this.sizes.scaleFactor).top();
        this.mainTable.row();
        this.mainTable.add(this.colorPreviewsTable).colspan(2).expandX().fillX();
        if (this.showHexFields) {
            this.mainTable.row();
            this.mainTable.add(this.hexTable).colspan(2).expandX().left();
        }
    }

    private VisTable createColorsPreviewTable() {
        VisTable table = new VisTable(false);
        this.currentColorImg = new AlphaImage(this.commons, 5.0f * this.sizes.scaleFactor);
        table.add(this.currentColorImg).height(25.0f * this.sizes.scaleFactor).width(80.0f * this.sizes.scaleFactor).expandX().fillX();
        table.add(new Image(this.style.iconArrowRight)).pad(0.0f, 2.0f, 0.0f, 2.0f);
        this.newColorImg = new AlphaImage(this.commons, 5.0f * this.sizes.scaleFactor);
        table.add(this.newColorImg).height(25.0f * this.sizes.scaleFactor).width(80.0f * this.sizes.scaleFactor).expandX().fillX();
        this.currentColorImg.setColor(this.color);
        this.newColorImg.setColor(this.color);
        this.currentColorImg.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                BasicColorPicker.this.restoreLastColor();
            }
        });
        return table;
    }

    private VisTable createHexTable() {
        VisTable table = new VisTable(true);
        table.add(new VisLabel(ColorPickerText.HEX.get()));
        this.hexField = new VisValidatableTextField("00000000");
        table.add(this.hexField).width(95.0f * this.sizes.scaleFactor);
        table.row();
        this.hexField.setMaxLength(6);
        this.hexField.setProgrammaticChangeEvents(false);
        this.hexField.setTextFieldFilter(new VisTextField.TextFieldFilter(){

            @Override
            public boolean acceptChar(VisTextField textField, char c) {
                return Character.isDigit(c) || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F';
            }
        });
        this.hexField.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                if (BasicColorPicker.this.hexField.getText().length() == (BasicColorPicker.this.allowAlphaEdit ? 8 : 6)) {
                    BasicColorPicker.this.setColor(Color.valueOf(BasicColorPicker.this.hexField.getText()), false);
                }
            }
        });
        return table;
    }

    protected void createColorWidgets() {
        PickerChangeListener pickerListener = new PickerChangeListener();
        this.palette = new Palette(this.commons, 100, pickerListener);
        this.verticalBar = new VerticalChannelBar(this.commons, 360, pickerListener);
    }

    protected void updateUI() {
        this.palette.setPickerHue(this.verticalBar.getValue());
        this.newColorImg.setColor(this.color);
        this.hexField.setText(this.color.toString().toUpperCase());
        this.hexField.setCursorPosition(this.hexField.getMaxLength());
        if (this.listener != null) {
            this.listener.changed(this.color);
        }
    }

    protected void updateValuesFromCurrentColor() {
        int[] hsv = ColorUtils.RGBtoHSV(this.color);
        int ch = hsv[0];
        int cs = hsv[1];
        int cv = hsv[2];
        this.verticalBar.setValue(ch);
        this.palette.setValue(cs, cv);
    }

    protected void updateValuesFromHSVFields() {
        this.color = ColorUtils.HSVtoRGB((float)this.verticalBar.getValue(), (float)this.palette.getS(), (float)this.palette.getV(), this.color.a);
    }

    public void restoreLastColor() {
        Color colorBeforeReset = new Color(this.color);
        this.setColor(this.oldColor);
        if (this.listener != null) {
            this.listener.reset(colorBeforeReset, this.color);
        }
    }

    @Override
    public void setColor(Color newColor) {
        if (!this.allowAlphaEdit) {
            newColor.a = 1.0f;
        }
        this.setColor(newColor, true);
    }

    protected void setColor(Color newColor, boolean updateCurrentColor) {
        if (updateCurrentColor) {
            this.currentColorImg.setColor(new Color(newColor));
            this.oldColor = new Color(newColor);
        }
        this.color = new Color(newColor);
        this.updateValuesFromCurrentColor();
        this.updateUI();
    }

    public ColorPickerListener getListener() {
        return this.listener;
    }

    public void setListener(ColorPickerListener listener) {
        this.listener = listener;
    }

    public void setAllowAlphaEdit(boolean allowAlphaEdit) {
        this.allowAlphaEdit = allowAlphaEdit;
        this.hexField.setMaxLength(allowAlphaEdit ? 8 : 6);
        if (!allowAlphaEdit) {
            this.setColor(new Color(this.color));
        }
    }

    public boolean isAllowAlphaEdit() {
        return this.allowAlphaEdit;
    }

    public void setShowHexFields(boolean showHexFields) {
        this.showHexFields = showHexFields;
        this.hexTable.setVisible(showHexFields);
        this.rebuildMainTable();
    }

    public boolean isShowHexFields() {
        return this.showHexFields;
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        boolean wasPedantic = ShaderProgram.pedantic;
        ShaderProgram.pedantic = false;
        super.draw(batch, parentAlpha);
        ShaderProgram.pedantic = wasPedantic;
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    @Override
    public void dispose() {
        if (this.disposed) {
            throw new IllegalStateException("ColorPicker can't be disposed twice!");
        }
        this.commons.dispose();
        this.disposed = true;
    }

    class PickerChangeListener
    extends ChangeListener {
        PickerChangeListener() {
        }

        protected void updateLinkedWidget() {
        }

        @Override
        public void changed(ChangeListener.ChangeEvent event, Actor actor) {
            this.updateLinkedWidget();
            BasicColorPicker.this.updateValuesFromHSVFields();
            BasicColorPicker.this.updateUI();
        }
    }
}

