/*
 * Decompiled with CFR 0.152.
 */
package com.kotcrab.vis.ui.widget.file;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.Value;
import com.badlogic.gdx.scenes.scene2d.ui.VerticalGroup;
import com.badlogic.gdx.scenes.scene2d.ui.WidgetGroup;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.scenes.scene2d.utils.FocusListener;
import com.badlogic.gdx.scenes.scene2d.utils.Layout;
import com.badlogic.gdx.scenes.scene2d.utils.UIUtils;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.IdentityMap;
import com.badlogic.gdx.utils.Scaling;
import com.badlogic.gdx.utils.Timer;
import com.kotcrab.vis.ui.FocusManager;
import com.kotcrab.vis.ui.Focusable;
import com.kotcrab.vis.ui.Sizes;
import com.kotcrab.vis.ui.VisUI;
import com.kotcrab.vis.ui.layout.GridGroup;
import com.kotcrab.vis.ui.util.OsUtils;
import com.kotcrab.vis.ui.util.dialog.Dialogs;
import com.kotcrab.vis.ui.util.dialog.InputDialogAdapter;
import com.kotcrab.vis.ui.util.dialog.InputDialogListener;
import com.kotcrab.vis.ui.util.dialog.OptionDialogAdapter;
import com.kotcrab.vis.ui.util.value.ConstantIfVisibleValue;
import com.kotcrab.vis.ui.util.value.PrefHeightIfVisibleValue;
import com.kotcrab.vis.ui.util.value.PrefWidthIfVisibleValue;
import com.kotcrab.vis.ui.widget.BusyBar;
import com.kotcrab.vis.ui.widget.ButtonBar;
import com.kotcrab.vis.ui.widget.ListView;
import com.kotcrab.vis.ui.widget.MenuItem;
import com.kotcrab.vis.ui.widget.PopupMenu;
import com.kotcrab.vis.ui.widget.Tooltip;
import com.kotcrab.vis.ui.widget.VisCheckBox;
import com.kotcrab.vis.ui.widget.VisImage;
import com.kotcrab.vis.ui.widget.VisImageButton;
import com.kotcrab.vis.ui.widget.VisLabel;
import com.kotcrab.vis.ui.widget.VisScrollPane;
import com.kotcrab.vis.ui.widget.VisSelectBox;
import com.kotcrab.vis.ui.widget.VisSplitPane;
import com.kotcrab.vis.ui.widget.VisTable;
import com.kotcrab.vis.ui.widget.VisTextButton;
import com.kotcrab.vis.ui.widget.VisTextField;
import com.kotcrab.vis.ui.widget.VisWindow;
import com.kotcrab.vis.ui.widget.file.FileChooserAdapter;
import com.kotcrab.vis.ui.widget.file.FileChooserListener;
import com.kotcrab.vis.ui.widget.file.FileChooserStyle;
import com.kotcrab.vis.ui.widget.file.FileTypeFilter;
import com.kotcrab.vis.ui.widget.file.FileUtils;
import com.kotcrab.vis.ui.widget.file.internal.DirsSuggestionPopup;
import com.kotcrab.vis.ui.widget.file.internal.DriveCheckerService;
import com.kotcrab.vis.ui.widget.file.internal.FileChooserText;
import com.kotcrab.vis.ui.widget.file.internal.FileChooserWinService;
import com.kotcrab.vis.ui.widget.file.internal.FileHandleMetadata;
import com.kotcrab.vis.ui.widget.file.internal.FileHistoryManager;
import com.kotcrab.vis.ui.widget.file.internal.FileListAdapter;
import com.kotcrab.vis.ui.widget.file.internal.FilePopupMenu;
import com.kotcrab.vis.ui.widget.file.internal.FileSuggestionPopup;
import com.kotcrab.vis.ui.widget.file.internal.IconStack;
import com.kotcrab.vis.ui.widget.file.internal.PreferencesIO;
import com.kotcrab.vis.ui.widget.file.internal.ServiceThreadFactory;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public class FileChooser
extends VisWindow
implements FileHistoryManager.FileHistoryCallback {
    private static final long FILE_WATCHER_CHECK_DELAY_MILLIS = 2000L;
    private static final ShortcutsComparator SHORTCUTS_COMPARATOR = new ShortcutsComparator();
    private static final Vector2 tmpVector = new Vector2();
    private static boolean saveLastDirectory = false;
    public static boolean focusFileScrollPaneOnShow = true;
    private Mode mode;
    private ViewMode viewMode = ViewMode.DETAILS;
    private SelectionMode selectionMode = SelectionMode.FILES;
    private AtomicReference<FileSorting> sorting = new AtomicReference<FileSorting>(FileSorting.NAME);
    private AtomicBoolean sortingOrderAscending = new AtomicBoolean(true);
    private FileChooserListener listener = new FileChooserAdapter();
    private FileFilter fileFilter = new DefaultFileFilter(this);
    private FileDeleter fileDeleter = new DefaultFileDeleter();
    private FileTypeFilter fileTypeFilter = null;
    private FileTypeFilter.Rule activeFileTypeRule = null;
    private FileIconProvider iconProvider;
    private DriveCheckerService driveCheckerService = DriveCheckerService.getInstance();
    private Array<DriveCheckerService.DriveCheckerListener> driveCheckerListeners = new Array();
    private FileChooserWinService chooserWinService = FileChooserWinService.getInstance();
    private ExecutorService listDirExecutor = Executors.newSingleThreadExecutor(new ServiceThreadFactory("FileChooserListDirThread"));
    private Future<?> listDirFuture;
    private ShowBusyBarTask showBusyBarTask = new ShowBusyBarTask();
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    private boolean showSelectionCheckboxes = false;
    public static final int DEFAULT_KEY = -1;
    private boolean multiSelectionEnabled = false;
    private int groupMultiSelectKey = -1;
    private int multiSelectKey = -1;
    private PreferencesIO preferencesIO;
    private Array<FileHandle> favorites;
    private Array<FileHandle> recentDirectories;
    private FileHandle currentDirectory;
    private Array<FileHandle> currentFiles = new Array();
    private IdentityMap<FileHandle, FileHandleMetadata> currentFilesMetadata = new IdentityMap();
    private FileListAdapter fileListAdapter;
    private Array<FileItem> selectedItems = new Array();
    private ShortcutItem selectedShortcut;
    private boolean watchingFilesEnabled = true;
    private Thread fileWatcherThread;
    private boolean shortcutsListRebuildScheduled;
    private boolean filesListRebuildScheduled;
    private FileHistoryManager historyManager;
    private FileChooserStyle style;
    private Sizes sizes;
    private VisSplitPane mainSplitPane;
    private VisTable shortcutsTable;
    private VerticalGroup shortcutsMainPanel;
    private VerticalGroup shortcutsRootsPanel;
    private VerticalGroup shortcutsFavoritesPanel;
    private ListView<FileHandle> fileListView;
    private float maxDateLabelWidth;
    private BusyBar fileListBusyBar;
    private VisImageButton favoriteFolderButton;
    private VisImageButton viewModeButton;
    private Tooltip favoriteFolderButtonTooltip;
    private VisTextField currentPath;
    private VisTextField selectedFileTextField;
    private VisSelectBox<FileTypeFilter.Rule> fileTypeSelectBox;
    private VisTextButton confirmButton;
    private FilePopupMenu fileMenu;
    private FileSuggestionPopup fileNameSuggestionPopup;
    private DirsSuggestionPopup dirsSuggestionPopup;
    private VisLabel fileTypeLabel;
    private PopupMenu viewModePopupMenu;

    public FileChooser(Mode mode) {
        this((FileHandle)null, mode);
    }

    public FileChooser(FileHandle directory, Mode mode) {
        super("");
        this.mode = mode;
        this.getTitleLabel().setText(FileChooserText.TITLE_CHOOSE_FILES.get());
        this.style = VisUI.getSkin().get(FileChooserStyle.class);
        this.sizes = VisUI.getSizes();
        this.init(directory);
    }

    public FileChooser(String title, Mode mode) {
        this("default", title, mode);
    }

    public FileChooser(String styleName, String title, Mode mode) {
        super(title);
        this.mode = mode;
        this.style = VisUI.getSkin().get(styleName, FileChooserStyle.class);
        this.sizes = VisUI.getSizes();
        this.init(null);
    }

    public static void setDefaultPrefsName(String prefsName) {
        PreferencesIO.setDefaultPrefsName(prefsName);
    }

    @Deprecated
    public static void setFavoritesPrefsName(String name) {
        PreferencesIO.setDefaultPrefsName(name);
    }

    private void init(FileHandle directory) {
        this.setModal(true);
        this.setResizable(true);
        this.setMovable(true);
        this.addCloseButton();
        this.closeOnEscape();
        this.iconProvider = new DefaultFileIconProvider(this);
        this.preferencesIO = new PreferencesIO();
        this.reloadPreferences(false);
        this.createToolbar();
        this.viewModePopupMenu = new PopupMenu(this.style.popupMenuStyle);
        this.createViewModePopupMenu();
        this.createCenterContentPanel();
        this.createFileTextBox();
        this.createBottomButtons();
        this.createShortcutsMainPanel();
        this.shortcutsRootsPanel = new VerticalGroup();
        this.shortcutsFavoritesPanel = new VerticalGroup();
        this.rebuildShortcutsFavoritesPanel();
        this.fileMenu = new FilePopupMenu(this, new FilePopupMenu.FilePopupMenuCallback(){

            @Override
            public void showNewDirDialog() {
                FileChooser.this.showNewDirectoryDialog();
            }

            @Override
            public void showFileDelDialog(FileHandle file) {
                FileChooser.this.showFileDeleteDialog(file);
            }
        });
        this.fileNameSuggestionPopup = new FileSuggestionPopup(this);
        this.rebuildShortcutsList();
        if (directory == null) {
            FileHandle startingDir = null;
            if (saveLastDirectory) {
                startingDir = this.preferencesIO.loadLastDirectory();
            }
            if (startingDir == null || !startingDir.exists()) {
                startingDir = this.getDefaultStartingDirectory();
            }
            this.setDirectory(startingDir, HistoryPolicy.IGNORE);
        } else {
            this.setDirectory(directory, HistoryPolicy.IGNORE);
        }
        this.setSize(500.0f, 600.0f);
        this.centerWindow();
        this.createListeners();
        this.setFileTypeFilter(null);
        this.setFavoriteFolderButtonVisible(false);
    }

    private void createToolbar() {
        VisTable toolbarTable = new VisTable(true);
        toolbarTable.defaults().minWidth(30.0f).right();
        this.add(toolbarTable).fillX().expandX().pad(3.0f).padRight(2.0f);
        this.historyManager = new FileHistoryManager(this.style, this);
        this.currentPath = new VisTextField();
        final VisImageButton showRecentDirButton = new VisImageButton(this.style.expandDropdown);
        showRecentDirButton.setFocusBorderEnabled(false);
        this.dirsSuggestionPopup = new DirsSuggestionPopup(this, this.currentPath);
        this.dirsSuggestionPopup.setListener(new PopupMenu.PopupMenuListener(){

            @Override
            public void activeItemChanged(MenuItem newItem, boolean changedByKeyboard) {
                if (!changedByKeyboard || newItem == null) {
                    return;
                }
                FileChooser.this.setCurrentPathFieldText(newItem.getText().toString());
            }
        });
        this.currentPath.addListener(new InputListener(){

            @Override
            public boolean keyTyped(InputEvent event, char character) {
                if (event.getKeyCode() == 66) {
                    FileChooser.this.dirsSuggestionPopup.remove();
                    return false;
                }
                float targetWidth = FileChooser.this.currentPath.getWidth() + showRecentDirButton.getWidth();
                FileChooser.this.dirsSuggestionPopup.pathFieldKeyTyped(FileChooser.this.getChooserStage(), targetWidth);
                return false;
            }

            @Override
            public boolean keyDown(InputEvent event, int keycode) {
                if (keycode == 66) {
                    FileHandle file = Gdx.files.absolute(FileChooser.this.currentPath.getText());
                    if (file.exists()) {
                        if (!file.isDirectory()) {
                            file = file.parent();
                        }
                        FileChooser.this.setDirectory(file, HistoryPolicy.ADD);
                        FileChooser.this.addRecentDirectory(file);
                    } else {
                        FileChooser.this.showDialog(FileChooserText.POPUP_DIRECTORY_DOES_NOT_EXIST.get());
                        FileChooser.this.setCurrentPathFieldText(FileChooser.this.currentDirectory.path());
                    }
                    event.stop();
                }
                return false;
            }
        });
        this.currentPath.addListener(new FocusListener(){

            @Override
            public void keyboardFocusChanged(FocusListener.FocusEvent event, Actor actor, boolean focused) {
                if (!focused) {
                    FileChooser.this.setCurrentPathFieldText(FileChooser.this.currentDirectory.path());
                }
            }
        });
        showRecentDirButton.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                float targetWidth = FileChooser.this.currentPath.getWidth() + showRecentDirButton.getWidth();
                FileChooser.this.dirsSuggestionPopup.showRecentDirectories(FileChooser.this.getChooserStage(), FileChooser.this.recentDirectories, targetWidth);
            }
        });
        VisImageButton folderParentButton = new VisImageButton(this.style.iconFolderParent, FileChooserText.PARENT_DIRECTORY.get());
        this.favoriteFolderButton = new VisImageButton(this.style.iconStar);
        this.favoriteFolderButtonTooltip = new Tooltip.Builder(FileChooserText.CONTEXT_MENU_ADD_TO_FAVORITES.get()).target(this.favoriteFolderButton).build();
        this.viewModeButton = new VisImageButton(this.style.iconListSettings);
        new Tooltip.Builder(FileChooserText.CHANGE_VIEW_MODE.get()).target(this.viewModeButton).build();
        VisImageButton folderNewButton = new VisImageButton(this.style.iconFolderNew, FileChooserText.NEW_DIRECTORY.get());
        toolbarTable.add(this.historyManager.getButtonsTable());
        toolbarTable.add(this.currentPath).spaceRight(0.0f).expand().fill();
        toolbarTable.add(showRecentDirButton).width(15.0f * this.sizes.scaleFactor).growY();
        toolbarTable.add(folderParentButton);
        toolbarTable.add(this.favoriteFolderButton).width(PrefWidthIfVisibleValue.INSTANCE).spaceRight(new ConstantIfVisibleValue(this.sizes.spacingRight));
        toolbarTable.add(this.viewModeButton).width(PrefWidthIfVisibleValue.INSTANCE).spaceRight(new ConstantIfVisibleValue(this.sizes.spacingRight));
        toolbarTable.add(folderNewButton);
        folderParentButton.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                FileHandle parent = FileChooser.this.currentDirectory.parent();
                if (OsUtils.isWindows() && FileChooser.this.currentDirectory.path().endsWith(":/")) {
                    return;
                }
                FileChooser.this.setDirectory(parent, HistoryPolicy.ADD);
            }
        });
        this.favoriteFolderButton.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                if (FileChooser.this.favorites.contains(FileChooser.this.currentDirectory, false)) {
                    FileChooser.this.removeFavorite(FileChooser.this.currentDirectory);
                } else {
                    FileChooser.this.addFavorite(FileChooser.this.currentDirectory);
                }
            }
        });
        folderNewButton.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                FileChooser.this.showNewDirectoryDialog();
            }
        });
        this.addListener(this.historyManager.getDefaultClickListener());
    }

    private void createViewModePopupMenu() {
        this.rebuildViewModePopupMenu();
        this.viewModeButton.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                Gdx.app.postRunnable(new Runnable(){

                    @Override
                    public void run() {
                        FileChooser.this.viewModePopupMenu.showMenu(FileChooser.this.getChooserStage(), FileChooser.this.viewModeButton);
                    }
                });
                return true;
            }
        });
    }

    private void rebuildViewModePopupMenu() {
        this.viewModePopupMenu.clear();
        for (final ViewMode mode : ViewMode.values()) {
            if (mode.thumbnailMode && !this.iconProvider.isThumbnailModesSupported()) continue;
            this.viewModePopupMenu.addItem(new MenuItem(mode.getBundleText(), new ChangeListener(){

                @Override
                public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                    FileChooser.this.setViewMode(mode);
                }
            }));
        }
    }

    private void updateFavoriteFolderButton() {
        VisLabel label = (VisLabel)this.favoriteFolderButtonTooltip.getContent();
        if (this.favorites.contains(this.currentDirectory, false)) {
            this.favoriteFolderButton.getStyle().imageUp = this.style.iconStar;
            label.setText(FileChooserText.CONTEXT_MENU_REMOVE_FROM_FAVORITES.get());
        } else {
            this.favoriteFolderButton.getStyle().imageUp = this.style.iconStarOutline;
            label.setText(FileChooserText.CONTEXT_MENU_ADD_TO_FAVORITES.get());
        }
        this.favoriteFolderButtonTooltip.pack();
    }

    private void createCenterContentPanel() {
        this.fileListAdapter = new FileListAdapter(this, this.currentFiles);
        this.fileListView = new ListView<FileHandle>(this.fileListAdapter);
        this.setupDefaultScrollPane(this.fileListView.getScrollPane());
        VisTable fileScrollPaneTable = new VisTable();
        this.fileListBusyBar = new BusyBar();
        this.fileListBusyBar.setVisible(false);
        fileScrollPaneTable.add(this.fileListBusyBar).space(0.0f).height(PrefHeightIfVisibleValue.INSTANCE).growX().row();
        fileScrollPaneTable.add(this.fileListView.getMainTable()).pad(2.0f).top().expand().fillX();
        fileScrollPaneTable.setTouchable(Touchable.enabled);
        this.shortcutsTable = new VisTable();
        final VisScrollPane shortcutsScrollPane = this.setupDefaultScrollPane(new VisScrollPane((Actor)this.shortcutsTable));
        VisTable shortcutsScrollPaneTable = new VisTable();
        shortcutsScrollPaneTable.add(shortcutsScrollPane).pad(2.0f).top().expand().fillX();
        this.mainSplitPane = new VisSplitPane((Actor)shortcutsScrollPaneTable, (Actor)fileScrollPaneTable, false){

            @Override
            public void invalidate() {
                super.invalidate();
                FileChooser.this.invalidateChildHierarchy(shortcutsScrollPane);
            }
        };
        this.mainSplitPane.setSplitAmount(0.3f);
        this.mainSplitPane.setMinSplitAmount(0.05f);
        this.mainSplitPane.setMaxSplitAmount(0.8f);
        this.row();
        this.add(this.mainSplitPane).expand().fill();
        this.row();
        fileScrollPaneTable.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                return true;
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                if (button == 1 && !FileChooser.this.fileMenu.isAddedToStage()) {
                    FileChooser.this.fileMenu.build();
                    FileChooser.this.fileMenu.showMenu(FileChooser.this.getChooserStage(), event.getStageX(), event.getStageY());
                }
            }
        });
    }

    private void invalidateChildHierarchy(WidgetGroup layout) {
        if (layout != null) {
            layout.invalidate();
            for (Actor actor : layout.getChildren()) {
                if (actor instanceof WidgetGroup) {
                    this.invalidateChildHierarchy((WidgetGroup)actor);
                    continue;
                }
                if (!(actor instanceof Layout)) continue;
                ((Layout)((Object)actor)).invalidate();
            }
        }
    }

    private void setCurrentPathFieldText(String text) {
        this.currentPath.setText(text);
        this.currentPath.setCursorAtTextEnd();
    }

    private void createFileTextBox() {
        VisTable table = new VisTable(true);
        VisLabel nameLabel = new VisLabel(FileChooserText.FILE_NAME.get());
        this.selectedFileTextField = new VisTextField();
        this.fileTypeLabel = new VisLabel(FileChooserText.FILE_TYPE.get());
        this.fileTypeSelectBox = new VisSelectBox();
        this.fileTypeSelectBox.getSelection().setProgrammaticChangeEvents(false);
        this.fileTypeSelectBox.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                FileChooser.this.activeFileTypeRule = (FileTypeFilter.Rule)FileChooser.this.fileTypeSelectBox.getSelected();
                FileChooser.this.rebuildFileList();
            }
        });
        table.defaults().left();
        table.add(nameLabel).spaceBottom(new ConstantIfVisibleValue(this.fileTypeSelectBox, 5.0f));
        table.add(this.selectedFileTextField).expandX().fillX().spaceBottom(new ConstantIfVisibleValue(this.fileTypeSelectBox, 5.0f)).row();
        table.add(this.fileTypeLabel).height(PrefHeightIfVisibleValue.INSTANCE).spaceBottom(new ConstantIfVisibleValue(this.sizes.spacingBottom));
        table.add(this.fileTypeSelectBox).height(PrefHeightIfVisibleValue.INSTANCE).spaceBottom(new ConstantIfVisibleValue(this.sizes.spacingBottom)).expand().fill();
        this.selectedFileTextField.addListener(new InputListener(){

            @Override
            public boolean keyDown(InputEvent event, int keycode) {
                if (keycode == 66) {
                    FileChooser.this.selectionFinished();
                    return true;
                }
                return false;
            }

            @Override
            public boolean keyTyped(InputEvent event, char character) {
                FileChooser.this.deselectAll(false);
                FileChooser.this.fileNameSuggestionPopup.pathFieldKeyTyped(FileChooser.this.getChooserStage(), FileChooser.this.currentFiles, FileChooser.this.selectedFileTextField);
                FileHandle enteredFile = FileChooser.this.currentDirectory.child(FileChooser.this.selectedFileTextField.getText());
                if (FileChooser.this.currentFiles.contains(enteredFile, false)) {
                    FileChooser.this.highlightFiles(enteredFile);
                }
                return false;
            }
        });
        this.add(table).expandX().fillX().pad(3.0f).padRight(2.0f).padBottom(2.0f);
        this.row();
    }

    private void updateFileTypeSelectBox() {
        if (this.fileTypeFilter == null || this.selectionMode == SelectionMode.DIRECTORIES) {
            this.fileTypeLabel.setVisible(false);
            this.fileTypeSelectBox.setVisible(false);
            this.fileTypeSelectBox.invalidateHierarchy();
            return;
        }
        this.fileTypeLabel.setVisible(true);
        this.fileTypeSelectBox.setVisible(true);
        this.fileTypeSelectBox.invalidateHierarchy();
        Array<FileTypeFilter.Rule> rules = new Array<FileTypeFilter.Rule>(this.fileTypeFilter.getRules());
        if (this.fileTypeFilter.isAllTypesAllowed()) {
            FileTypeFilter.Rule allTypesRule = new FileTypeFilter.Rule(FileChooserText.ALL_FILES.get());
            rules.add(allTypesRule);
        }
        this.fileTypeSelectBox.setItems(rules);
        this.fileTypeSelectBox.setSelected(this.activeFileTypeRule);
    }

    private void createBottomButtons() {
        VisTextButton cancelButton = new VisTextButton(FileChooserText.CANCEL.get());
        this.confirmButton = new VisTextButton(this.mode == Mode.OPEN ? FileChooserText.OPEN.get() : FileChooserText.SAVE.get());
        VisTable buttonTable = new VisTable(true);
        buttonTable.defaults().minWidth(70.0f).right();
        this.add(buttonTable).padTop(3.0f).padBottom(3.0f).padRight(2.0f).fillX().expandX();
        ButtonBar buttonBar = new ButtonBar();
        buttonBar.setIgnoreSpacing(true);
        buttonBar.setButton(ButtonBar.ButtonType.CANCEL, cancelButton);
        buttonBar.setButton(ButtonBar.ButtonType.OK, this.confirmButton);
        buttonTable.add(buttonBar.createTable()).expand().right();
        cancelButton.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                FileChooser.this.fadeOut();
                FileChooser.this.listener.canceled();
            }
        });
        this.confirmButton.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                FileChooser.this.selectionFinished();
            }
        });
    }

    private void createShortcutsMainPanel() {
        this.shortcutsMainPanel = new VerticalGroup();
        String userHome = System.getProperty("user.home");
        String userName = System.getProperty("user.name");
        File userDesktop = new File(userHome + "/Desktop");
        if (userDesktop.exists()) {
            this.shortcutsMainPanel.addActor(new ShortcutItem(userDesktop, FileChooserText.DESKTOP.get(), this.style.iconFolder));
        }
        this.shortcutsMainPanel.addActor(new ShortcutItem(new File(userHome), userName, this.style.iconFolder));
    }

    private void createListeners() {
        this.addListener(new InputListener(){

            @Override
            public boolean keyDown(InputEvent event, int keycode) {
                if (keycode == 29 && UIUtils.ctrl() && !(FileChooser.this.getChooserStage().getKeyboardFocus() instanceof VisTextField)) {
                    FileChooser.this.selectAll();
                    return true;
                }
                return false;
            }

            @Override
            public boolean keyTyped(InputEvent event, char character) {
                if (FileChooser.this.getChooserStage().getKeyboardFocus() instanceof VisTextField) {
                    return false;
                }
                if (!Character.isLetterOrDigit(character)) {
                    return false;
                }
                String name = String.valueOf(character);
                for (FileHandle file : FileChooser.this.currentFiles) {
                    if (!file.name().toLowerCase().startsWith(name)) continue;
                    FileChooser.this.deselectAll();
                    FileChooser.this.highlightFiles(file);
                    return true;
                }
                return false;
            }
        });
    }

    private void selectionFinished() {
        Array<FileHandle> files;
        if (this.selectedItems.size == 1) {
            FileHandle selected;
            if (this.selectionMode == SelectionMode.FILES && (selected = this.selectedItems.get(0).getFile()).isDirectory()) {
                this.setDirectory(selected, HistoryPolicy.ADD);
                return;
            }
            if (this.selectionMode == SelectionMode.DIRECTORIES && !(selected = this.selectedItems.get(0).getFile()).isDirectory()) {
                this.showDialog(FileChooserText.POPUP_ONLY_DIRECTORIES.get());
                return;
            }
        }
        if (this.selectedItems.size > 0 || this.mode == Mode.SAVE) {
            files = this.getFileListFromSelected();
            this.notifyListenerAndCloseDialog(files);
        } else if (this.selectionMode == SelectionMode.FILES) {
            this.showDialog(FileChooserText.POPUP_CHOOSE_FILE.get());
        } else {
            files = new Array();
            if (this.selectedFileTextField.getText().length() != 0) {
                files.add(this.currentDirectory.child(this.selectedFileTextField.getText()));
            } else {
                files.add(this.currentDirectory);
            }
            this.notifyListenerAndCloseDialog(files);
        }
    }

    @Override
    protected void close() {
        this.listener.canceled();
        super.close();
    }

    private void notifyListenerAndCloseDialog(Array<FileHandle> files) {
        if (files == null) {
            return;
        }
        if (this.mode == Mode.OPEN) {
            for (FileHandle file : files) {
                if (file.exists()) continue;
                this.showDialog(FileChooserText.POPUP_SELECTED_FILE_DOES_NOT_EXIST.get());
                return;
            }
        }
        if (files.size != 0) {
            this.listener.selected(files);
            if (saveLastDirectory) {
                this.preferencesIO.saveLastDirectory(this.currentDirectory);
            }
        }
        this.fadeOut();
    }

    @Override
    public void fadeOut(float time) {
        super.fadeOut(time);
        this.fileMenu.remove();
        this.dirsSuggestionPopup.remove();
        this.fileNameSuggestionPopup.remove();
        this.viewModePopupMenu.remove();
    }

    protected VisScrollPane setupDefaultScrollPane(VisScrollPane scrollPane) {
        scrollPane.setOverscroll(false, false);
        scrollPane.setFlickScroll(false);
        scrollPane.setFadeScrollBars(false);
        scrollPane.setScrollingDisabled(true, false);
        return scrollPane;
    }

    private Array<FileHandle> getFileListFromSelected() {
        Array<FileHandle> list = new Array<FileHandle>();
        if (this.mode == Mode.OPEN) {
            for (FileItem item : this.selectedItems) {
                list.add(item.getFile());
            }
            return list;
        }
        if (this.selectedItems.size > 0) {
            for (FileItem item : this.selectedItems) {
                list.add(item.getFile());
            }
            this.showOverwriteQuestion(list);
            return null;
        }
        String fileName = this.selectedFileTextField.getText();
        FileHandle file = this.currentDirectory.child(fileName);
        if (!FileUtils.isValidFileName(fileName)) {
            this.showDialog(FileChooserText.POPUP_FILENAME_INVALID.get());
            return null;
        }
        if (file.exists()) {
            list.add(file);
            this.showOverwriteQuestion(list);
            return null;
        }
        if (this.activeFileTypeRule != null) {
            Array<String> ruleExts = this.activeFileTypeRule.getExtensions();
            if (ruleExts.size > 0 && !ruleExts.contains(file.extension(), false)) {
                file = file.sibling(file.nameWithoutExtension() + "." + ruleExts.first());
            }
        }
        list.add(file);
        if (file.exists()) {
            this.showOverwriteQuestion(list);
            return null;
        }
        return list;
    }

    private void showDialog(String text) {
        Dialogs.showOKDialog(this.getChooserStage(), FileChooserText.POPUP_TITLE.get(), text);
    }

    private void showOverwriteQuestion(final Array<FileHandle> filesList) {
        String text = filesList.size == 1 ? FileChooserText.POPUP_FILE_EXIST_OVERWRITE.get() : FileChooserText.POPUP_MULTIPLE_FILE_EXIST_OVERWRITE.get();
        Dialogs.showOptionDialog(this.getChooserStage(), FileChooserText.POPUP_TITLE.get(), text, Dialogs.OptionDialogType.YES_NO, new OptionDialogAdapter(){

            @Override
            public void yes() {
                FileChooser.this.notifyListenerAndCloseDialog(filesList);
            }
        });
    }

    private void rebuildShortcutsList(boolean rebuildRootCache) {
        this.shortcutsTable.clear();
        this.shortcutsTable.add(this.shortcutsMainPanel).left().row();
        this.shortcutsTable.addSeparator();
        if (rebuildRootCache) {
            this.rebuildFileRootsCache();
        }
        this.shortcutsTable.add(this.shortcutsRootsPanel).left().row();
        if (this.shortcutsFavoritesPanel.getChildren().size > 0) {
            this.shortcutsTable.addSeparator();
        }
        this.shortcutsTable.add(this.shortcutsFavoritesPanel).left().row();
    }

    private void rebuildShortcutsList() {
        this.shortcutsListRebuildScheduled = false;
        this.rebuildShortcutsList(true);
    }

    private void rebuildFileRootsCache() {
        this.shortcutsRootsPanel.clear();
        File[] roots = File.listRoots();
        this.driveCheckerListeners.clear();
        for (File root : roots) {
            DriveCheckerService.DriveCheckerListener listener = new DriveCheckerService.DriveCheckerListener(){

                @Override
                public void rootMode(File root, DriveCheckerService.RootMode mode) {
                    if (!FileChooser.this.driveCheckerListeners.removeValue(this, true)) {
                        return;
                    }
                    String initialName = root.toString();
                    if (initialName.equals("/")) {
                        initialName = FileChooserText.COMPUTER.get();
                    }
                    ShortcutItem item = new ShortcutItem(root, initialName, ((FileChooser)FileChooser.this).style.iconDrive);
                    if (OsUtils.isWindows()) {
                        FileChooser.this.chooserWinService.addListener(root, item);
                    }
                    FileChooser.this.shortcutsRootsPanel.addActor(item);
                    FileChooser.this.shortcutsRootsPanel.getChildren().sort(SHORTCUTS_COMPARATOR);
                }
            };
            this.driveCheckerListeners.add(listener);
            this.driveCheckerService.addListener(root, this.mode == Mode.OPEN ? DriveCheckerService.RootMode.READABLE : DriveCheckerService.RootMode.WRITABLE, listener);
        }
    }

    private void rebuildShortcutsFavoritesPanel() {
        this.shortcutsFavoritesPanel.clear();
        if (this.favorites.size > 0) {
            for (FileHandle f : this.favorites) {
                this.shortcutsFavoritesPanel.addActor(new ShortcutItem(f.file(), f.name(), this.style.iconFolder));
            }
        }
    }

    private void rebuildFileList() {
        this.filesListRebuildScheduled = false;
        final FileHandle[] selectedFiles = new FileHandle[this.selectedItems.size];
        for (int i = 0; i < selectedFiles.length; ++i) {
            selectedFiles[i] = this.selectedItems.get(i).getFile();
        }
        this.deselectAll();
        this.setCurrentPathFieldText(this.currentDirectory.path());
        if (!this.showBusyBarTask.isScheduled()) {
            Timer.schedule(this.showBusyBarTask, 0.2f);
        }
        if (this.listDirFuture != null) {
            this.listDirFuture.cancel(true);
        }
        this.listDirFuture = this.listDirExecutor.submit(new Runnable(){

            @Override
            public void run() {
                if (!FileChooser.this.currentDirectory.exists() || !FileChooser.this.currentDirectory.isDirectory()) {
                    Gdx.app.postRunnable(new Runnable(){

                        @Override
                        public void run() {
                            FileChooser.this.setDirectory(FileChooser.this.getDefaultStartingDirectory(), HistoryPolicy.ADD);
                        }
                    });
                    return;
                }
                final Array<FileHandle> files = FileUtils.sortFiles(FileChooser.this.listFilteredCurrentDirectory(), ((FileSorting)((Object)FileChooser.this.sorting.get())).comparator, !FileChooser.this.sortingOrderAscending.get());
                if (Thread.currentThread().isInterrupted()) {
                    return;
                }
                final IdentityMap<FileHandle, FileHandleMetadata> metadata = new IdentityMap<FileHandle, FileHandleMetadata>(files.size);
                for (FileHandle file : files) {
                    metadata.put(file, FileHandleMetadata.of(file));
                }
                if (Thread.currentThread().isInterrupted()) {
                    return;
                }
                Gdx.app.postRunnable(new Runnable(){

                    @Override
                    public void run() {
                        FileChooser.this.buildFileList(files, metadata, selectedFiles);
                    }
                });
            }
        });
    }

    private void buildFileList(Array<FileHandle> files, IdentityMap<FileHandle, FileHandleMetadata> metadata, FileHandle[] selectedFiles) {
        this.currentFiles.clear();
        this.currentFilesMetadata.clear();
        this.showBusyBarTask.cancel();
        this.fileListBusyBar.setVisible(false);
        if (files.size == 0) {
            this.fileListAdapter.itemsChanged();
            return;
        }
        this.maxDateLabelWidth = 0.0f;
        this.currentFiles.addAll(files);
        this.currentFilesMetadata = metadata;
        this.fileListAdapter.itemsChanged();
        this.fileListView.getScrollPane().setScrollX(0.0f);
        this.fileListView.getScrollPane().setScrollY(0.0f);
        this.highlightFiles(selectedFiles);
    }

    public void setSelectedFiles(FileHandle ... files) {
        this.deselectAll(false);
        for (FileHandle file : files) {
            FileItem item = this.fileListAdapter.getViews().get(file);
            if (item == null) continue;
            item.select(false);
        }
        this.removeInvalidSelections();
        this.updateSelectedFileFieldText();
    }

    public void refresh() {
        this.rebuildShortcutsList();
        this.rebuildFileList();
    }

    public void addFavorite(FileHandle favourite) {
        this.favorites.add(favourite);
        this.preferencesIO.saveFavorites(this.favorites);
        this.rebuildShortcutsFavoritesPanel();
        this.rebuildShortcutsList(false);
        this.updateFavoriteFolderButton();
    }

    public boolean removeFavorite(FileHandle favorite) {
        boolean removed = this.favorites.removeValue(favorite, false);
        this.preferencesIO.saveFavorites(this.favorites);
        this.rebuildShortcutsFavoritesPanel();
        this.rebuildShortcutsList(false);
        this.updateFavoriteFolderButton();
        return removed;
    }

    private void addRecentDirectory(FileHandle file) {
        if (this.recentDirectories.contains(file, false)) {
            return;
        }
        this.recentDirectories.insert(0, file);
        if (this.recentDirectories.size > 10) {
            this.recentDirectories.pop();
        }
        this.preferencesIO.saveRecentDirectories(this.recentDirectories);
    }

    public void clearRecentDirectories() {
        this.recentDirectories.clear();
        this.preferencesIO.saveRecentDirectories(this.recentDirectories);
    }

    @Override
    public void setVisible(boolean visible) {
        if (!this.isVisible() && visible) {
            this.deselectAll();
        }
        super.setVisible(visible);
    }

    private void deselectAll() {
        this.deselectAll(true);
    }

    private void deselectAll(boolean updateTextField) {
        for (FileItem item : this.selectedItems) {
            item.deselect(false);
        }
        this.selectedItems.clear();
        if (updateTextField) {
            this.updateSelectedFileFieldText();
        }
    }

    private void selectAll() {
        for (FileItem item : this.fileListAdapter.getOrderedViews()) {
            item.select(false);
        }
        this.removeInvalidSelections();
        this.updateSelectedFileFieldText();
    }

    public void highlightFiles(FileHandle ... files) {
        FileItem item;
        for (FileHandle file : files) {
            FileItem item2 = this.fileListAdapter.getViews().get(file);
            if (item2 == null) continue;
            item2.select(false);
        }
        if (files.length > 0 && (item = this.fileListAdapter.getViews().get(files[0])) != null) {
            if (item.getParent() instanceof Table) {
                ((Table)item.getParent()).layout();
            }
            item.localToParentCoordinates(tmpVector.setZero());
            this.fileListView.getScrollPane().scrollTo(FileChooser.tmpVector.x, FileChooser.tmpVector.y, item.getWidth(), item.getHeight(), false, true);
        }
        this.updateSelectedFileFieldText();
    }

    private void updateSelectedFileFieldText() {
        if (this.getChooserStage() != null && this.getChooserStage().getKeyboardFocus() == this.selectedFileTextField) {
            return;
        }
        if (this.selectedItems.size == 0) {
            this.selectedFileTextField.setText("");
        } else if (this.selectedItems.size == 1) {
            this.selectedFileTextField.setText(this.selectedItems.get(0).getFile().name());
        } else {
            StringBuilder builder = new StringBuilder();
            for (FileItem item : this.selectedItems) {
                builder.append('\"');
                builder.append(item.file.name());
                builder.append("\" ");
            }
            this.selectedFileTextField.setText(builder.toString());
        }
        this.selectedFileTextField.setCursorAtTextEnd();
    }

    private void removeInvalidSelections() {
        FileItem item;
        Iterator<FileItem> it;
        if (this.selectionMode == SelectionMode.FILES) {
            it = this.selectedItems.iterator();
            while (it.hasNext()) {
                item = it.next();
                if (!item.file.isDirectory()) continue;
                item.deselect(false);
                it.remove();
            }
        }
        if (this.selectionMode == SelectionMode.DIRECTORIES) {
            it = this.selectedItems.iterator();
            while (it.hasNext()) {
                item = it.next();
                if (item.file.isDirectory()) continue;
                item.deselect(false);
                it.remove();
            }
        }
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
        this.confirmButton.setText(mode == Mode.OPEN ? FileChooserText.OPEN.get() : FileChooserText.SAVE.get());
        this.refresh();
    }

    public ViewMode getViewMode() {
        return this.viewMode;
    }

    public void setViewMode(ViewMode viewMode) {
        if (this.viewMode == viewMode) {
            return;
        }
        this.viewMode = viewMode;
        this.iconProvider.viewModeChanged(viewMode);
        this.rebuildFileList();
    }

    public void setDirectory(String directory) {
        this.setDirectory(Gdx.files.absolute(directory), HistoryPolicy.CLEAR);
    }

    public void setDirectory(File directory) {
        this.setDirectory(Gdx.files.absolute(directory.getAbsolutePath()), HistoryPolicy.CLEAR);
    }

    public void setDirectory(FileHandle directory) {
        this.setDirectory(directory, HistoryPolicy.CLEAR);
    }

    @Override
    public void setDirectory(FileHandle directory, HistoryPolicy historyPolicy) {
        if (directory.equals(this.currentDirectory)) {
            return;
        }
        if (historyPolicy == HistoryPolicy.ADD) {
            this.historyManager.historyAdd();
        }
        this.currentDirectory = directory;
        this.iconProvider.directoryChanged(directory);
        this.rebuildFileList();
        if (historyPolicy == HistoryPolicy.CLEAR) {
            this.historyManager.historyClear();
        }
        this.updateFavoriteFolderButton();
    }

    @Override
    public FileHandle getCurrentDirectory() {
        return this.currentDirectory;
    }

    private FileHandle getDefaultStartingDirectory() {
        return Gdx.files.absolute(System.getProperty("user.home"));
    }

    private FileHandle[] listFilteredCurrentDirectory() {
        FileHandle[] files = this.currentDirectory.list(this.fileFilter);
        if (this.fileTypeFilter == null || this.activeFileTypeRule == null) {
            return files;
        }
        FileHandle[] filtered = new FileHandle[files.length];
        int count = 0;
        for (FileHandle file : files) {
            if (!file.isDirectory() && !this.activeFileTypeRule.accept(file)) continue;
            filtered[count++] = file;
        }
        if (count == 0) {
            return new FileHandle[0];
        }
        FileHandle[] newFiltered = new FileHandle[count];
        System.arraycopy(filtered, 0, newFiltered, 0, count);
        return newFiltered;
    }

    public FileFilter getFileFilter() {
        return this.fileFilter;
    }

    public void setFileFilter(FileFilter fileFilter) {
        this.fileFilter = fileFilter;
        this.rebuildFileList();
    }

    public void setFileTypeFilter(FileTypeFilter fileTypeFilter) {
        if (fileTypeFilter == null) {
            this.fileTypeFilter = null;
            this.activeFileTypeRule = null;
        } else {
            if (fileTypeFilter.getRules().size == 0) {
                throw new IllegalArgumentException("FileTypeFilter doesn't have any rules added");
            }
            this.fileTypeFilter = new FileTypeFilter(fileTypeFilter);
            this.activeFileTypeRule = this.fileTypeFilter.getRules().first();
        }
        this.updateFileTypeSelectBox();
        this.rebuildFileList();
    }

    public FileTypeFilter.Rule getActiveFileTypeFilterRule() {
        return this.activeFileTypeRule;
    }

    public SelectionMode getSelectionMode() {
        return this.selectionMode;
    }

    public void setSelectionMode(SelectionMode selectionMode) {
        if (selectionMode == null) {
            selectionMode = SelectionMode.FILES;
        }
        this.selectionMode = selectionMode;
        switch (selectionMode) {
            case FILES: {
                this.getTitleLabel().setText(FileChooserText.TITLE_CHOOSE_FILES.get());
                break;
            }
            case DIRECTORIES: {
                this.getTitleLabel().setText(FileChooserText.TITLE_CHOOSE_DIRECTORIES.get());
                break;
            }
            case FILES_AND_DIRECTORIES: {
                this.getTitleLabel().setText(FileChooserText.TITLE_CHOOSE_FILES_AND_DIRECTORIES.get());
            }
        }
        this.updateFileTypeSelectBox();
        this.rebuildFileList();
    }

    public FileSorting getSorting() {
        return this.sorting.get();
    }

    public void setSorting(FileSorting sorting, boolean sortingOrderAscending) {
        this.sorting.set(sorting);
        this.sortingOrderAscending.set(sortingOrderAscending);
        this.rebuildFileList();
    }

    public void setSorting(FileSorting sorting) {
        this.sorting.set(sorting);
        this.rebuildFileList();
    }

    public boolean isSortingOrderAscending() {
        return this.sortingOrderAscending.get();
    }

    public void setSortingOrderAscending(boolean sortingOrderAscending) {
        this.sortingOrderAscending.set(sortingOrderAscending);
        this.rebuildFileList();
    }

    public void setFavoriteFolderButtonVisible(boolean favoriteFolderButtonVisible) {
        this.favoriteFolderButton.setVisible(favoriteFolderButtonVisible);
    }

    public boolean isFavoriteFolderButtonVisible() {
        return this.favoriteFolderButton.isVisible();
    }

    public void setViewModeButtonVisible(boolean viewModeButtonVisible) {
        this.viewModeButton.setVisible(viewModeButtonVisible);
    }

    public boolean isViewModeButtonVisible() {
        return this.viewModeButton.isVisible();
    }

    public boolean isMultiSelectionEnabled() {
        return this.multiSelectionEnabled;
    }

    public void setMultiSelectionEnabled(boolean multiSelectionEnabled) {
        this.multiSelectionEnabled = multiSelectionEnabled;
    }

    public void setListener(FileChooserListener newListener) {
        this.listener = newListener;
        if (this.listener == null) {
            this.listener = new FileChooserAdapter();
        }
    }

    public boolean isShowSelectionCheckboxes() {
        return this.showSelectionCheckboxes;
    }

    public void setShowSelectionCheckboxes(boolean showSelectionCheckboxes) {
        this.showSelectionCheckboxes = showSelectionCheckboxes;
        this.rebuildFileList();
    }

    public int getMultiSelectKey() {
        return this.multiSelectKey;
    }

    public void setMultiSelectKey(int multiSelectKey) {
        this.multiSelectKey = multiSelectKey;
    }

    public int getGroupMultiSelectKey() {
        return this.groupMultiSelectKey;
    }

    public void setGroupMultiSelectKey(int groupMultiSelectKey) {
        this.groupMultiSelectKey = groupMultiSelectKey;
    }

    private boolean isMultiSelectKeyPressed() {
        if (this.multiSelectKey == -1) {
            return UIUtils.ctrl();
        }
        return Gdx.input.isKeyPressed(this.multiSelectKey);
    }

    private boolean isGroupMultiSelectKeyPressed() {
        if (this.groupMultiSelectKey == -1) {
            return UIUtils.shift();
        }
        return Gdx.input.isKeyPressed(this.groupMultiSelectKey);
    }

    public FileChooserStyle getChooserStyle() {
        return this.style;
    }

    public Sizes getSizes() {
        return this.sizes;
    }

    private Stage getChooserStage() {
        return this.getStage();
    }

    public void setWatchingFilesEnabled(boolean watchingFilesEnabled) {
        if (this.getChooserStage() != null) {
            throw new IllegalStateException("Pooling setting cannot be changed when file chooser is added to Stage!");
        }
        this.watchingFilesEnabled = watchingFilesEnabled;
    }

    public void setPrefsName(String prefsName) {
        this.preferencesIO = new PreferencesIO(prefsName);
        this.reloadPreferences(true);
    }

    private void reloadPreferences(boolean rebuildUI) {
        this.favorites = this.preferencesIO.loadFavorites();
        this.recentDirectories = this.preferencesIO.loadRecentDirectories();
        if (rebuildUI) {
            this.rebuildShortcutsFavoritesPanel();
        }
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        super.draw(batch, parentAlpha);
        if (this.shortcutsListRebuildScheduled) {
            this.rebuildShortcutsList();
        }
        if (this.filesListRebuildScheduled) {
            this.rebuildFileList();
        }
    }

    @Override
    protected void setStage(Stage stage) {
        super.setStage(stage);
        if (stage != null) {
            this.refresh();
            this.rebuildShortcutsFavoritesPanel();
            this.deselectAll();
            if (focusFileScrollPaneOnShow) {
                stage.setScrollFocus(this.fileListView.getScrollPane());
            }
        }
        if (this.watchingFilesEnabled) {
            if (stage != null) {
                this.startFileWatcher();
            } else {
                this.stopFileWatcher();
            }
        }
    }

    private void startFileWatcher() {
        if (this.fileWatcherThread != null) {
            return;
        }
        this.fileWatcherThread = new Thread(new Runnable(){
            File[] lastRoots;
            FileHandle lastCurrentDirectory;
            FileHandle[] lastCurrentFiles;

            @Override
            public void run() {
                this.lastRoots = File.listRoots();
                this.lastCurrentDirectory = FileChooser.this.currentDirectory;
                this.lastCurrentFiles = FileChooser.this.currentDirectory.list();
                while (FileChooser.this.fileWatcherThread != null) {
                    Object[] roots = File.listRoots();
                    if (roots.length != this.lastRoots.length || !Arrays.equals(this.lastRoots, roots)) {
                        FileChooser.this.shortcutsListRebuildScheduled = true;
                    }
                    this.lastRoots = roots;
                    if (this.lastCurrentDirectory.equals(FileChooser.this.currentDirectory)) {
                        Object[] currentFiles = FileChooser.this.currentDirectory.list();
                        if (this.lastCurrentFiles.length != currentFiles.length || !Arrays.equals(this.lastCurrentFiles, currentFiles)) {
                            FileChooser.this.filesListRebuildScheduled = true;
                        }
                        this.lastCurrentFiles = currentFiles;
                    } else {
                        this.lastCurrentFiles = FileChooser.this.currentDirectory.list();
                    }
                    this.lastCurrentDirectory = FileChooser.this.currentDirectory;
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }, "FileWatcherThread");
        this.fileWatcherThread.setDaemon(true);
        this.fileWatcherThread.start();
    }

    private void stopFileWatcher() {
        if (this.fileWatcherThread == null) {
            return;
        }
        this.fileWatcherThread.interrupt();
        this.fileWatcherThread = null;
    }

    private void showNewDirectoryDialog() {
        Dialogs.showInputDialog(this.getChooserStage(), FileChooserText.NEW_DIRECTORY_DIALOG_TITLE.get(), FileChooserText.NEW_DIRECTORY_DIALOG_TEXT.get(), true, (InputDialogListener)new InputDialogAdapter(){

            @Override
            public void finished(String input) {
                if (!FileUtils.isValidFileName(input)) {
                    Dialogs.showErrorDialog(FileChooser.this.getChooserStage(), FileChooserText.NEW_DIRECTORY_DIALOG_ILLEGAL_CHARACTERS.get());
                    return;
                }
                for (FileHandle file : FileChooser.this.currentDirectory.list()) {
                    if (!file.name().equals(input)) continue;
                    Dialogs.showErrorDialog(FileChooser.this.getChooserStage(), FileChooserText.NEW_DIRECTORY_DIALOG_ALREADY_EXISTS.get());
                    return;
                }
                FileHandle newDir = FileChooser.this.currentDirectory.child(input);
                newDir.mkdirs();
                FileChooser.this.refresh();
                FileChooser.this.highlightFiles(newDir);
            }
        });
    }

    private void showFileDeleteDialog(final FileHandle fileToDelete) {
        Dialogs.showOptionDialog(this.getChooserStage(), FileChooserText.POPUP_TITLE.get(), this.fileDeleter.hasTrash() ? FileChooserText.CONTEXT_MENU_MOVE_TO_TRASH_WARNING.get() : FileChooserText.CONTEXT_MENU_DELETE_WARNING.get(), Dialogs.OptionDialogType.YES_NO, new OptionDialogAdapter(){

            @Override
            public void yes() {
                try {
                    boolean success = FileChooser.this.fileDeleter.delete(fileToDelete);
                    if (!success) {
                        Dialogs.showErrorDialog(FileChooser.this.getChooserStage(), FileChooserText.POPUP_DELETE_FILE_FAILED.get());
                    }
                }
                catch (IOException e) {
                    Dialogs.showErrorDialog(FileChooser.this.getChooserStage(), FileChooserText.POPUP_DELETE_FILE_FAILED.get(), e);
                    e.printStackTrace();
                }
                FileChooser.this.refresh();
            }
        });
    }

    public void setFileDeleter(FileDeleter fileDeleter) {
        if (fileDeleter == null) {
            throw new IllegalStateException("fileDeleter can't be null");
        }
        this.fileDeleter = fileDeleter;
        this.fileMenu.fileDeleterChanged(fileDeleter.hasTrash());
    }

    public void setIconProvider(FileIconProvider iconProvider) {
        this.iconProvider = iconProvider;
        this.rebuildViewModePopupMenu();
    }

    public FileIconProvider getIconProvider() {
        return this.iconProvider;
    }

    public static boolean isSaveLastDirectory() {
        return saveLastDirectory;
    }

    public static void setSaveLastDirectory(boolean saveLastDirectory) {
        FileChooser.saveLastDirectory = saveLastDirectory;
    }

    private static class ShortcutsComparator
    implements Comparator<Actor> {
        private ShortcutsComparator() {
        }

        @Override
        public int compare(Actor o1, Actor o2) {
            ShortcutItem s1 = (ShortcutItem)o1;
            ShortcutItem s2 = (ShortcutItem)o2;
            return s1.getLabelText().compareTo(s2.getLabelText());
        }
    }

    private class ShortcutItem
    extends Table
    implements FileChooserWinService.RootNameListener,
    Focusable {
        public File file;
        private VisLabel name;

        public ShortcutItem(File file, String customName, Drawable icon) {
            this.file = file;
            this.name = new VisLabel(customName);
            this.name.setEllipsis(true);
            this.add(new Image(icon)).padTop(3.0f);
            Cell<VisLabel> labelCell = this.add(this.name).padRight(6.0f);
            labelCell.width(new Value(){

                @Override
                public float get(Actor context) {
                    return ((FileChooser)FileChooser.this).mainSplitPane.getFirstWidgetBounds().width - 30.0f;
                }
            });
            this.addListener();
        }

        private void addListener() {
            this.addListener(new InputListener(){

                @Override
                public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                    FocusManager.switchFocus(FileChooser.this.getChooserStage(), ShortcutItem.this);
                    FileChooser.this.getChooserStage().setKeyboardFocus(ShortcutItem.this);
                    return true;
                }

                @Override
                public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                    if (event.getButton() == 1) {
                        FileChooser.this.fileMenu.buildForFavorite(FileChooser.this.favorites, ShortcutItem.this.file);
                        FileChooser.this.fileMenu.showMenu(FileChooser.this.getChooserStage(), event.getStageX(), event.getStageY());
                    }
                }

                @Override
                public boolean keyDown(InputEvent event, int keycode) {
                    if (keycode == 112) {
                        FileHandle gdxFile = Gdx.files.absolute(ShortcutItem.this.file.getAbsolutePath());
                        if (FileChooser.this.favorites.contains(gdxFile, false)) {
                            FileChooser.this.removeFavorite(gdxFile);
                        }
                        return true;
                    }
                    return false;
                }
            });
            this.addListener(new ClickListener(){

                @Override
                public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                    FileChooser.this.deselectAll();
                    FileChooser.this.updateSelectedFileFieldText();
                    ShortcutItem.this.select();
                    return super.touchDown(event, x, y, pointer, button);
                }

                @Override
                public void clicked(InputEvent event, float x, float y) {
                    super.clicked(event, x, y);
                    if (this.getTapCount() == 1) {
                        File file = ShortcutItem.this.file;
                        if (!file.exists()) {
                            FileChooser.this.showDialog(FileChooserText.POPUP_DIRECTORY_DOES_NOT_EXIST.get());
                            FileChooser.this.refresh();
                            return;
                        }
                        if (file.isDirectory()) {
                            FileChooser.this.setDirectory(Gdx.files.absolute(file.getAbsolutePath()), HistoryPolicy.ADD);
                            FileChooser.this.getChooserStage().setScrollFocus(FileChooser.this.fileListView.getScrollPane());
                        }
                    }
                }
            });
        }

        public void setLabelText(String text) {
            this.name.setText(text);
        }

        public String getLabelText() {
            return this.name.getText().toString();
        }

        private void select() {
            if (FileChooser.this.selectedShortcut != null) {
                FileChooser.this.selectedShortcut.deselect();
            }
            FileChooser.this.selectedShortcut = this;
            this.setBackground(((FileChooser)FileChooser.this).style.highlight);
        }

        private void deselect() {
            this.setBackground((Drawable)null);
        }

        @Override
        public void setRootName(String newName) {
            this.setLabelText(newName);
        }

        @Override
        public void focusGained() {
        }

        @Override
        public void focusLost() {
        }
    }

    public class FileItem
    extends Table
    implements Focusable {
        private FileHandle file;
        private FileHandleMetadata metadata;
        private VisCheckBox selectCheckBox;
        private VisImage iconImage;

        public FileItem(FileHandle file, ViewMode viewMode) {
            this.file = file;
            this.metadata = (FileHandleMetadata)FileChooser.this.currentFilesMetadata.get(file);
            if (this.metadata == null) {
                this.metadata = FileHandleMetadata.of(file);
            }
            this.setTouchable(Touchable.enabled);
            VisLabel name = new VisLabel((CharSequence)this.metadata.name(), viewMode == ViewMode.SMALL_ICONS ? "small" : "default");
            name.setEllipsis(true);
            Drawable icon = FileChooser.this.iconProvider.provideIcon(this);
            this.selectCheckBox = new VisCheckBox("");
            this.selectCheckBox.setFocusBorderEnabled(false);
            this.selectCheckBox.setProgrammaticChangeEvents(false);
            boolean shouldShowItemShowCheckBox = FileChooser.this.showSelectionCheckboxes && (FileChooser.this.selectionMode == SelectionMode.FILES_AND_DIRECTORIES || FileChooser.this.selectionMode == SelectionMode.FILES && !this.metadata.isDirectory() || FileChooser.this.selectionMode == SelectionMode.DIRECTORIES && this.metadata.isDirectory());
            this.left();
            if (viewMode.isThumbnailMode()) {
                if (shouldShowItemShowCheckBox) {
                    this.iconImage = new VisImage(icon, Scaling.none);
                    IconStack stack = new IconStack(this.iconImage, this.selectCheckBox);
                    this.add(stack).padTop(3.0f).grow().row();
                    this.add(name).minWidth(1.0f);
                } else {
                    this.iconImage = new VisImage(icon, Scaling.none);
                    this.add(this.iconImage).padTop(3.0f).grow().row();
                    this.add(name).minWidth(1.0f);
                }
            } else {
                if (shouldShowItemShowCheckBox) {
                    this.add(this.selectCheckBox).padLeft(3.0f);
                }
                this.iconImage = new VisImage(icon);
                this.add(this.iconImage).padTop(3.0f).minWidth(22.0f * ((FileChooser)FileChooser.this).sizes.scaleFactor);
                this.add(name).minWidth(1.0f).growX().padRight(10.0f);
                VisLabel size = new VisLabel((CharSequence)(this.isDirectory() ? "" : this.metadata.readableFileSize()), "small");
                VisLabel dateLabel = new VisLabel((CharSequence)FileChooser.this.dateFormat.format(this.metadata.lastModified()), "small");
                size.setAlignment(16);
                if (viewMode == ViewMode.DETAILS) {
                    FileChooser.this.maxDateLabelWidth = Math.max(dateLabel.getWidth(), FileChooser.this.maxDateLabelWidth);
                    this.add(size).right().padRight(this.isDirectory() ? 0.0f : 10.0f);
                    this.add(dateLabel).padRight(6.0f).width(new Value(){

                        @Override
                        public float get(Actor context) {
                            return FileChooser.this.maxDateLabelWidth;
                        }
                    });
                }
            }
            this.addListeners();
        }

        public void setIcon(Drawable icon, Scaling scaling) {
            this.iconImage.setDrawable(icon);
            this.iconImage.setScaling(scaling);
            this.iconImage.invalidateHierarchy();
        }

        private void addListeners() {
            this.addListener(new InputListener(){

                @Override
                public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                    FocusManager.switchFocus(FileChooser.this.getChooserStage(), FileItem.this);
                    FileChooser.this.getChooserStage().setKeyboardFocus(FileItem.this);
                    return true;
                }

                @Override
                public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                    if (event.getButton() == 1) {
                        FileChooser.this.fileMenu.build(FileChooser.this.favorites, FileItem.this.file);
                        FileChooser.this.fileMenu.showMenu(FileChooser.this.getChooserStage(), event.getStageX(), event.getStageY());
                    }
                }

                @Override
                public boolean keyDown(InputEvent event, int keycode) {
                    if (keycode == 112) {
                        FileChooser.this.showFileDeleteDialog(FileItem.this.file);
                        return true;
                    }
                    return false;
                }
            });
            this.addListener(new ClickListener(){

                @Override
                public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                    if (!FileItem.this.handleSelectClick(false)) {
                        return false;
                    }
                    return super.touchDown(event, x, y, pointer, button);
                }

                @Override
                public void clicked(InputEvent event, float x, float y) {
                    super.clicked(event, x, y);
                    if (this.getTapCount() == 2 && FileChooser.this.selectedItems.contains(FileItem.this, true)) {
                        if (FileItem.this.file.isDirectory()) {
                            FileChooser.this.setDirectory(FileItem.this.file, HistoryPolicy.ADD);
                        } else {
                            FileChooser.this.selectionFinished();
                        }
                    }
                }
            });
            this.selectCheckBox.addListener(new InputListener(){

                @Override
                public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                    event.stop();
                    return true;
                }
            });
            this.selectCheckBox.addListener(new ChangeListener(){

                @Override
                public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                    event.stop();
                    FileItem.this.handleSelectClick(true);
                }
            });
        }

        private boolean handleSelectClick(boolean checkboxClicked) {
            if (FileChooser.this.selectedShortcut != null) {
                FileChooser.this.selectedShortcut.deselect();
            }
            if (checkboxClicked) {
                if (!FileChooser.this.multiSelectionEnabled && !FileChooser.this.selectedItems.contains(this, true)) {
                    FileChooser.this.deselectAll();
                }
            } else if (!FileChooser.this.multiSelectionEnabled || !FileChooser.this.isMultiSelectKeyPressed() && !FileChooser.this.isGroupMultiSelectKeyPressed()) {
                FileChooser.this.deselectAll();
            }
            boolean itemSelected = this.select();
            if (((FileChooser)FileChooser.this).selectedItems.size > 1 && FileChooser.this.multiSelectionEnabled && FileChooser.this.isGroupMultiSelectKeyPressed()) {
                this.selectGroup();
            }
            if (((FileChooser)FileChooser.this).selectedItems.size > 1) {
                FileChooser.this.removeInvalidSelections();
            }
            FileChooser.this.updateSelectedFileFieldText();
            return itemSelected;
        }

        private void selectGroup() {
            int end;
            int start;
            int lastSelectionIndex;
            Array<FileItem> actors = FileChooser.this.fileListAdapter.getOrderedViews();
            int thisSelectionIndex = this.getItemId(actors, this);
            if (thisSelectionIndex > (lastSelectionIndex = this.getItemId(actors, (FileItem)FileChooser.this.selectedItems.get(((FileChooser)FileChooser.this).selectedItems.size - 2)))) {
                start = lastSelectionIndex;
                end = thisSelectionIndex;
            } else {
                start = thisSelectionIndex;
                end = lastSelectionIndex;
            }
            for (int i = start; i < end; ++i) {
                FileItem item = actors.get(i);
                item.select(false);
            }
        }

        private int getItemId(Array<FileItem> actors, FileItem item) {
            for (int i = 0; i < actors.size; ++i) {
                if (actors.get(i) != item) continue;
                return i;
            }
            throw new IllegalStateException("Item not found in cells");
        }

        private boolean select() {
            return this.select(true);
        }

        private boolean select(boolean deselectIfAlreadySelected) {
            if (deselectIfAlreadySelected && FileChooser.this.selectedItems.contains(this, true)) {
                this.deselect();
                return false;
            }
            this.setBackground(((FileChooser)FileChooser.this).style.highlight);
            this.selectCheckBox.setChecked(true);
            if (!FileChooser.this.selectedItems.contains(this, true)) {
                FileChooser.this.selectedItems.add(this);
            }
            return true;
        }

        private void deselect() {
            this.deselect(true);
        }

        private void deselect(boolean removeFromList) {
            this.setBackground((Drawable)null);
            this.selectCheckBox.setChecked(false);
            if (removeFromList) {
                FileChooser.this.selectedItems.removeValue(this, true);
            }
        }

        @Override
        public void focusLost() {
        }

        @Override
        public void focusGained() {
        }

        public FileHandle getFile() {
            return this.file;
        }

        public boolean isDirectory() {
            return this.metadata.isDirectory();
        }
    }

    private class ShowBusyBarTask
    extends Timer.Task {
        private ShowBusyBarTask() {
        }

        @Override
        public void run() {
            FileChooser.this.fileListBusyBar.resetSegment();
            FileChooser.this.fileListBusyBar.setVisible(true);
            FileChooser.this.currentFiles.clear();
            FileChooser.this.currentFilesMetadata.clear();
            FileChooser.this.fileListAdapter.itemsChanged();
        }

        @Override
        public synchronized void cancel() {
            super.cancel();
            FileChooser.this.fileListBusyBar.setVisible(false);
        }
    }

    public static final class DefaultFileDeleter
    implements FileDeleter {
        @Override
        public boolean hasTrash() {
            return false;
        }

        @Override
        public boolean delete(FileHandle file) {
            return file.deleteDirectory();
        }
    }

    public static interface FileDeleter {
        public boolean hasTrash();

        public boolean delete(FileHandle var1) throws IOException;
    }

    public static class DefaultFileFilter
    implements FileFilter {
        private FileChooser chooser;
        private boolean ignoreChooserSelectionMode = false;

        public DefaultFileFilter(FileChooser chooser) {
            this.chooser = chooser;
        }

        @Override
        public boolean accept(File f) {
            if (f.isHidden()) {
                return false;
            }
            if (this.chooser.getMode() == Mode.OPEN ? !f.canRead() : !f.canWrite()) {
                return false;
            }
            return this.ignoreChooserSelectionMode || f.isDirectory() || this.chooser.getSelectionMode() != SelectionMode.DIRECTORIES;
        }

        public boolean isIgnoreChooserSelectionMode() {
            return this.ignoreChooserSelectionMode;
        }

        public void setIgnoreChooserSelectionMode(boolean ignoreChooserSelectionMode) {
            this.ignoreChooserSelectionMode = ignoreChooserSelectionMode;
        }
    }

    public static class DefaultFileIconProvider
    implements FileIconProvider {
        protected FileChooser chooser;
        protected FileChooserStyle style;

        public DefaultFileIconProvider(FileChooser chooser) {
            this.chooser = chooser;
            this.style = chooser.style;
        }

        @Override
        public Drawable provideIcon(FileItem item) {
            if (item.isDirectory()) {
                return this.getDirIcon(item);
            }
            String ext = item.getFile().extension().toLowerCase();
            if (ext.equals("jpg") || ext.equals("jpeg") || ext.equals("png") || ext.equals("bmp")) {
                return this.getImageIcon(item);
            }
            if (ext.equals("wav") || ext.equals("ogg") || ext.equals("mp3")) {
                return this.getAudioIcon(item);
            }
            if (ext.equals("pdf")) {
                return this.getPdfIcon(item);
            }
            if (ext.equals("txt")) {
                return this.getTextIcon(item);
            }
            return this.getDefaultIcon(item);
        }

        protected Drawable getDirIcon(FileItem item) {
            return this.style.iconFolder;
        }

        protected Drawable getImageIcon(FileItem item) {
            return this.style.iconFileImage;
        }

        protected Drawable getAudioIcon(FileItem item) {
            return this.style.iconFileAudio;
        }

        protected Drawable getPdfIcon(FileItem item) {
            return this.style.iconFilePdf;
        }

        protected Drawable getTextIcon(FileItem item) {
            return this.style.iconFileText;
        }

        protected Drawable getDefaultIcon(FileItem item) {
            return null;
        }

        @Override
        public boolean isThumbnailModesSupported() {
            return false;
        }

        @Override
        public void directoryChanged(FileHandle newDirectory) {
        }

        @Override
        public void viewModeChanged(ViewMode newViewMode) {
        }
    }

    public static interface FileIconProvider {
        public Drawable provideIcon(FileItem var1);

        public boolean isThumbnailModesSupported();

        public void directoryChanged(FileHandle var1);

        public void viewModeChanged(ViewMode var1);
    }

    public static enum ViewMode {
        DETAILS(false, FileChooserText.VIEW_MODE_DETAILS),
        BIG_ICONS(true, FileChooserText.VIEW_MODE_BIG_ICONS),
        MEDIUM_ICONS(true, FileChooserText.VIEW_MODE_MEDIUM_ICONS),
        SMALL_ICONS(true, FileChooserText.VIEW_MODE_SMALL_ICONS),
        LIST(false, FileChooserText.VIEW_MODE_LIST);

        private final FileChooserText bundleText;
        private final boolean thumbnailMode;

        private ViewMode(boolean thumbnailMode, FileChooserText bundleText) {
            this.thumbnailMode = thumbnailMode;
            this.bundleText = bundleText;
        }

        public String getBundleText() {
            return this.bundleText.get();
        }

        public void setupGridGroup(Sizes sizes, GridGroup group) {
            if (!this.isGridMode()) {
                return;
            }
            float gridSize = this.getGridSize(sizes);
            if (gridSize < 0.0f) {
                throw new IllegalStateException("FileChooser's ViewMode " + this.toString() + " has invalid size defined in Sizes. " + "Expected value greater than 0, got: " + gridSize + ". Check your skin Sizes definition.");
            }
            if (this == LIST) {
                group.setItemSize(gridSize, 22.0f * sizes.scaleFactor);
                return;
            }
            group.setItemSize(gridSize);
        }

        public boolean isGridMode() {
            return this.isThumbnailMode() || this == LIST;
        }

        public boolean isThumbnailMode() {
            return this.thumbnailMode;
        }

        public float getGridSize(Sizes sizes) {
            switch (this) {
                case DETAILS: {
                    return -1.0f;
                }
                case BIG_ICONS: {
                    return sizes.fileChooserViewModeBigIconsSize;
                }
                case MEDIUM_ICONS: {
                    return sizes.fileChooserViewModeMediumIconsSize;
                }
                case SMALL_ICONS: {
                    return sizes.fileChooserViewModeSmallIconsSize;
                }
                case LIST: {
                    return sizes.fileChooserViewModeListWidthSize;
                }
            }
            return -1.0f;
        }
    }

    public static enum HistoryPolicy {
        ADD,
        CLEAR,
        IGNORE;

    }

    public static enum FileSorting {
        NAME(FileUtils.FILE_NAME_COMPARATOR),
        MODIFIED_DATE(FileUtils.FILE_MODIFIED_DATE_COMPARATOR),
        SIZE(FileUtils.FILE_SIZE_COMPARATOR);

        private final Comparator<FileHandle> comparator;

        private FileSorting(Comparator<FileHandle> comparator) {
            this.comparator = comparator;
        }
    }

    public static enum SelectionMode {
        FILES,
        DIRECTORIES,
        FILES_AND_DIRECTORIES;

    }

    public static enum Mode {
        OPEN,
        SAVE;

    }
}

