/*
 * Decompiled with CFR 0.152.
 */
package com.kotcrab.vis.ui.widget.file.internal;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.utils.Array;
import com.kotcrab.vis.ui.util.dialog.Dialogs;
import com.kotcrab.vis.ui.widget.VisImageButton;
import com.kotcrab.vis.ui.widget.VisTable;
import com.kotcrab.vis.ui.widget.file.FileChooser;
import com.kotcrab.vis.ui.widget.file.FileChooserStyle;
import com.kotcrab.vis.ui.widget.file.internal.FileChooserText;

public class FileHistoryManager {
    private final FileHistoryCallback callback;
    private Array<FileHandle> history = new Array();
    private Array<FileHandle> historyForward = new Array();
    private VisTable buttonsTable;
    private VisImageButton backButton;
    private VisImageButton forwardButton;

    public FileHistoryManager(FileChooserStyle style, FileHistoryCallback callback) {
        this.callback = callback;
        this.backButton = new VisImageButton(style.iconArrowLeft, FileChooserText.BACK.get());
        this.backButton.setGenerateDisabledImage(true);
        this.backButton.setDisabled(true);
        this.forwardButton = new VisImageButton(style.iconArrowRight, FileChooserText.FORWARD.get());
        this.forwardButton.setGenerateDisabledImage(true);
        this.forwardButton.setDisabled(true);
        this.buttonsTable = new VisTable(true);
        this.buttonsTable.add(this.backButton);
        this.buttonsTable.add(this.forwardButton);
        this.backButton.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                FileHistoryManager.this.historyBack();
            }
        });
        this.forwardButton.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                FileHistoryManager.this.historyForward();
            }
        });
    }

    public ClickListener getDefaultClickListener() {
        return new ClickListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                if (button == 3 || button == 4) {
                    return true;
                }
                return super.touchDown(event, x, y, pointer, button);
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                if (button == 3 && FileHistoryManager.this.hasHistoryBack()) {
                    FileHistoryManager.this.historyBack();
                } else if (button == 4 && FileHistoryManager.this.hasHistoryForward()) {
                    FileHistoryManager.this.historyForward();
                } else {
                    super.touchUp(event, x, y, pointer, button);
                }
            }
        };
    }

    public VisTable getButtonsTable() {
        return this.buttonsTable;
    }

    public void historyClear() {
        this.history.clear();
        this.historyForward.clear();
        this.forwardButton.setDisabled(true);
        this.backButton.setDisabled(true);
    }

    public void historyAdd() {
        this.history.add(this.callback.getCurrentDirectory());
        this.historyForward.clear();
        this.backButton.setDisabled(false);
        this.forwardButton.setDisabled(true);
    }

    public void historyBack() {
        FileHandle dir = this.history.pop();
        this.historyForward.add(this.callback.getCurrentDirectory());
        if (!this.setDirectoryFromHistory(dir)) {
            this.historyForward.pop();
        }
        if (!this.hasHistoryBack()) {
            this.backButton.setDisabled(true);
        }
        this.forwardButton.setDisabled(false);
    }

    public void historyForward() {
        FileHandle dir = this.historyForward.pop();
        this.history.add(this.callback.getCurrentDirectory());
        if (!this.setDirectoryFromHistory(dir)) {
            this.history.pop();
        }
        if (!this.hasHistoryForward()) {
            this.forwardButton.setDisabled(true);
        }
        this.backButton.setDisabled(false);
    }

    private boolean setDirectoryFromHistory(FileHandle dir) {
        if (dir.exists()) {
            this.callback.setDirectory(dir, FileChooser.HistoryPolicy.IGNORE);
            return true;
        }
        Dialogs.showErrorDialog(this.callback.getStage(), FileChooserText.DIRECTORY_NO_LONGER_EXISTS.get());
        return false;
    }

    private boolean hasHistoryForward() {
        return this.historyForward.size != 0;
    }

    private boolean hasHistoryBack() {
        return this.history.size != 0;
    }

    public static interface FileHistoryCallback {
        public FileHandle getCurrentDirectory();

        public void setDirectory(FileHandle var1, FileChooser.HistoryPolicy var2);

        public Stage getStage();
    }
}

