/*
 * Decompiled with CFR 0.152.
 */
package com.kotcrab.vis.ui.widget.file.internal;

import com.badlogic.gdx.Files;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.utils.Array;
import com.kotcrab.vis.ui.widget.MenuItem;
import com.kotcrab.vis.ui.widget.PopupMenu;
import com.kotcrab.vis.ui.widget.file.FileChooser;
import com.kotcrab.vis.ui.widget.file.FileChooserStyle;
import com.kotcrab.vis.ui.widget.file.FileUtils;
import com.kotcrab.vis.ui.widget.file.internal.FileChooserText;
import com.kotcrab.vis.ui.widget.file.internal.SortingPopupMenu;
import java.io.File;
import java.io.IOException;

public class FilePopupMenu
extends PopupMenu {
    private final FileChooserStyle style;
    private SortingPopupMenu sortingPopupMenu;
    private FileHandle file;
    private MenuItem delete;
    private MenuItem newDirectory;
    private MenuItem showInExplorer;
    private MenuItem refresh;
    private MenuItem addToFavorites;
    private MenuItem removeFromFavorites;
    private MenuItem sortBy;

    public FilePopupMenu(final FileChooser chooser, final FilePopupMenuCallback callback) {
        super(chooser.getChooserStyle().popupMenuStyle);
        this.style = chooser.getChooserStyle();
        this.sortingPopupMenu = new SortingPopupMenu(chooser);
        this.delete = new MenuItem(FileChooserText.CONTEXT_MENU_DELETE.get(), this.style.iconTrash);
        this.newDirectory = new MenuItem(FileChooserText.CONTEXT_MENU_NEW_DIRECTORY.get(), this.style.iconFolderNew);
        this.showInExplorer = new MenuItem(FileChooserText.CONTEXT_MENU_SHOW_IN_EXPLORER.get());
        this.refresh = new MenuItem(FileChooserText.CONTEXT_MENU_REFRESH.get(), this.style.iconRefresh);
        this.addToFavorites = new MenuItem(FileChooserText.CONTEXT_MENU_ADD_TO_FAVORITES.get(), this.style.iconFolderStar);
        this.removeFromFavorites = new MenuItem(FileChooserText.CONTEXT_MENU_REMOVE_FROM_FAVORITES.get(), this.style.iconFolderStar);
        this.sortBy = new MenuItem(FileChooserText.CONTEXT_MENU_SORT_BY.get());
        this.sortBy.setSubMenu(this.sortingPopupMenu);
        this.delete.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                callback.showFileDelDialog(FilePopupMenu.this.file);
            }
        });
        this.newDirectory.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                callback.showNewDirDialog();
            }
        });
        this.showInExplorer.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                try {
                    FileUtils.showDirInExplorer(FilePopupMenu.this.file);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
        this.refresh.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                chooser.refresh();
            }
        });
        this.addToFavorites.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                chooser.addFavorite(FilePopupMenu.this.file);
            }
        });
        this.removeFromFavorites.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                chooser.removeFavorite(FilePopupMenu.this.file);
            }
        });
    }

    public void build() {
        this.sortingPopupMenu.build();
        this.clearChildren();
        this.addItem(this.newDirectory);
        this.addItem(this.sortBy);
        this.addItem(this.refresh);
    }

    public void build(Array<FileHandle> favorites, FileHandle file) {
        this.sortingPopupMenu.build();
        this.file = file;
        this.clearChildren();
        this.addItem(this.newDirectory);
        this.addItem(this.sortBy);
        this.addItem(this.refresh);
        this.addSeparator();
        if (file.type() == Files.FileType.Absolute || file.type() == Files.FileType.External) {
            this.addItem(this.delete);
        }
        if (file.type() == Files.FileType.Absolute) {
            this.addItem(this.showInExplorer);
            if (file.isDirectory()) {
                if (favorites.contains(file, false)) {
                    this.addItem(this.removeFromFavorites);
                } else {
                    this.addItem(this.addToFavorites);
                }
            }
        }
    }

    public void buildForFavorite(Array<FileHandle> favorites, File file) {
        this.file = Gdx.files.absolute(file.getAbsolutePath());
        this.clearChildren();
        this.addItem(this.showInExplorer);
        if (favorites.contains(this.file, false)) {
            this.addItem(this.removeFromFavorites);
        }
    }

    public boolean isAddedToStage() {
        return this.getStage() != null;
    }

    public void fileDeleterChanged(boolean trashAvailable) {
        this.delete.setText(trashAvailable ? FileChooserText.CONTEXT_MENU_MOVE_TO_TRASH.get() : FileChooserText.CONTEXT_MENU_DELETE.get());
    }

    public static interface FilePopupMenuCallback {
        public void showNewDirDialog();

        public void showFileDelDialog(FileHandle var1);
    }
}

