/*
 * Decompiled with CFR 0.152.
 */
package com.youkaicountry.anyyes;

import com.youkaicountry.anyyes.INESSpeaker;
import com.youkaicountry.anyyes.NESCPU6502;
import com.youkaicountry.anyyes.NESCPU6502Fast;
import com.youkaicountry.anyyes.NESJoypad;
import com.youkaicountry.anyyes.NESMemory;
import com.youkaicountry.anyyes.NESRecording;
import com.youkaicountry.anyyes.NESRegion;
import com.youkaicountry.anyyes.audio.IExpansionSoundChip;
import com.youkaicountry.anyyes.audio.NESAPU;
import com.youkaicountry.anyyes.cartridges.NESCartridge;
import com.youkaicountry.anyyes.joypads.NESNullJoypad;
import com.youkaicountry.anyyes.video.NESPPU;
import com.youkaicountry.anyyes.video.NESTV;
import com.youkaicountry.emucore.cpu.exceptions.OpcodeNotFoundException;
import com.youkaicountry.emucore.cpu.mos6502.CPU6502;
import com.youkaicountry.util.serialize.ByteSerializer;
import com.youkaicountry.util.serialize.IByteSerialize;
import com.youkaicountry.util.serialize.SerializationInfo;
import com.youkaicountry.util.serialize.StreamUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;

public class NES
implements IByteSerialize {
    public final CPU6502 cpu;
    public final NESPPU ppu;
    public final NESMemory mem = new NESMemory(this);
    public final NESAPU apu;
    public NESTV tv;
    public INESSpeaker speaker;
    public final NESJoypad[] joypads;
    private final boolean cycle_accurate;
    private float time_deficit;
    private ByteSerializer serializer;
    private byte[] quick_save;
    public static final int IRQ_APU = 0;
    public static final int IRQ_CART = 1;
    public static final int IRQ_DMC = 2;
    private NESRecording recording;
    public NESRegion.System system;
    private boolean power;

    public NES(boolean cycle_accurate, NESRegion.System system) {
        this.cpu = cycle_accurate ? new NESCPU6502(this.mem, 3, this) : new NESCPU6502Fast(this.mem, 3, this);
        this.cpu.setPreCall(this.mem);
        this.cycle_accurate = cycle_accurate;
        this.cpu.stack_start = 256;
        this.cpu.setClockSpeed(1790000.0f);
        this.ppu = new NESPPU(this);
        this.apu = new NESAPU(this, true);
        this.joypads = new NESJoypad[2];
        this.joypads[0] = new NESNullJoypad();
        this.joypads[1] = new NESNullJoypad();
        this.power = false;
        this.setupSerializer();
    }

    private void setupSerializer() {
        this.serializer = new ByteSerializer();
        this.serializer.addTarget(this.cpu);
        this.serializer.addTarget(this.mem);
        this.serializer.addTarget(this.ppu);
        this.serializer.addTarget(this.apu);
        this.serializer.addTarget(this);
    }

    public void quickSave() {
        this.quick_save = this.saveState(true);
    }

    public boolean quickLoad() {
        if (this.quick_save == null) {
            return false;
        }
        this.loadState(this.quick_save, true);
        return true;
    }

    public byte[] saveState(boolean compress) {
        ByteArrayOutputStream bstream = new ByteArrayOutputStream();
        try {
            DeflaterOutputStream zstream = new DeflaterOutputStream(bstream);
            this.serializer.serialize(zstream);
            zstream.close();
            bstream.close();
        }
        catch (Exception e) {
            System.out.println(e);
            e.printStackTrace();
        }
        return bstream.toByteArray();
    }

    public void loadState(byte[] buffer, boolean compress) {
        ByteArrayInputStream bstream = new ByteArrayInputStream(buffer);
        try {
            InflaterInputStream zstream = new InflaterInputStream(bstream);
            ByteArrayInputStream fstream = new ByteArrayInputStream(StreamUtil.inflate(zstream));
            zstream.close();
            this.serializer.deserialize(fstream);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public boolean startRecording() {
        if (this.isPlayingRecording()) {
            return false;
        }
        this.stopRecording(true);
        NESRecording recording = new NESRecording(this);
        recording.startRecording();
        this.recording = recording;
        return true;
    }

    public boolean isRecording() {
        return this.recording != null;
    }

    public byte[] stopRecording(boolean hard_stop) {
        if (!this.isRecording() || hard_stop) {
            for (int i = 0; i < this.joypads.length; ++i) {
                this.joypads[i].stopRecording();
            }
            this.recording = null;
            return null;
        }
        this.recording.stopRecording();
        byte[] rec = this.recording.saveRecording();
        this.recording.clearRecording();
        this.recording = null;
        return rec;
    }

    public void playRecording(byte[] recording) {
        this.stopRecording(true);
        NESRecording r = new NESRecording(this);
        r.playRecording(recording);
    }

    public boolean isPlayingRecording() {
        for (int i = 0; i < this.joypads.length; ++i) {
            if (!this.joypads[i].is_playing) continue;
            return true;
        }
        return false;
    }

    public boolean stopPlayingRecording() {
        if (!this.isPlayingRecording()) {
            return false;
        }
        for (int i = 0; i < this.joypads.length; ++i) {
            this.joypads[i].stopPlaying();
        }
        return true;
    }

    public boolean hasTV() {
        return this.tv != null;
    }

    public void attachTV(NESTV tv) {
        tv.onAttach();
        this.tv = tv;
        this.ppu.setRenderDirty();
    }

    public void detachTV() {
        if (this.hasTV()) {
            this.tv.onDetach();
            this.tv = null;
        }
    }

    public boolean hasSpeaker() {
        return this.speaker != null;
    }

    public void attachSpeaker(INESSpeaker speaker) {
        this.speaker = speaker;
        if (speaker == null) {
            return;
        }
        this.apu.setSampleRate(speaker.getSampleRate());
        speaker.init(this.apu.getBufferSize());
    }

    public void insertCartridge(NESCartridge cartridge) {
        this.mem.insertCartridge(cartridge);
        cartridge.setNES(this);
        this.ppu.mapper = cartridge.mapper;
        IExpansionSoundChip[] sounds = cartridge.getMapper().getExpansionSoundChips();
        if (sounds != null) {
            for (int i = 0; i < sounds.length; ++i) {
                this.apu.addExpansionChip(sounds[i]);
            }
        }
        this.serializer.addTarget(cartridge);
        this.serializer.addTarget(cartridge.mapper);
    }

    public void removeCartridge() {
        NESCartridge cart = this.mem.getCartridge();
        if (cart == null) {
            return;
        }
        this.mem.removeCartridge();
        this.ppu.mapper = null;
        cart.setNES(null);
        this.apu.clearExpansionChips();
        this.serializer.removeTarget(cart);
        this.serializer.removeTarget(cart.mapper);
    }

    public boolean hasCartridge() {
        return this.mem.cartridge != null;
    }

    public void attachJoypad(int slot, NESJoypad joypad) {
        this.joypads[slot] = joypad;
    }

    public void powerOn(boolean on) {
        if (on) {
            this.power = true;
            this.reset();
        } else {
            this.power = false;
        }
    }

    public boolean isPowered() {
        return this.power;
    }

    public void reset() {
        if (!this.power) {
            return;
        }
        this.cpu.reset();
        this.ppu.reset();
        this.apu.reset();
        for (int i = 0; i < this.joypads.length; ++i) {
            this.joypads[i].reset();
        }
    }

    public void executeTimeSlice(float time) throws OpcodeNotFoundException {
        if (!this.power) {
            return;
        }
        this.updateJoypads(time);
        this.time_deficit = this.cpu.executeTimeSlice(time - this.time_deficit);
    }

    private void updateJoypads(float time) {
        for (int i = 0; i < this.joypads.length; ++i) {
            this.joypads[0].update(time);
            this.joypads[1].update(time);
        }
    }

    public void setJoypadsDirty() {
        for (int i = 0; i < this.joypads.length; ++i) {
            this.joypads[i].setDirty();
        }
    }

    @Override
    public void serialization(SerializationInfo info) throws IOException {
        boolean is_recording;
        ByteSerializer.serializationBoolean(info, this.power);
        if (info.serializing) {
            is_recording = this.isRecording();
            ByteSerializer.serializationBoolean(info, is_recording);
            if (is_recording) {
                byte[] save_state = this.recording.saveState;
                ByteSerializer.serializationInt(info, save_state.length);
                ByteSerializer.serializationByteArray(info, save_state);
            }
            ByteSerializer.serializationInt(info, this.joypads.length);
        } else {
            this.stopRecording(true);
            is_recording = ByteSerializer.serializationBoolean(info, false);
            if (is_recording) {
                int ss_length = ByteSerializer.serializationInt(info, -1);
                if (ss_length > 0) {
                    byte[] save_state = new byte[ss_length];
                    ByteSerializer.serializationByteArray(info, save_state);
                    this.recording = new NESRecording(this, save_state);
                } else {
                    this.recording = new NESRecording(this);
                }
            }
            ByteSerializer.serializationInt(info, -1);
        }
        for (int i = 0; i < this.joypads.length; ++i) {
            this.joypads[i].serialization(info);
        }
    }
}

