/*
 * Decompiled with CFR 0.152.
 */
package com.youkaicountry.anyyes;

import com.youkaicountry.anyyes.NES;
import com.youkaicountry.emucore.IMemRW;
import com.youkaicountry.emucore.cpu.mos6502.CPU6502;

public class NESCPU6502
extends CPU6502 {
    final NES nes;

    public NESCPU6502(IMemRW memory, int irq_lines, NES nes) {
        super(memory, irq_lines, false, true);
        this.nes = nes;
    }

    @Override
    protected final int rd(int address) {
        this.tk();
        return this.memory.read(address);
    }

    @Override
    protected final void wr(int address, int val) {
        this.tk();
        this.memory.write(address, val);
    }

    @Override
    protected final int getAddressZPX(int x) {
        this.tk();
        return this.consumeByte() + x & 0xFF;
    }

    @Override
    protected final void crossTick(int a, int b, int low, int high) {
        if (this.cross(a, b)) {
            int abs = this.getAddressAB(low, high, 0);
            this.rd(abs + b - 256);
        }
    }

    @Override
    protected final void tk() {
        ++this.nes.cpu.cycles_elapsed;
        if (this.nes.mem.cartridge.getMapper().cpu_tick) {
            this.nes.mem.cartridge.getMapper().CPUTick();
        }
        this.nes.cpu.cycle_odd ^= true;
        this.nes.ppu.cycle();
        this.nes.ppu.cycle();
        this.nes.ppu.cycle();
        this.nes.apu.cycle();
    }

    @Override
    public final void doTicks(int num) {
        for (int i = 0; i < num; ++i) {
            ++this.nes.cpu.cycles_elapsed;
            if (this.nes.mem.cartridge.getMapper().cpu_tick) {
                this.nes.mem.cartridge.getMapper().CPUTick();
            }
            this.nes.cpu.cycle_odd ^= true;
            this.nes.ppu.cycle();
            this.nes.ppu.cycle();
            this.nes.ppu.cycle();
            this.nes.apu.cycle();
        }
    }
}

