/*
 * Decompiled with CFR 0.152.
 */
package com.youkaicountry.anyyes;

import com.youkaicountry.anyyes.NES;
import com.youkaicountry.emucore.cpu.mos6502.CPU6502Tables;
import com.youkaicountry.emucore.cpu.mos6502.Disassemble6502;

public class NESDebugger {
    public NES nes;
    Disassemble6502 dis;

    public NESDebugger(NES nes) {
        this.nes = nes;
        this.dis = new Disassemble6502(nes.cpu, true);
    }

    public String getMemory(int address, int pad_to) {
        return this.getPaddedHexString(this.nes.mem.read(address), pad_to);
    }

    public String getNESState() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getCurrentPCString(6));
        sb.append(this.getCurrentInstructionHex(10));
        sb.append(this.getCurrentASMString(32));
        sb.append(this.getCurrentRegistersString(26));
        sb.append(this.getCurrentPPUCyclesString(8));
        sb.append(this.getCurrentPPUScanlineString(0));
        return sb.toString();
    }

    public String getCurrentPCString(int pad_to) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getPaddedHexString(this.nes.cpu.pc, 4));
        while (sb.length() < pad_to) {
            sb.append(" ");
        }
        return sb.toString();
    }

    public String getCurrentInstructionHex(int pad_to) {
        StringBuilder sb = new StringBuilder();
        int pc = this.nes.cpu.pc;
        for (int i = 0; i < CPU6502Tables.instruction_bytes[this.nes.mem.read(pc)]; ++i) {
            sb.append(this.getMemory(this.nes.cpu.pc + i, 2));
            sb.append(" ");
        }
        while (sb.length() < pad_to) {
            sb.append(" ");
        }
        return sb.toString();
    }

    public String getCurrentASMString(int pad_to) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.dis.getCurrentASMString());
        while (sb.length() < pad_to) {
            sb.append(" ");
        }
        return sb.toString();
    }

    public String getCurrentRegistersString(int pad_to) {
        StringBuilder sb = new StringBuilder();
        sb.append("A:");
        sb.append(this.getPaddedHexString(this.nes.cpu.a, 2));
        sb.append(" ");
        sb.append("X:");
        sb.append(this.getPaddedHexString(this.nes.cpu.x, 2));
        sb.append(" ");
        sb.append("Y:");
        sb.append(this.getPaddedHexString(this.nes.cpu.y, 2));
        sb.append(" ");
        sb.append("P:");
        sb.append(this.getPaddedHexString(this.nes.cpu.p, 2));
        sb.append(" ");
        sb.append("SP:");
        sb.append(this.getPaddedHexString(this.nes.cpu.s, 2));
        while (sb.length() < pad_to) {
            sb.append(" ");
        }
        return sb.toString();
    }

    public String getCurrentPPUScanlineString(int pad_to) {
        StringBuilder sb = new StringBuilder();
        sb.append("SL:");
        String c = Integer.toString(this.nes.ppu.scanline == 261 ? -1 : this.nes.ppu.scanline);
        sb.append(c);
        while (sb.length() < pad_to) {
            sb.append(" ");
        }
        return sb.toString();
    }

    public String getCurrentPPUCyclesString(int pad_to) {
        StringBuilder sb = new StringBuilder();
        sb.append("CYC:");
        String c = Integer.toString(this.nes.ppu.dot);
        for (int i = 0; i < 3 - c.length(); ++i) {
            sb.append(" ");
        }
        sb.append(c);
        while (sb.length() < pad_to) {
            sb.append(" ");
        }
        return sb.toString();
    }

    private String getPaddedHexString(int val, int pad_to) {
        StringBuilder sb = new StringBuilder();
        sb.append(Integer.toHexString(val));
        while (sb.length() < pad_to) {
            sb.insert(0, "0");
        }
        return sb.toString().toUpperCase();
    }

    public String getNameTableString(int nt) {
        StringBuilder sb = new StringBuilder();
        int address = 8192 + 1024 * nt;
        for (int y = 0; y < 30; ++y) {
            for (int x = 0; x < 32; ++x) {
                sb.append(this.getPaddedHexString(this.nes.ppu.read(address), 2));
                sb.append(" ");
                ++address;
            }
            sb.append("\n");
        }
        return sb.toString();
    }
}

