/*
 * Decompiled with CFR 0.152.
 */
package com.youkaicountry.anyyes;

import com.youkaicountry.anyyes.IJoypadPusher;
import com.youkaicountry.util.compression.RLETapeInt;
import com.youkaicountry.util.serialize.ByteSerializer;
import com.youkaicountry.util.serialize.IByteSerialize;
import com.youkaicountry.util.serialize.SerializationInfo;
import java.io.IOException;

public abstract class NESJoypad
implements IByteSerialize {
    boolean up_pressed = false;
    boolean down_pressed = false;
    boolean left_pressed = false;
    boolean right_pressed = false;
    boolean start_pressed = false;
    boolean select_pressed = false;
    boolean a_pressed = false;
    boolean b_pressed = false;
    public static final int CHECK_RESOLUTION = 1;
    int cycle = 0;
    int check_result;
    int slot;
    IJoypadPusher pusher;
    int shift;
    boolean strobe;
    boolean is_recording;
    RLETapeInt rle;
    boolean is_playing;
    private final boolean dirty_enabled = true;
    boolean is_dirty;

    public NESJoypad(IJoypadPusher pusher, int slot) {
        this.pusher = pusher;
        this.slot = slot;
        this.is_recording = false;
        this.rle = new RLETapeInt();
        this.setDirty();
    }

    public int read() {
        if (this.strobe) {
            return 0x40 | this.getCurrentState() & 1;
        }
        int j = 0x40 | this.shift & 1;
        this.shift = 0x80 | this.shift >> 1;
        return j;
    }

    public void write_strobe(boolean v) {
        if (this.strobe & !v) {
            this.shift = this.getCurrentState();
        }
        this.strobe = v;
    }

    public void setUpPressed(boolean pressed) {
        this.up_pressed = pressed;
    }

    public void setDownPressed(boolean pressed) {
        this.down_pressed = pressed;
    }

    public void setLeftPressed(boolean pressed) {
        this.left_pressed = pressed;
    }

    public void setRightPressed(boolean pressed) {
        this.right_pressed = pressed;
    }

    public void setSelectPressed(boolean pressed) {
        this.select_pressed = pressed;
    }

    public void setStartPressed(boolean pressed) {
        this.start_pressed = pressed;
    }

    public void setBPressed(boolean pressed) {
        this.b_pressed = pressed;
    }

    public void setAPressed(boolean pressed) {
        this.a_pressed = pressed;
    }

    public int getCurrentState() {
        if (this.cycle % 1 == 0) {
            if (this.is_playing) {
                if (this.rle.hasNext()) {
                    this.check_result = this.rle.getNext();
                } else {
                    this.is_playing = false;
                }
            } else {
                this.getClass();
                if (this.is_dirty) {
                    if (this.pusher != null) {
                        this.pusher.getPushState(this, this.slot);
                    }
                    this.check_result = this.a_pressed ? 1 : 0;
                    this.check_result |= (this.b_pressed ? 1 : 0) << 1;
                    this.check_result |= (this.select_pressed ? 1 : 0) << 2;
                    this.check_result |= (this.start_pressed ? 1 : 0) << 3;
                    this.check_result |= (this.up_pressed ? 1 : 0) << 4;
                    this.check_result |= (this.down_pressed ? 1 : 0) << 5;
                    this.check_result |= (this.left_pressed ? 1 : 0) << 6;
                    this.check_result |= (this.right_pressed ? 1 : 0) << 7;
                    this.is_dirty = false;
                }
                if (this.is_recording) {
                    this.rle.add(this.check_result);
                }
            }
        }
        ++this.cycle;
        return this.check_result;
    }

    public String getRLEString() {
        return this.rle.toString();
    }

    public abstract void update(float var1);

    public void startRecording() {
        this.is_recording = true;
    }

    public void stopRecording() {
        this.is_recording = false;
    }

    public void resetRecording() {
        this.rle.clear();
    }

    public RLETapeInt getRecording() {
        return this.rle;
    }

    public void setRecording(int[] recording) {
        this.rle.clear();
        this.rle.setRLE(recording);
    }

    public void playRecording() {
        this.rle.startPlaying();
        this.is_playing = this.rle.hasNext();
    }

    public void stopPlaying() {
        this.rle.clear();
        this.is_playing = false;
    }

    @Override
    public void serialization(SerializationInfo info) throws IOException {
        this.cycle = ByteSerializer.serializationInt(info, this.cycle);
        this.check_result = ByteSerializer.serializationInt(info, this.check_result);
        this.shift = ByteSerializer.serializationInt(info, this.shift);
        this.strobe = ByteSerializer.serializationBoolean(info, this.strobe);
        this.is_recording = ByteSerializer.serializationBoolean(info, this.is_recording);
        if (info.serializing) {
            int[] rle_array = this.rle.getRLEArray();
            ByteSerializer.serializationInt(info, rle_array.length);
            ByteSerializer.serializationIntArray(info, rle_array);
        } else {
            int rle_size = ByteSerializer.serializationInt(info, -1);
            int[] rle_array = new int[rle_size];
            ByteSerializer.serializationIntArray(info, rle_array);
            this.setRecording(rle_array);
            this.setDirty();
        }
    }

    public void reset() {
        this.cycle = 0;
        this.up_pressed = false;
        this.down_pressed = false;
        this.left_pressed = false;
        this.right_pressed = false;
        this.start_pressed = false;
        this.select_pressed = false;
        this.a_pressed = false;
        this.b_pressed = false;
        this.is_recording = false;
        this.rle = new RLETapeInt();
        this.setDirty();
    }

    public final void setDirty() {
        this.is_dirty = true;
    }
}

