/*
 * Decompiled with CFR 0.152.
 */
package com.youkaicountry.anyyes;

import com.youkaicountry.anyyes.NES;
import com.youkaicountry.anyyes.cartridges.NESCartridge;
import com.youkaicountry.emucore.ICPUCall;
import com.youkaicountry.emucore.IMemRW;
import com.youkaicountry.util.serialize.ByteSerializer;
import com.youkaicountry.util.serialize.IByteSerialize;
import com.youkaicountry.util.serialize.SerializationInfo;
import java.io.IOException;

public class NESMemory
implements IMemRW,
ICPUCall,
IByteSerialize {
    public static final int INTERNAL_RAM = 0;
    private static final int INTERNAL_RAM_SIZE = 2048;
    private static final int PPU_REGISTERS = 8192;
    private static final int PPU_REGISTERS_SIZE = 8;
    public static final int APU_IO = 16384;
    public static final int APU_IO_SIZE = 24;
    private static final int OAM_DMA = 16404;
    private static final int JOYPAD0 = 16406;
    private static final int JOYPAD1_APU = 16407;
    private static final int APU = 16384;
    private static final int CARTRIDGE = 16416;
    public NESCartridge cartridge;
    private final byte[] memory = new byte[16384];
    private final NES nes;
    private int oam_bank;
    public boolean in_dma;

    public NESMemory(NES nes) {
        this.nes = nes;
    }

    public void insertCartridge(NESCartridge cartridge) {
        this.cartridge = cartridge;
    }

    public void removeCartridge() {
        this.cartridge = null;
    }

    public NESCartridge getCartridge() {
        return this.cartridge;
    }

    @Override
    public final int read(int address) {
        int uaddress;
        int res = address >= 16416 ? this.cartridge.read(address) : (address == 16406 ? this.nes.joypads[0].read() : (address == 16407 ? this.nes.joypads[1].read() : (address >= 16384 ? this.nes.apu.read(address) : ((uaddress = this.resolveAddress(address)) >= 8192 && uaddress <= 8199 ? this.nes.ppu.read_register(uaddress - 8192) : this.memory[uaddress] & 0xFF))));
        this.nes.cpu.data_bus = res;
        return res;
    }

    @Override
    public final void write(int address, int value) {
        this.nes.cpu.data_bus = value;
        if (address >= 16416) {
            this.cartridge.write(address, value);
            return;
        }
        if (address >= 16384 && address < 16404 || address == 16405 || address == 16407) {
            this.nes.apu.write(address, value);
            return;
        }
        if (address == 16404) {
            this.oamDMA(value);
            return;
        }
        if (address == 16406) {
            this.nes.joypads[0].write_strobe((value & 1) != 0);
            this.nes.joypads[1].write_strobe((value & 1) != 0);
            return;
        }
        int uaddress = this.resolveAddress(address);
        if (uaddress >= 8192 && uaddress <= 8199) {
            this.nes.ppu.write_register(uaddress - 8192, value);
            return;
        }
        if (uaddress >= 16408) {
            return;
        }
        this.memory[uaddress] = (byte)value;
    }

    private int resolveAddress(int address) {
        if (address < 8192) {
            return address % 2048;
        }
        if (address < 16384) {
            return 8192 + address % 8;
        }
        return address;
    }

    private void oamDMA(int bank) {
        this.in_dma = true;
        this.nes.cpu.doTicks(1 + (this.nes.cpu.cycle_odd ? 1 : 0));
        for (int i = 0; i < 256; ++i) {
            int val = this.read(bank * 256 + i);
            this.write(8212, val);
        }
        this.nes.cpu.doTicks(512);
        this.in_dma = false;
    }

    @Override
    public void call() {
        this.oamDMA(this.oam_bank);
    }

    @Override
    public void serialization(SerializationInfo info) throws IOException {
        ByteSerializer.serializationByteArray(info, this.memory);
        this.oam_bank = ByteSerializer.serializationInt(info, this.oam_bank);
    }
}

