/*
 * Decompiled with CFR 0.152.
 */
package com.youkaicountry.anyyes;

import com.youkaicountry.anyyes.NES;
import com.youkaicountry.util.compression.RLETapeInt;
import com.youkaicountry.util.serialize.ByteSerializer;
import com.youkaicountry.util.serialize.StreamUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;

public class NESRecording {
    NES nes;
    public byte[] saveState;

    public NESRecording(NES nes) {
        this.nes = nes;
    }

    public NESRecording(NES nes, byte[] save_state) {
        this.nes = nes;
        this.saveState = save_state;
    }

    public void startRecording() {
        this.saveState = this.nes.saveState(true);
        for (int i = 0; i < this.nes.joypads.length; ++i) {
            this.nes.joypads[i].startRecording();
        }
    }

    public void stopRecording() {
        for (int i = 0; i < this.nes.joypads.length; ++i) {
            this.nes.joypads[i].stopRecording();
        }
    }

    public byte[] saveRecording() {
        ByteArrayOutputStream bstream = new ByteArrayOutputStream();
        try {
            DeflaterOutputStream zstream = new DeflaterOutputStream(bstream);
            DataOutputStream dstream = new DataOutputStream(zstream);
            dstream.writeInt(this.saveState.length);
            ByteSerializer.serializeByteArray(dstream, this.saveState);
            dstream.writeInt(1);
            dstream.writeInt(this.nes.joypads.length);
            for (int i = 0; i < this.nes.joypads.length; ++i) {
                RLETapeInt rle = this.nes.joypads[i].getRecording();
                int[] data = rle.getRLEArray();
                dstream.writeInt(data.length);
                ByteSerializer.serializeIntArray(dstream, data);
            }
            dstream.close();
            zstream.close();
        }
        catch (Exception e) {
            System.out.println(e);
        }
        return bstream.toByteArray();
    }

    public void clearRecording() {
        for (int i = 0; i < this.nes.joypads.length; ++i) {
            this.nes.joypads[i].stopRecording();
            this.nes.joypads[i].resetRecording();
        }
    }

    public void playRecording(byte[] recording) {
        ByteArrayInputStream bstream = new ByteArrayInputStream(recording);
        try {
            InflaterInputStream zstream = new InflaterInputStream(bstream);
            ByteArrayInputStream fstream = new ByteArrayInputStream(StreamUtil.inflate(zstream));
            zstream.close();
            DataInputStream dstream = new DataInputStream(fstream);
            int length = dstream.readInt();
            byte[] ss = new byte[length];
            dstream.read(ss);
            this.nes.loadState(ss, true);
            int res = dstream.readInt();
            int jp = dstream.readInt();
            for (int i = 0; i < jp; ++i) {
                int jl = dstream.readInt();
                int[] jr = new int[jl];
                ByteSerializer.deserializeIntArray(dstream, jr);
                this.nes.joypads[i].setRecording(jr);
                this.nes.joypads[i].playRecording();
            }
            dstream.close();
        }
        catch (Exception e) {
            System.out.println(e);
            return;
        }
    }
}

