/*
 * Decompiled with CFR 0.152.
 */
package com.youkaicountry.anyyes.audio;

import com.youkaicountry.anyyes.NESRegion;

public class APUChannel {
    protected static int[] lenctrTable = new int[]{10, 254, 20, 2, 40, 4, 80, 6, 160, 8, 60, 10, 14, 12, 26, 14, 12, 16, 24, 18, 48, 20, 96, 22, 192, 24, 72, 26, 16, 28, 32, 30};
    private int lengthCounter;
    private int lengthCounterReload = 0;
    protected boolean lenctrLoop;
    private boolean lenctrHalt = false;
    private boolean lenctrHaltRequest = false;
    private boolean lengthCounterReloading;
    private boolean lenctrReloadRequest = false;
    protected int frequency;
    public final NESRegion region = new NESRegion();
    public final NESRegion.System system;

    public APUChannel(NESRegion.System system) {
        this.system = system;
        this.region.singleCycle = this.getCycles(this.frequency + 1);
    }

    private int getCycles(int cycles) {
        return cycles * this.system.apu;
    }

    public void initialize() {
        this.hardReset();
    }

    public void hardReset() {
        this.lenctrHalt = false;
        this.lenctrHaltRequest = false;
        this.lengthCounter = 0;
        this.lengthCounterReloading = false;
        this.lengthCounterReload = 0;
        this.lenctrReloadRequest = false;
    }

    public void softReset() {
        this.lengthCounterReloading = false;
        this.lengthCounter = 0;
    }

    public void clockChannel(boolean clockLength) {
        this.lenctrHalt = this.lenctrHaltRequest;
        if (clockLength && this.lengthCounter > 0) {
            this.lenctrReloadRequest = false;
        }
        if (this.lenctrReloadRequest) {
            if (this.lengthCounterReloading) {
                this.lengthCounter = this.lengthCounterReload;
            }
            this.lenctrReloadRequest = false;
        }
    }

    public boolean getStatus() {
        return this.lengthCounter > 0;
    }

    public void setStatus(boolean status) {
        this.lengthCounterReloading = status;
        if (!this.lengthCounterReloading) {
            this.lengthCounter = 0;
        }
    }

    public void cycle(int cycles) {
        while (this.region.cycles < cycles) {
            this.region.cycles += this.region.singleCycle;
            this.cycle();
        }
        this.region.cycles -= cycles;
    }

    public void cycle() {
    }
}

