/*
 * Decompiled with CFR 0.152.
 */
package com.youkaicountry.anyyes.audio;

import com.youkaicountry.anyyes.NES;
import com.youkaicountry.anyyes.audio.IAPUChannel;
import com.youkaicountry.util.serialize.ByteSerializer;
import com.youkaicountry.util.serialize.IByteSerialize;
import com.youkaicountry.util.serialize.SerializationInfo;
import java.io.IOException;

public class DeltaModulationChannel
implements IAPUChannel,
IByteSerialize {
    final NES nes;
    private boolean irq;
    private int timer_load;
    private boolean loop;
    private boolean irq_enabled;
    private int sample_address_load;
    private int sample_address;
    private int sample_length_load;
    private int sample_length;
    private int output;
    private int timer;
    private boolean silenced;
    private int shift_register;
    private int sample_buffer;
    private boolean sample_buffer_empty;
    private int shift_bits_remaining;
    private boolean in_dma;
    private final int[] rateTable = new int[]{428, 380, 340, 320, 286, 254, 226, 214, 190, 160, 142, 128, 106, 84, 72, 54};

    public DeltaModulationChannel(NES nes) {
        this.nes = nes;
    }

    @Override
    public void tick() {
        if (this.in_dma) {
            return;
        }
        if (this.timer > 0) {
            --this.timer;
        } else {
            this.timer = this.timer_load;
            if (!this.silenced) {
                if ((this.shift_register & 1) == 1 && this.output <= 125) {
                    this.output += 2;
                } else if ((this.shift_register & 1) == 0 && this.output >= 2) {
                    this.output -= 2;
                }
            }
            this.shift_register >>= 1;
            --this.shift_bits_remaining;
            if (this.shift_bits_remaining == 0) {
                this.shift_bits_remaining = 8;
                if (this.sample_buffer_empty) {
                    this.silenced = true;
                } else {
                    this.silenced = false;
                    this.shift_register = this.sample_buffer;
                }
                this.sample_buffer_empty = true;
            }
        }
        if (this.sample_length > 0 && this.sample_buffer_empty) {
            int to_stall = this.nes.mem.in_dma ? 4 : 1;
            this.in_dma = true;
            this.nes.cpu.doTicks(to_stall);
            this.in_dma = false;
            this.sample_buffer = this.nes.cpu.memory.read(this.sample_address);
            this.sample_buffer_empty = false;
            this.sample_address = this.sample_address + 1 & 0xFFFF | 0x8000;
            --this.sample_length;
            if (this.sample_length == 0) {
                if (this.loop) {
                    this.sample_length = this.sample_length_load;
                    this.sample_address = this.sample_address_load;
                } else if (this.irq_enabled) {
                    this.nes.cpu.setIRQ(2, true);
                    this.irq = true;
                }
            }
        }
    }

    @Override
    public final void halfFrameTick() {
    }

    @Override
    public final void quarterFrameTick() {
    }

    @Override
    public void write(int address, int value) {
        int registerNum = address & 3;
        switch (registerNum) {
            case 0: {
                this.timer_load = this.rateTable[value & 0xF] - 1;
                this.loop = (value & 0x40) == 64;
                boolean bl = this.irq_enabled = (value & 0x80) == 128;
                if (this.irq_enabled) break;
                this.nes.cpu.setIRQ(2, false);
                this.irq = false;
                break;
            }
            case 1: {
                this.output = value & 0x7F;
                break;
            }
            case 2: {
                this.sample_address_load = 0xC000 | value << 6;
                break;
            }
            case 3: {
                this.sample_length_load = (value << 4) + 1;
            }
        }
    }

    @Override
    public final void setEnabled(boolean enabled) {
        if (!enabled) {
            this.sample_length = 0;
        } else if (this.sample_length == 0) {
            this.sample_length = this.sample_length_load;
            this.sample_address = this.sample_address_load;
        }
        this.nes.cpu.setIRQ(2, false);
        this.irq = false;
    }

    @Override
    public final int getOutput() {
        return this.output;
    }

    @Override
    public final boolean isLengthPositive() {
        return this.sample_length > 0;
    }

    public final boolean isIRQEnabled() {
        return this.irq;
    }

    @Override
    public void serialization(SerializationInfo info) throws IOException {
        this.irq = ByteSerializer.serializationBoolean(info, this.irq);
        this.timer_load = ByteSerializer.serializationInt(info, this.timer_load);
        this.loop = ByteSerializer.serializationBoolean(info, this.loop);
        this.irq_enabled = ByteSerializer.serializationBoolean(info, this.irq_enabled);
        this.sample_address_load = ByteSerializer.serializationInt(info, this.sample_address_load);
        this.sample_address = ByteSerializer.serializationInt(info, this.sample_address);
        this.sample_length_load = ByteSerializer.serializationInt(info, this.sample_length_load);
        this.sample_length = ByteSerializer.serializationInt(info, this.sample_length);
        this.output = ByteSerializer.serializationInt(info, this.output);
        this.timer = ByteSerializer.serializationInt(info, this.timer);
        this.silenced = ByteSerializer.serializationBoolean(info, this.silenced);
        this.shift_register = ByteSerializer.serializationInt(info, this.shift_register);
        this.sample_buffer = ByteSerializer.serializationInt(info, this.sample_buffer);
        this.sample_buffer_empty = ByteSerializer.serializationBoolean(info, this.sample_buffer_empty);
        this.shift_bits_remaining = ByteSerializer.serializationInt(info, this.shift_bits_remaining);
        this.in_dma = ByteSerializer.serializationBoolean(info, this.in_dma);
    }

    public void reset() {
        this.irq = false;
        this.timer_load = 0;
        this.loop = false;
        this.irq_enabled = false;
        this.sample_address_load = 0;
        this.sample_length = 0;
        this.output = 0;
        this.timer = 0;
        this.silenced = false;
        this.shift_register = 0;
        this.sample_buffer = 0;
        this.sample_buffer_empty = false;
        this.in_dma = false;
        this.shift_bits_remaining = 8;
        this.sample_length_load = 32768;
        this.sample_address = 32768;
    }
}

