/*
 * Decompiled with CFR 0.152.
 */
package com.youkaicountry.anyyes.audio;

import com.youkaicountry.anyyes.NES;
import com.youkaicountry.anyyes.audio.DeltaModulationChannel;
import com.youkaicountry.anyyes.audio.IAPUChannel;
import com.youkaicountry.anyyes.audio.IExpansionSoundChip;
import com.youkaicountry.anyyes.audio.NoiseWaveChannel;
import com.youkaicountry.anyyes.audio.SquareWaveChannel;
import com.youkaicountry.anyyes.audio.TriangleWaveChannel;
import com.youkaicountry.emucore.IMemRW;
import com.youkaicountry.util.serialize.ByteSerializer;
import com.youkaicountry.util.serialize.IByteSerialize;
import com.youkaicountry.util.serialize.SerializationInfo;
import java.io.IOException;
import java.util.ArrayList;

public class NESAPU
implements IMemRW,
IByteSerialize {
    private static final int DEFAULT_BUFFER_SIZE = 1024;
    private final NES nes;
    private final SquareWaveChannel pulseChannel1;
    private final SquareWaveChannel pulseChannel2;
    private final TriangleWaveChannel triangleChannel;
    private final NoiseWaveChannel noiseChannel;
    private final DeltaModulationChannel deltaChannel;
    private final IAPUChannel[] channel_map;
    private boolean has_expansion;
    private final ArrayList<IExpansionSoundChip> expansion_chips;
    private float[] sound_buffer;
    private int buffer_count;
    private boolean odd_cycle;
    private int cpu_cycle;
    private int apu_cycle;
    private int frame;
    private boolean four_step;
    private boolean irq_block;
    private boolean irq;
    private int stalled;
    private final int[] square_table;
    private final int[] tnd_table;
    public static final int[] LENGTH_LOOKUP = new int[]{10, 254, 20, 2, 40, 4, 80, 6, 160, 8, 60, 10, 14, 12, 26, 14, 12, 16, 24, 18, 48, 20, 96, 22, 192, 24, 72, 26, 16, 28, 32, 30};
    private int lpaccum = 0;
    private int dckiller = 0;
    private int sample_cycles = Integer.MAX_VALUE;
    private int buffer_size;

    public NESAPU(NES nes, boolean async) {
        this.nes = nes;
        this.pulseChannel1 = new SquareWaveChannel();
        this.pulseChannel2 = new SquareWaveChannel();
        this.triangleChannel = new TriangleWaveChannel();
        this.noiseChannel = new NoiseWaveChannel();
        this.deltaChannel = new DeltaModulationChannel(nes);
        this.channel_map = new IAPUChannel[]{this.pulseChannel1, this.pulseChannel2, this.triangleChannel, this.noiseChannel, this.deltaChannel};
        this.has_expansion = false;
        this.expansion_chips = new ArrayList();
        this.sound_buffer = new float[1];
        this.square_table = new int[31];
        this.tnd_table = new int[203];
        this.generateLookupTables();
    }

    public void addExpansionChip(IExpansionSoundChip chip) {
        this.expansion_chips.add(chip);
        this.has_expansion = true;
    }

    public void clearExpansionChips() {
        this.expansion_chips.clear();
        this.has_expansion = false;
    }

    public void setSampleRate(int speaker_hz) {
        this.sample_cycles = (int)(this.nes.cpu.getClockSpeed() / (float)speaker_hz);
        this.buffer_size = (int)(40.0f / (float)this.sample_cycles * 1024.0f);
        this.sound_buffer = new float[this.buffer_size];
        System.out.println(this.buffer_size);
    }

    public int getBufferSize() {
        return this.buffer_size;
    }

    @Override
    public int read(int address) {
        int outval = this.pulseChannel1.isLengthPositive() ? 1 : 0;
        outval |= (this.pulseChannel2.isLengthPositive() ? 1 : 0) << 1;
        outval |= (this.triangleChannel.isLengthPositive() ? 1 : 0) << 2;
        outval |= (this.noiseChannel.isLengthPositive() ? 1 : 0) << 3;
        outval |= (this.deltaChannel.isLengthPositive() ? 1 : 0) << 4;
        outval |= (this.irq ? 1 : 0) << 6;
        int n = this.deltaChannel.isIRQEnabled() ? 1 : 0;
        this.irq = false;
        this.nes.cpu.setIRQ(0, false);
        return outval |= n << 7;
    }

    @Override
    public void write(int address, int value) {
        if (address < 16405) {
            this.channel_map[address >> 2 & 0xF].write(address, value);
        } else if (address == 16405) {
            for (int i = 0; i < 5; ++i) {
                this.channel_map[i].setEnabled((value & 1) == 1);
                value >>= 1;
            }
        } else if (address == 16407) {
            this.irq_block = (value & 0x40) != 0;
            this.four_step = (value & 0x80) == 0;
            this.frame = 0;
            this.apu_cycle = 0;
            if (!this.four_step) {
                this.quarterTick();
                this.halfTick();
            }
            if (this.irq_block) {
                this.irq = false;
                this.nes.cpu.setIRQ(0, false);
            }
        }
    }

    public void cycle() {
        this.odd_cycle ^= true;
        ++this.cpu_cycle;
        if (this.odd_cycle) {
            ++this.apu_cycle;
            this.pulseChannel1.tick();
            this.pulseChannel2.tick();
            this.noiseChannel.tick();
        }
        this.triangleChannel.tick();
        this.deltaChannel.tick();
        if (this.has_expansion) {
            for (int i = 0; i < this.expansion_chips.size(); ++i) {
                this.expansion_chips.get(i).cycle(1);
            }
        }
        if (this.four_step && (this.cpu_cycle == 1 || this.cpu_cycle == 2) && !this.irq_block) {
            this.nes.cpu.setIRQ(0, true);
        }
        if (this.cpu_cycle % 7457 == 0) {
            this.frameStep();
        }
        this.handleOutputBuffer();
    }

    private void handleOutputBuffer() {
        if (this.buffer_count / this.sample_cycles >= this.sound_buffer.length) {
            this.buffer_count = 0;
            if (this.nes.hasSpeaker()) {
                this.sound_buffer = this.nes.speaker.playAudio(this.sound_buffer);
            }
        }
        if (this.buffer_count % this.sample_cycles == 0) {
            int square_out = this.square_table[this.pulseChannel1.getOutput() + this.pulseChannel2.getOutput()];
            int tnd_out = this.tnd_table[3 * this.triangleChannel.getOutput() + 2 * this.noiseChannel.getOutput() + this.deltaChannel.getOutput()];
            int data = square_out + tnd_out;
            data = this.lowpass_filter(this.highpass_filter(data));
            if (this.has_expansion) {
                data = (int)((double)data * 0.8);
                for (int i = 0; i < this.expansion_chips.size(); ++i) {
                    data += this.expansion_chips.get(i).getOutput();
                }
            }
            this.sound_buffer[this.buffer_count / this.sample_cycles] = (float)data / 49151.0f;
        }
        ++this.buffer_count;
    }

    private int highpass_filter(int sample) {
        this.dckiller -= (sample += this.dckiller) >> 8;
        this.dckiller += sample > 0 ? -1 : 1;
        return sample;
    }

    private int lowpass_filter(int sample) {
        this.lpaccum = (int)((double)this.lpaccum - (double)(sample += this.lpaccum) * 0.9);
        return this.lpaccum;
    }

    private void frameStep() {
        ++this.frame;
        if (this.four_step) {
            if (this.frame % 2 == 0) {
                this.halfTick();
            }
            this.quarterTick();
            if (this.frame == 4) {
                if (!this.irq_block) {
                    this.irq = true;
                    this.nes.cpu.setIRQ(0, true);
                }
                this.frame = 0;
                this.apu_cycle = 0;
                this.cpu_cycle = 0;
            }
        } else {
            switch (this.frame) {
                case 1: {
                    this.quarterTick();
                    break;
                }
                case 2: {
                    this.quarterTick();
                    this.halfTick();
                    break;
                }
                case 3: {
                    this.quarterTick();
                    break;
                }
                case 5: {
                    this.quarterTick();
                    this.halfTick();
                    this.frame = 0;
                    this.apu_cycle = 0;
                }
            }
        }
    }

    private void quarterTick() {
        this.pulseChannel1.quarterFrameTick();
        this.pulseChannel2.quarterFrameTick();
        this.triangleChannel.quarterFrameTick();
        this.noiseChannel.quarterFrameTick();
        if (this.has_expansion) {
            for (int i = 0; i < this.expansion_chips.size(); ++i) {
                this.expansion_chips.get(i).quarterFrame();
            }
        }
    }

    private void halfTick() {
        this.pulseChannel1.halfFrameTick();
        this.pulseChannel2.halfFrameTick();
        this.triangleChannel.halfFrameTick();
        this.noiseChannel.halfFrameTick();
        if (this.has_expansion) {
            for (int i = 0; i < this.expansion_chips.size(); ++i) {
                this.expansion_chips.get(i).halfFrame();
            }
        }
    }

    private void generateLookupTables() {
        int i;
        for (i = 1; i < 31; ++i) {
            this.square_table[i] = (int)(95.52 / (8128.0 / (double)i + 100.0) * 49151.0);
        }
        for (i = 1; i < 203; ++i) {
            this.tnd_table[i] = (int)(163.67 / (24329.0 / (double)i + 100.0) * 49151.0);
        }
    }

    @Override
    public void serialization(SerializationInfo info) throws IOException {
        this.stalled = ByteSerializer.serializationInt(info, this.stalled);
        this.odd_cycle = ByteSerializer.serializationBoolean(info, this.odd_cycle);
        this.cpu_cycle = ByteSerializer.serializationInt(info, this.cpu_cycle);
        this.apu_cycle = ByteSerializer.serializationInt(info, this.apu_cycle);
        this.frame = ByteSerializer.serializationInt(info, this.frame);
        this.four_step = ByteSerializer.serializationBoolean(info, this.four_step);
        this.irq_block = ByteSerializer.serializationBoolean(info, this.irq_block);
        this.irq = ByteSerializer.serializationBoolean(info, this.irq);
        this.pulseChannel1.serialization(info);
        this.pulseChannel2.serialization(info);
        this.triangleChannel.serialization(info);
        this.noiseChannel.serialization(info);
        this.deltaChannel.serialization(info);
        if (!info.serializing) {
            this.buffer_count = 0;
        }
    }

    public void reset() {
        this.stalled = 0;
        this.odd_cycle = false;
        this.cpu_cycle = 0;
        this.apu_cycle = 0;
        this.frame = 0;
        this.four_step = false;
        this.irq_block = false;
        this.irq = false;
        this.pulseChannel1.reset();
        this.pulseChannel2.reset();
        this.triangleChannel.reset();
        this.noiseChannel.reset();
        this.deltaChannel.reset();
        this.buffer_count = 0;
    }
}

