/*
 * Decompiled with CFR 0.152.
 */
package com.youkaicountry.anyyes.audio;

import com.youkaicountry.anyyes.audio.ChannelEnvelope;
import com.youkaicountry.anyyes.audio.IAPUChannel;
import com.youkaicountry.anyyes.audio.NESAPU;
import com.youkaicountry.util.serialize.ByteSerializer;
import com.youkaicountry.util.serialize.IByteSerialize;
import com.youkaicountry.util.serialize.SerializationInfo;
import java.io.IOException;

public class NoiseWaveChannel
implements IAPUChannel,
IByteSerialize {
    private boolean enabled;
    private boolean length_halt;
    private boolean mode;
    private int timer;
    private int timer_load;
    private int length_counter;
    private int shift_register;
    private boolean constant_vol;
    private int output_vol;
    private final ChannelEnvelope envelope;
    private final int[] timerTable = new int[]{4, 8, 16, 32, 64, 96, 128, 160, 202, 254, 380, 508, 762, 1016, 2034, 4068};

    public NoiseWaveChannel() {
        this.envelope = new ChannelEnvelope();
    }

    @Override
    public void tick() {
        if (this.timer > 0) {
            --this.timer;
        } else {
            this.timer = this.timer_load;
            int feedback = this.shift_register & 1 ^ (this.mode ? this.shift_register >> 6 & 1 : this.shift_register >> 1 & 1);
            this.shift_register >>= 1;
            this.shift_register |= feedback << 14;
        }
        this.output_vol = (this.shift_register & 1) != 0 || this.length_counter == 0 ? 0 : (this.constant_vol ? this.envelope.volume : this.envelope.output);
    }

    @Override
    public final void halfFrameTick() {
        this.lengthTick();
    }

    private final void lengthTick() {
        if (this.length_counter > 0 && !this.length_halt) {
            --this.length_counter;
        }
    }

    @Override
    public final void quarterFrameTick() {
        this.envelope.envelopeTick();
    }

    @Override
    public void write(int address, int value) {
        int registerNum = address & 3;
        switch (registerNum) {
            case 0: {
                this.envelope.volume = value & 0xF;
                this.constant_vol = (value & 0x10) == 16;
                this.length_halt = (value & 0x20) == 32;
                break;
            }
            case 2: {
                this.mode = (value & 0x80) == 128;
                this.timer_load = this.timerTable[value & 0xF];
                break;
            }
            case 3: {
                this.envelope.start = true;
                if (!this.enabled) break;
                int lengthLoad = value >> 3 & 0x1F;
                this.length_counter = NESAPU.LENGTH_LOOKUP[lengthLoad];
            }
        }
    }

    @Override
    public final void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (!enabled) {
            this.length_counter = 0;
        }
    }

    @Override
    public final int getOutput() {
        return this.output_vol;
    }

    @Override
    public final boolean isLengthPositive() {
        return this.length_counter > 0;
    }

    @Override
    public void serialization(SerializationInfo info) throws IOException {
        this.enabled = ByteSerializer.serializationBoolean(info, this.enabled);
        this.length_halt = ByteSerializer.serializationBoolean(info, this.length_halt);
        this.mode = ByteSerializer.serializationBoolean(info, this.mode);
        this.timer = ByteSerializer.serializationInt(info, this.timer);
        this.timer_load = ByteSerializer.serializationInt(info, this.timer_load);
        this.length_counter = ByteSerializer.serializationInt(info, this.length_counter);
        this.shift_register = ByteSerializer.serializationInt(info, this.shift_register);
        this.constant_vol = ByteSerializer.serializationBoolean(info, this.constant_vol);
        this.output_vol = ByteSerializer.serializationInt(info, this.output_vol);
        this.envelope.serialization(info);
    }

    public void reset() {
        this.enabled = false;
        this.length_halt = false;
        this.mode = false;
        this.timer = 0;
        this.timer_load = 0;
        this.length_counter = 0;
        this.shift_register = 1;
        this.constant_vol = false;
        this.output_vol = 0;
        this.envelope.reset();
    }
}

