/*
 * Decompiled with CFR 0.152.
 */
package com.youkaicountry.anyyes.audio;

import com.youkaicountry.anyyes.audio.ChannelEnvelope;
import com.youkaicountry.anyyes.audio.IAPUChannel;
import com.youkaicountry.anyyes.audio.NESAPU;
import com.youkaicountry.util.serialize.ByteSerializer;
import com.youkaicountry.util.serialize.IByteSerialize;
import com.youkaicountry.util.serialize.SerializationInfo;
import java.io.IOException;

public class SquareWaveChannel
implements IAPUChannel,
IByteSerialize {
    private boolean enabled;
    private int duty;
    private boolean constant_vol;
    private int timer;
    private int timer_load;
    private int length_counter;
    private int sequencer_pointer;
    private int output_vol;
    private final ChannelEnvelope envelope;
    private boolean sweep_enable;
    private int sweep_divider_period;
    private boolean sweep_negate;
    private int sweep_shift_count;
    private boolean sweep_reload;
    private int sweep_divider_counter;
    private final boolean[][] squareDutyLookup = new boolean[][]{{false, true, false, false, false, false, false, false}, {false, true, true, false, false, false, false, false}, {false, true, true, true, true, false, false, false}, {true, false, false, true, true, true, true, true}};

    public SquareWaveChannel() {
        this.envelope = new ChannelEnvelope();
    }

    @Override
    public void tick() {
        if (this.timer > 0) {
            --this.timer;
        } else {
            this.timer = this.timer_load;
            this.sequencer_pointer = this.sequencer_pointer + 1 & 7;
        }
        this.output_vol = this.constant_vol ? this.envelope.volume : this.envelope.output;
        if (this.sweepForcingSilence()) {
            this.output_vol = 0;
        }
        if (!this.squareDutyLookup[this.duty][this.sequencer_pointer]) {
            this.output_vol = 0;
        }
        if (this.length_counter == 0) {
            this.output_vol = 0;
        }
    }

    @Override
    public final void halfFrameTick() {
        this.lengthTick();
        this.sweepTick();
    }

    @Override
    public final void quarterFrameTick() {
        this.envelope.envelopeTick();
    }

    private void sweepTick() {
        if (this.sweep_reload) {
            if (this.sweep_divider_counter == 0 && this.sweep_enable) {
                this.adjustTimer(this.sweep_shift_count);
            }
            this.sweep_divider_counter = this.sweep_divider_period;
            this.sweep_reload = false;
        } else if (this.sweep_divider_counter > 0) {
            --this.sweep_divider_counter;
        } else {
            this.sweep_divider_counter = this.sweep_divider_period;
            if (this.sweep_enable) {
                this.adjustTimer(this.sweep_shift_count);
            }
        }
    }

    private void adjustTimer(int amount) {
        int tempAdder = this.timer_load >> amount;
        if (this.sweep_negate) {
            tempAdder = -(tempAdder + 1);
        }
        int targetPeriod = this.timer_load + tempAdder;
        targetPeriod &= 0x7FF;
        if (this.sweep_enable && !this.sweepForcingSilence()) {
            this.timer_load = targetPeriod;
        }
    }

    private boolean sweepForcingSilence() {
        boolean out_val = this.timer_load < 8 ? true : !this.sweep_negate && this.timer_load + (this.timer_load >> this.sweep_shift_count) > 2047;
        return out_val;
    }

    private void lengthTick() {
        if (this.length_counter > 0 && !this.envelope.length_halt) {
            --this.length_counter;
        }
    }

    @Override
    public void write(int address, int value) {
        int register = address & 3;
        switch (register) {
            case 0: {
                this.envelope.volume = value & 0xF;
                this.constant_vol = (value & 0x10) == 16;
                this.envelope.length_halt = (value & 0x20) == 32;
                this.duty = value >> 6 & 3;
                break;
            }
            case 1: {
                this.sweep_shift_count = value & 7;
                this.sweep_negate = (value & 8) == 8;
                this.sweep_divider_period = value >> 4 & 7;
                this.sweep_enable = (value & 0x80) == 128 && this.sweep_shift_count != 0;
                this.sweep_reload = true;
                break;
            }
            case 2: {
                this.timer_load &= 0x700;
                this.timer_load |= value;
                break;
            }
            case 3: {
                this.timer_load &= 0xFF;
                this.timer_load |= (value & 7) << 8;
                int lengthLoad = value >> 3 & 0x1F;
                if (this.enabled) {
                    this.length_counter = NESAPU.LENGTH_LOOKUP[lengthLoad];
                }
                this.sequencer_pointer = 0;
                this.timer = this.timer_load;
                this.envelope.start = true;
            }
        }
    }

    @Override
    public final void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (!enabled) {
            this.length_counter = 0;
        }
    }

    @Override
    public final int getOutput() {
        return this.output_vol;
    }

    @Override
    public final boolean isLengthPositive() {
        return this.length_counter > 0;
    }

    @Override
    public void serialization(SerializationInfo info) throws IOException {
        this.enabled = ByteSerializer.serializationBoolean(info, this.enabled);
        this.duty = ByteSerializer.serializationInt(info, this.duty);
        this.constant_vol = ByteSerializer.serializationBoolean(info, this.constant_vol);
        this.timer = ByteSerializer.serializationInt(info, this.timer);
        this.timer_load = ByteSerializer.serializationInt(info, this.timer_load);
        this.length_counter = ByteSerializer.serializationInt(info, this.length_counter);
        this.sequencer_pointer = ByteSerializer.serializationInt(info, this.sequencer_pointer);
        this.output_vol = ByteSerializer.serializationInt(info, this.output_vol);
        this.sweep_enable = ByteSerializer.serializationBoolean(info, this.sweep_enable);
        this.sweep_divider_period = ByteSerializer.serializationInt(info, this.sweep_divider_period);
        this.sweep_negate = ByteSerializer.serializationBoolean(info, this.sweep_negate);
        this.sweep_shift_count = ByteSerializer.serializationInt(info, this.sweep_shift_count);
        this.sweep_reload = ByteSerializer.serializationBoolean(info, this.sweep_reload);
        this.sweep_divider_counter = ByteSerializer.serializationInt(info, this.sweep_divider_counter);
        this.envelope.serialization(info);
    }

    public void reset() {
        this.enabled = false;
        this.duty = 0;
        this.constant_vol = false;
        this.timer = 0;
        this.timer_load = 0;
        this.length_counter = 0;
        this.sequencer_pointer = 0;
        this.output_vol = 0;
        this.sweep_enable = false;
        this.sweep_divider_period = 0;
        this.sweep_negate = false;
        this.sweep_shift_count = 0;
        this.sweep_reload = false;
        this.sweep_divider_counter = 0;
        this.envelope.reset();
    }
}

