/*
 * Decompiled with CFR 0.152.
 */
package com.youkaicountry.anyyes.audio;

import com.youkaicountry.anyyes.audio.IAPUChannel;
import com.youkaicountry.anyyes.audio.NESAPU;
import com.youkaicountry.util.serialize.ByteSerializer;
import com.youkaicountry.util.serialize.IByteSerialize;
import com.youkaicountry.util.serialize.SerializationInfo;
import java.io.IOException;

public class TriangleWaveChannel
implements IAPUChannel,
IByteSerialize {
    private boolean enabled;
    private boolean linear_count_ctrl;
    private int linear_counter_reload;
    private int timer_load;
    private int length_count;
    private int linear_counter;
    private boolean linear_count_reload;
    private int output;
    private int timer;
    private int sequencer_pointer;
    private boolean trianglePopHack = true;
    private final int[] sequenceTable = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0};

    @Override
    public void tick() {
        boolean ultrasonic = false;
        if (this.timer_load < 2 && this.timer < 2) {
            ultrasonic = true;
        }
        if (this.timer > 0) {
            --this.timer;
        } else {
            this.timer = this.timer_load;
            if (!(this.linear_counter == 0 || this.length_count == 0 || this.trianglePopHack && ultrasonic)) {
                this.sequencer_pointer = this.sequencer_pointer + 1 & 0x1F;
            }
        }
        this.output = this.trianglePopHack || !ultrasonic ? this.sequenceTable[this.sequencer_pointer] : 0;
    }

    @Override
    public void halfFrameTick() {
        this.lengthTick();
    }

    private void lengthTick() {
        if (this.length_count > 0 && !this.linear_count_ctrl) {
            --this.length_count;
        }
    }

    @Override
    public void quarterFrameTick() {
        this.tickLinearCounter();
    }

    private void tickLinearCounter() {
        if (this.linear_count_reload) {
            this.linear_counter = this.linear_counter_reload;
        } else if (this.linear_counter != 0) {
            --this.linear_counter;
        }
        if (!this.linear_count_ctrl) {
            this.linear_count_reload = false;
        }
    }

    @Override
    public void write(int address, int value) {
        int registerNum = address & 3;
        switch (registerNum) {
            case 0: {
                this.linear_counter_reload = value & 0x7F;
                this.linear_count_ctrl = (value & 0x80) == 128;
                break;
            }
            case 2: {
                this.timer_load = this.timer_load & 0x700 | value & 0xFF;
                break;
            }
            case 3: {
                this.timer_load = this.timer_load & 0xFF | (value & 7) << 8;
                if (this.enabled) {
                    int lengthLoad = value >> 3 & 0x1F;
                    this.length_count = NESAPU.LENGTH_LOOKUP[lengthLoad];
                }
                this.linear_count_reload = true;
            }
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (!enabled) {
            this.length_count = 0;
        }
    }

    @Override
    public int getOutput() {
        return this.output;
    }

    @Override
    public boolean isLengthPositive() {
        return this.length_count > 0;
    }

    @Override
    public void serialization(SerializationInfo info) throws IOException {
        this.enabled = ByteSerializer.serializationBoolean(info, this.enabled);
        this.linear_count_ctrl = ByteSerializer.serializationBoolean(info, this.linear_count_ctrl);
        this.linear_counter_reload = ByteSerializer.serializationInt(info, this.linear_counter_reload);
        this.timer_load = ByteSerializer.serializationInt(info, this.timer_load);
        this.length_count = ByteSerializer.serializationInt(info, this.length_count);
        this.linear_counter = ByteSerializer.serializationInt(info, this.linear_counter);
        this.linear_count_reload = ByteSerializer.serializationBoolean(info, this.linear_count_reload);
        this.output = ByteSerializer.serializationInt(info, this.output);
        this.timer = ByteSerializer.serializationInt(info, this.timer);
        this.sequencer_pointer = ByteSerializer.serializationInt(info, this.sequencer_pointer);
    }

    public void reset() {
        this.enabled = false;
        this.linear_count_ctrl = false;
        this.linear_count_reload = false;
        this.timer_load = 0;
        this.length_count = 0;
        this.linear_counter = 0;
        this.linear_count_reload = false;
        this.output = 0;
        this.timer = 0;
        this.sequencer_pointer = 0;
    }
}

