/*
 * Decompiled with CFR 0.152.
 */
package com.youkaicountry.anyyes.audio.chips;

import com.youkaicountry.anyyes.NESRegion;
import com.youkaicountry.anyyes.audio.APUChannel;
import com.youkaicountry.anyyes.audio.chips.Namco163SoundChip;
import com.youkaicountry.util.BitUtil;

public class Namco163SoundChannel
extends APUChannel {
    private final Namco163SoundChip soundChip;
    private int linearVolume = 0;
    private int output = 0;
    private int step = 0;
    private int waveformAddress = 0;
    private int waveformLength = 256;
    private int[] waveformBuffer = new int[256];
    public boolean enabled = false;
    private boolean freeze = true;

    public Namco163SoundChannel(NESRegion.System system, Namco163SoundChip soundChip) {
        super(system);
        this.soundChip = soundChip;
    }

    @Override
    public void hardReset() {
        super.hardReset();
        this.linearVolume = 0;
        this.output = 0;
        this.step = 0;
        this.waveformAddress = 0;
        this.waveformLength = 256;
        this.waveformBuffer = new int[256];
        this.enabled = false;
        this.freeze = true;
    }

    protected void lowFrequency(int data) {
        this.frequency = this.frequency & 0x3FF00 | data;
        this.updateFrequency();
    }

    protected void midFrequency(int data) {
        this.frequency = this.frequency & 0x300FF | data << 8;
        this.updateFrequency();
    }

    protected void highFrequency(int data) {
        this.frequency = this.frequency & 0xFFFF | (data & 3) << 16;
        this.updateFrequency();
        this.waveformLength = 64 - (data >> 2 & 0x3F) << 2;
        this.setupWaveformBuffer();
    }

    protected void waveAddress(int data) {
        this.waveformAddress = data;
        this.setupWaveformBuffer();
    }

    protected void setVolume(int data) {
        this.linearVolume = data & 0xF;
    }

    @Override
    public void cycle() {
        if (this.freeze) {
            return;
        }
        if (this.waveformBuffer.length <= this.waveformLength) {
            this.step = this.step + 1 & this.waveformLength - 1;
            this.output = this.waveformBuffer[this.step] * this.linearVolume & 0xFF;
        }
    }

    public int getOutput() {
        if (this.enabled) {
            return this.output;
        }
        return 0;
    }

    private void updateFrequency() {
        boolean bl = this.freeze = this.frequency == 0;
        if (this.frequency > 0) {
            this.region.singleCycle = this.system.cpu * (983040 / this.frequency);
        }
    }

    private void setupWaveformBuffer() {
        this.waveformBuffer = new int[this.waveformLength];
        int raddress = this.waveformAddress >> 1;
        int sampleAddress = 0;
        boolean highLow = BitUtil.getBit(this.waveformAddress, 0);
        while (sampleAddress < this.waveformLength) {
            int sample = highLow ? (this.soundChip.exram[raddress] & 0xF0) >> 4 : this.soundChip.exram[raddress] & 0xF;
            this.waveformBuffer[sampleAddress] = sample & 0xFF;
            if (highLow) {
                raddress = raddress + 1 & 0x7F;
            }
            ++sampleAddress;
            highLow ^= true;
        }
        this.step = 0;
    }
}

