/*
 * Decompiled with CFR 0.152.
 */
package com.youkaicountry.anyyes.audio.chips;

import com.youkaicountry.anyyes.NESRegion;
import com.youkaicountry.anyyes.audio.IExpansionSoundChip;
import com.youkaicountry.anyyes.audio.chips.Namco163SoundChannel;
import com.youkaicountry.util.BitUtil;

public class Namco163SoundChip
implements IExpansionSoundChip {
    private final Namco163SoundChannel[] channels;
    public int[] exram = new int[128];
    private int lpaccum = 0;
    private int channelIndex = 0;
    public int enabledChannels = 0;
    private int soundRegister = 0;

    public Namco163SoundChip(NESRegion.System system) {
        this.channels = new Namco163SoundChannel[8];
        this.exram = new int[128];
        for (int i = 0; i < 8; ++i) {
            this.channels[i] = new Namco163SoundChannel(system, this);
        }
    }

    public int readData(int address) {
        int value = this.exram[this.soundRegister & 0x7F];
        if (BitUtil.getBit(this.soundRegister, 7)) {
            this.soundRegister = (this.soundRegister + 1 & 0x7F | 0x80) & 0xFF;
        }
        return value;
    }

    public void writeData(int register, int data) {
        boolean write = true;
        int address = this.soundRegister & 0x7F;
        if (address >= 64) {
            int channel = address / 8 - 8;
            if (this.channels[channel].enabled) {
                switch (address % 8) {
                    case 0: {
                        this.channels[channel].lowFrequency(data);
                        break;
                    }
                    case 2: {
                        this.channels[channel].midFrequency(data);
                        break;
                    }
                    case 4: {
                        this.channels[channel].highFrequency(data);
                        break;
                    }
                    case 6: {
                        this.channels[channel].waveAddress(data);
                        break;
                    }
                    case 7: {
                        this.channels[channel].setVolume(data);
                    }
                }
            }
        }
        if (address == 127) {
            this.enableChannels(data);
        }
        if (write) {
            this.exram[this.soundRegister & 0x7F] = data;
            if (BitUtil.getBit(this.soundRegister, 7)) {
                this.soundRegister = (this.soundRegister + 1 & 0x7F | 0x80) & 0xFF;
            }
        }
    }

    public void writeRegister(int data) {
        this.soundRegister = data;
    }

    private void enableChannels(int data) {
        this.enabledChannels = (data & 0x70) >> 4;
        this.channelIndex = 0;
        int enabledTemp = this.enabledChannels + 1;
        for (int i = 7; i >= 0 && enabledTemp > 0; --enabledTemp, --i) {
            this.channels[i].enabled = true;
        }
    }

    @Override
    public int getOutput() {
        int output = 0;
        int enabledTemp = this.enabledChannels + 1;
        for (int i = 7; i >= 0 && enabledTemp > 0; --i) {
            --enabledTemp;
            output += this.channels[i].getOutput();
        }
        this.lpaccum = (int)((double)this.lpaccum - (double)(output += this.lpaccum) * 0.0625);
        return (this.lpaccum << 2) * 32;
    }

    @Override
    public void hardReset() {
        for (int i = 0; i < 8; ++i) {
            this.channels[i].hardReset();
        }
        this.exram = new int[128];
        this.channelIndex = 0;
        this.enabledChannels = 0;
        this.soundRegister = 0;
    }

    @Override
    public void softReset() {
        for (int i = 0; i < 8; ++i) {
            this.channels[i].softReset();
        }
        this.exram = new int[128];
        this.channelIndex = 0;
        this.enabledChannels = 0;
        this.soundRegister = 0;
    }

    @Override
    public void quarterFrame() {
    }

    @Override
    public void halfFrame() {
    }

    @Override
    public void clockChannel(boolean clockingLength) {
    }

    @Override
    public void cycle(int cycles) {
        cycles = 264;
        this.channelIndex = this.channelIndex + 1 & this.enabledChannels;
        this.channels[7 - this.channelIndex].cycle(cycles);
    }
}

