/*
 * Decompiled with CFR 0.152.
 */
package com.youkaicountry.anyyes.cartridges;

import com.youkaicountry.anyyes.NES;
import com.youkaicountry.anyyes.cartridges.NESROMFile;
import com.youkaicountry.anyyes.cartridges.mappers.MapperFactory;
import com.youkaicountry.anyyes.cartridges.mappers.NESMapper;
import com.youkaicountry.emucore.IMemRW;
import com.youkaicountry.util.serialize.ByteSerializer;
import com.youkaicountry.util.serialize.IByteSerialize;
import com.youkaicountry.util.serialize.SerializationInfo;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipInputStream;

public abstract class NESCartridge
implements IMemRW,
IByteSerialize {
    public int mapper_number;
    public final NESMapper mapper;
    public int prg_rom_chunk_size;
    public int chr_rom_chunk_size;
    public int prg_ram_chunk_size;
    public final byte[] trainer;
    public final byte[] prg_rom;
    public byte[] chr_rom;
    private byte[] sram;
    public boolean battery = false;
    private boolean sram_dirty;
    private int mirroring = -1;
    public NES nes;

    public NESCartridge(InputStream stream) throws IOException {
        NESROMFile rom_file = new NESROMFile(stream);
        this.trainer = rom_file.trainer;
        this.prg_rom = rom_file.prg_rom;
        this.init(rom_file, null);
        this.mapper = MapperFactory.getMapper(this);
    }

    public NESCartridge(ZipInputStream stream) throws IOException {
        NESROMFile rom_file = new NESROMFile(stream);
        this.trainer = rom_file.trainer;
        this.prg_rom = rom_file.prg_rom;
        this.init(rom_file, null);
        this.mapper = MapperFactory.getMapper(this);
    }

    public NESCartridge(InputStream rom, InputStream sram) throws IOException {
        NESROMFile rom_file = new NESROMFile(rom);
        this.trainer = rom_file.trainer;
        this.prg_rom = rom_file.prg_rom;
        byte[] sram_data = new byte[8192];
        try {
            sram.read(sram_data);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.init(rom_file, sram_data);
        this.mapper = MapperFactory.getMapper(this);
    }

    public NESCartridge(ZipInputStream rom, InputStream sram) throws IOException {
        NESROMFile rom_file = new NESROMFile(rom);
        this.trainer = rom_file.trainer;
        this.prg_rom = rom_file.prg_rom;
        byte[] sram_data = new byte[8192];
        try {
            sram.read(sram_data);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.init(rom_file, sram_data);
        this.mapper = MapperFactory.getMapper(this);
    }

    public NESMapper getMapper() {
        return this.mapper;
    }

    private final void init(NESROMFile rom_file, byte[] sram) {
        this.mapper_number = rom_file.mapper;
        System.out.println("MAPPER: " + this.mapper_number);
        this.prg_rom_chunk_size = rom_file.prg_rom_chunk_size;
        System.out.println("PRG: " + this.prg_rom_chunk_size * 16 + "kb");
        this.chr_rom_chunk_size = rom_file.chr_rom_chunk_size;
        System.out.println("CHR: " + this.chr_rom_chunk_size * 8 + "kb");
        this.prg_ram_chunk_size = rom_file.prg_ram_chunk_size;
        System.out.println("ARR: " + this.prg_rom.length);
        System.out.println("TV System: " + (rom_file.getFlag(9, 0) != 0 ? "PAL" : "NTSC"));
        if (rom_file.hasTrainer()) {
            System.out.println("TRAINER PRESENT");
        }
        if (sram == null) {
            this.sram = new byte[8192];
            if (rom_file.hasTrainer()) {
                for (int i = 0; i < rom_file.trainer.length; ++i) {
                    this.sram[4096 + i] = rom_file.trainer[i];
                }
            }
        } else {
            this.sram = sram;
        }
        boolean bl = this.battery = rom_file.getFlag(6, 1) != 0;
        if (this.battery) {
            System.out.println("HAS BATTERY");
        }
        if (rom_file.getFlag(6, 3) != 0) {
            System.out.println("FSCREEN");
            this.mirroring = 4;
        } else {
            int n = this.mirroring = rom_file.getFlag(6, 0) != 0 ? 0 : 1;
        }
        if (this.chr_rom_chunk_size != 0) {
            this.chr_rom = rom_file.chr_rom;
        }
        System.out.println("MIRRORING " + this.mirroring);
    }

    public void initCHR(int chunks) {
        this.chr_rom = new byte[8192 * chunks];
    }

    @Override
    public abstract int read(int var1);

    @Override
    public abstract void write(int var1, int var2);

    public void writeToSRAM(int address, int value) {
        this.sram[address - 24576] = (byte)value;
        this.sram_dirty = true;
    }

    public boolean isSRAMDirty() {
        return this.sram_dirty;
    }

    public byte[] getSRAM() {
        this.sram_dirty = false;
        return this.sram;
    }

    public int readFromSRAM(int address) {
        return this.sram[address - 24576] & 0xFF;
    }

    public void setNES(NES nes) {
        this.nes = nes;
        this.mapper.ppu = nes == null ? null : nes.ppu;
    }

    public int getWiredMirroring() {
        return this.mirroring;
    }

    @Override
    public void serialization(SerializationInfo info) throws IOException {
        ByteSerializer.serializationByteArray(info, this.sram);
    }
}

