/*
 * Decompiled with CFR 0.152.
 */
package com.youkaicountry.anyyes.cartridges;

import com.youkaicountry.anyyes.cartridges.NESCartridge;
import com.youkaicountry.anyyes.cartridges.mappers.NESMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipInputStream;

public class NESGenieCartridge
extends NESCartridge {
    NESCartridge cartridge;
    boolean game_mode;
    boolean game_mode_latch;
    int[] mod_addresses;
    int[] replace;
    boolean[] do_compare;
    int[] compare;
    NESMapper use_mapper;

    public NESGenieCartridge(InputStream stream) throws IOException {
        super(stream);
        this.genieInit();
    }

    public NESGenieCartridge(ZipInputStream stream) throws IOException {
        super(stream);
        this.genieInit();
    }

    public NESGenieCartridge(InputStream rom, InputStream sram) throws IOException {
        super(rom, sram);
        this.genieInit();
    }

    public NESGenieCartridge(ZipInputStream rom, InputStream sram) throws IOException {
        super(rom, sram);
        this.genieInit();
    }

    private void genieInit() {
        this.use_mapper = this.mapper;
        this.mod_addresses = new int[3];
        this.replace = new int[3];
        this.do_compare = new boolean[3];
        this.compare = new int[3];
    }

    public void insertCartridge(NESCartridge cartridge) {
        this.cartridge = cartridge;
    }

    @Override
    public final int read(int address) {
        if ((address & 0x8000) != 0 && this.game_mode) {
            int r = -1;
            for (int i = 0; i < 3; ++i) {
                if (address != this.mod_addresses[i]) continue;
                int value = this.use_mapper.read(address);
                if (!this.do_compare[i] || value == this.compare[i]) {
                    return this.replace[i];
                }
                return value;
            }
        }
        return this.use_mapper.read(address);
    }

    @Override
    public final void write(int address, int value) {
        if (!this.game_mode) {
            switch (address) {
                case 32768: {
                    boolean enable;
                    boolean bl = enable = (value & 1) != 0;
                    if (this.game_mode_latch && !enable) {
                        this.enableGameMode();
                    }
                    this.game_mode_latch = enable;
                    break;
                }
                case 32769: {
                    this.mod_addresses[0] = 0x8000 | (0x7F & value) << 8 | this.mod_addresses[0];
                    break;
                }
                case 32773: {
                    this.mod_addresses[1] = 0x8000 | (0x7F & value) << 8 | this.mod_addresses[1];
                    break;
                }
                case 32777: {
                    this.mod_addresses[2] = 0x8000 | (0x7F & value) << 8 | this.mod_addresses[2];
                    break;
                }
                case 32770: {
                    this.mod_addresses[0] = value | this.mod_addresses[0];
                    break;
                }
                case 32774: {
                    this.mod_addresses[1] = value | this.mod_addresses[1];
                    break;
                }
                case 32778: {
                    this.mod_addresses[2] = value | this.mod_addresses[2];
                    break;
                }
                case 32771: {
                    this.compare[0] = value;
                    this.do_compare[0] = value != 0;
                    break;
                }
                case 32775: {
                    this.compare[1] = value;
                    this.do_compare[1] = value != 0;
                    break;
                }
                case 32779: {
                    this.compare[2] = value;
                    this.do_compare[2] = value != 0;
                    break;
                }
                case 32772: {
                    this.replace[0] = value;
                    break;
                }
                case 32776: {
                    this.replace[1] = value;
                    break;
                }
                case 32780: {
                    this.replace[2] = value;
                }
            }
            return;
        }
        this.use_mapper.write(address, value);
    }

    private void enableGameMode() {
        if (this.cartridge != null) {
            this.use_mapper = this.cartridge.getMapper();
            this.nes.ppu.changeMapper(this.use_mapper);
            this.cartridge.mapper.ppu = this.nes.ppu;
            this.cartridge.nes = this.nes;
            this.game_mode = true;
        }
    }

    @Override
    public final NESMapper getMapper() {
        return this.use_mapper;
    }
}

