/*
 * Decompiled with CFR 0.152.
 */
package com.youkaicountry.anyyes.cartridges;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class NESROMFile {
    int prg_rom_chunk_size;
    int chr_rom_chunk_size;
    int prg_ram_chunk_size;
    int[] flags;
    int mapper;
    public byte[] trainer;
    public byte[] prg_rom;
    public byte[] chr_rom;
    boolean corrupt_header;
    boolean dd_header;

    public NESROMFile(InputStream data) throws IOException {
        this.parseiNES(data);
    }

    public NESROMFile(ZipInputStream data) throws IOException {
        ZipEntry ent;
        while ((ent = data.getNextEntry()) != null) {
            if (ent.isDirectory()) continue;
            String name = ent.getName().toLowerCase();
            String[] namebits = (name = name.substring(name.lastIndexOf("/") + 1)).split("\\.");
            if (!namebits[1].equals("nes")) continue;
            this.parseiNES(data);
        }
    }

    private void parseiNES(InputStream data) throws IOException {
        this.parseHeader(data);
        this.parseTrainer(data);
        this.parseProgramROM(data);
        this.parseCharacterROM(data);
    }

    private void parseHeader(InputStream data) throws IOException {
        byte[] header = new byte[16];
        this.readAll(data, header);
        String s = new String(Arrays.copyOfRange(header, 0, 4));
        String match_string = "NES\u001a";
        if (!s.equals(match_string)) {
            this.corrupt_header = true;
        }
        String dd = new String(Arrays.copyOfRange(header, 7, 16));
        System.out.println(dd);
        if (dd.equals("DiskDude!")) {
            this.dd_header = true;
        }
        this.prg_rom_chunk_size = header[4] & 0xFF;
        this.chr_rom_chunk_size = header[5] & 0xFF;
        this.prg_ram_chunk_size = header[8] & 0xFF;
        this.flags = new int[4];
        this.flags[0] = header[6] & 0xFF;
        this.flags[1] = header[7] & 0xFF;
        this.flags[2] = header[9] & 0xFF;
        this.flags[3] = header[10] & 0xFF;
        this.mapper = this.flags[0] >> 4 | this.flags[1] & 0xF0;
        if (this.dd_header) {
            this.mapper -= 64;
        }
    }

    public int getFlag(int batch_num, int flag) {
        int batch = this.getFlagBatch(batch_num);
        return this.getFlagFromBatch(batch, flag);
    }

    private int getFlagFromBatch(int batch, int flag) {
        int val = batch >> flag & 1;
        return val;
    }

    public int getFlagBatch(int batch_num) {
        int index = batch_num - 6;
        if (batch_num >= 9) {
            --index;
        }
        return this.flags[index];
    }

    private String printFlag(int batch) {
        StringBuilder sb = new StringBuilder();
        for (int i = 7; i >= 0; --i) {
            sb.append(this.getFlag(batch, i));
        }
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.prg_rom_chunk_size * 16);
        sb.append("k PRG / ");
        sb.append(this.chr_rom_chunk_size * 8);
        sb.append("k CHR F:");
        sb.append(this.printFlag(6));
        sb.append(" ");
        sb.append(this.printFlag(7));
        sb.append(" ");
        sb.append(this.printFlag(9));
        sb.append(" ");
        sb.append(this.printFlag(10));
        sb.append(" M:");
        sb.append(this.mapper);
        return sb.toString();
    }

    public boolean hasTrainer() {
        return this.getFlag(6, 2) == 1;
    }

    public void parseTrainer(InputStream data) throws IOException {
        if (!this.hasTrainer()) {
            this.trainer = null;
            return;
        }
        this.trainer = new byte[512];
        this.readAll(data, this.trainer);
    }

    public void parseProgramROM(InputStream data) throws IOException {
        int pbytes = 16384 * this.prg_rom_chunk_size;
        this.prg_rom = new byte[pbytes];
        this.readAll(data, this.prg_rom);
    }

    public void parseCharacterROM(InputStream data) throws IOException {
        int cbytes = 8192 * this.chr_rom_chunk_size;
        this.chr_rom = new byte[cbytes];
        this.readAll(data, this.chr_rom);
    }

    private void readAll(InputStream data, byte[] buffer) throws IOException {
        for (int loc = 0; loc < buffer.length; loc += data.read(buffer, loc, buffer.length - loc)) {
        }
    }
}

