/*
 * Decompiled with CFR 0.152.
 */
package com.youkaicountry.anyyes.cartridges.mappers;

import com.youkaicountry.anyyes.cartridges.NESCartridge;
import com.youkaicountry.anyyes.cartridges.mappers.NESMapper;
import com.youkaicountry.util.serialize.ByteSerializer;
import com.youkaicountry.util.serialize.SerializationInfo;
import java.io.IOException;

public class Mapper1
extends NESMapper {
    private int temp_reg;
    private final int[] regs = new int[4];
    private int writes;
    private final boolean surom;
    private int ticks_since_write = 999;

    public Mapper1(NESCartridge cartridge) {
        super(cartridge, 1, true, true, false);
        this.regs[0] = 12;
        if (this.cartridge.prg_rom_chunk_size >= 32) {
            this.surom = true;
            this.setPRGChipSize(262144);
        } else {
            this.surom = false;
        }
        this.applyState();
    }

    private void applyState() {
        if ((this.regs[0] & 8) != 0) {
            if ((this.regs[0] & 4) != 0) {
                this.mapPRG(16, 0, this.regs[3] & 0xF);
                this.mapPRG(16, 1, 15);
            } else {
                this.mapPRG(16, 0, 0);
                this.mapPRG(16, 1, this.regs[3] & 0xF);
            }
        } else {
            this.mapPRG(32, 0, (this.regs[3] & 0xF) >> 1);
        }
        if (this.surom) {
            this.setPRGChip(this.regs[1] >> 4 & 1);
        }
        if ((this.regs[0] & 0x10) != 0) {
            this.mapCHR(4, 0, this.regs[1]);
            this.mapCHR(4, 1, this.regs[2]);
        } else {
            this.mapCHR(8, 0, this.regs[1] >> 1);
        }
        switch (this.regs[0] & 3) {
            case 0: {
                this.setMirroring(2);
                break;
            }
            case 1: {
                this.setMirroring(3);
                break;
            }
            case 2: {
                this.setMirroring(0);
                break;
            }
            case 3: {
                this.setMirroring(1);
            }
        }
    }

    @Override
    public void writePRGROM(int address, int value) {
        if (this.ticks_since_write <= 1) {
            return;
        }
        this.ticks_since_write = 0;
        if ((value & 0x80) != 0) {
            this.writes = 0;
            this.temp_reg = 0;
            this.regs[0] = this.regs[0] | 0xC;
            this.applyState();
        } else {
            this.temp_reg = (value & 1) << 4 | this.temp_reg >> 1;
            if (++this.writes == 5) {
                this.regs[address >> 13 & 3] = this.temp_reg;
                this.writes = 0;
                this.temp_reg = 0;
                this.applyState();
            }
        }
    }

    @Override
    public final void CPUTick() {
        ++this.ticks_since_write;
    }

    @Override
    public void serialization(SerializationInfo info) throws IOException {
        super.serialization(info);
        this.temp_reg = ByteSerializer.serializationInt(info, this.temp_reg);
        this.writes = ByteSerializer.serializationInt(info, this.writes);
        ByteSerializer.serializationIntArray(info, this.regs);
        this.ticks_since_write = ByteSerializer.serializationInt(info, this.ticks_since_write);
    }
}

